/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.DeviceConfiguratorPanel;
import org.jetbrains.android.uipreview.InvalidOptionValueException;

public abstract class CreateResourceDirectoryDialog
extends DialogWrapper {
    private JComboBox myResourceTypeComboBox;
    private JPanel myDeviceConfiguratorWrapper;
    private JTextField myDirectoryNameTextField;
    private JPanel myContentPanel;
    private JBLabel myErrorLabel;
    private JComboBox mySourceSetCombo;
    private JBLabel mySourceSetLabel;
    private final DeviceConfiguratorPanel myDeviceConfiguratorPanel;
    private InputValidator myValidator;
    private PsiDirectory myResDirectory;

    public CreateResourceDirectoryDialog(Project project, ResourceFolderType resType, PsiDirectory resDirectory, Module module) {
        super(project);
        this.myResDirectory = resDirectory;
        this.$$$setupUI$$$();
        this.myResourceTypeComboBox.setModel(new EnumComboBoxModel(ResourceFolderType.class));
        this.myResourceTypeComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ResourceFolderType) {
                    this.setText(((ResourceFolderType)value).getName());
                }
            }
        });
        this.myDeviceConfiguratorPanel = new DeviceConfiguratorPanel(){

            @Override
            public void applyEditors() {
                try {
                    this.doApplyEditors();
                    FolderConfiguration config = CreateResourceDirectoryDialog.this.myDeviceConfiguratorPanel.getConfiguration();
                    ResourceFolderType selectedResourceType = (ResourceFolderType)CreateResourceDirectoryDialog.this.myResourceTypeComboBox.getSelectedItem();
                    CreateResourceDirectoryDialog.this.myDirectoryNameTextField.setText(selectedResourceType != null ? config.getFolderName(selectedResourceType) : "");
                    CreateResourceDirectoryDialog.this.myErrorLabel.setText("");
                }
                catch (InvalidOptionValueException e) {
                    CreateResourceDirectoryDialog.this.myErrorLabel.setText("<html><body><font color=\"red\">" + e.getMessage() + "</font></body></html>");
                    CreateResourceDirectoryDialog.this.myDirectoryNameTextField.setText("");
                }
                CreateResourceDirectoryDialog.this.setOKActionEnabled(CreateResourceDirectoryDialog.this.myDirectoryNameTextField.getText().length() > 0);
            }
        };
        this.myDeviceConfiguratorWrapper.add((Component)this.myDeviceConfiguratorPanel, "Center");
        this.myResourceTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateResourceDirectoryDialog.this.myDeviceConfiguratorPanel.applyEditors();
            }
        });
        if (resType != null) {
            this.myResourceTypeComboBox.setSelectedItem(resType);
            this.myResourceTypeComboBox.setEnabled(false);
        } else {
            this.myResourceTypeComboBox.setSelectedItem(ResourceFolderType.VALUES);
        }
        AndroidFacet facet = module != null ? AndroidFacet.getInstance(module) : null;
        CreateResourceActionBase.updateSourceSetCombo((JComponent)this.mySourceSetLabel, this.mySourceSetCombo, facet, this.myResDirectory);
        this.myDeviceConfiguratorPanel.updateAll();
        this.setOKActionEnabled(this.myDirectoryNameTextField.getText().length() > 0);
        this.init();
    }

    protected abstract InputValidator createValidator();

    protected void doOKAction() {
        String dirName = this.myDirectoryNameTextField.getText();
        assert (dirName != null);
        this.myValidator = this.createValidator();
        if (this.myValidator.checkInput(dirName) && this.myValidator.canClose(dirName)) {
            super.doOKAction();
        }
    }

    protected String getHelpId() {
        return "reference.new.resource.directory";
    }

    protected String getDimensionServiceKey() {
        return "AndroidCreateResourceDirectoryDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myResourceTypeComboBox.isEnabled()) {
            return this.myResourceTypeComboBox;
        }
        return this.myDirectoryNameTextField;
    }

    public InputValidator getValidator() {
        return this.myValidator;
    }

    public SourceProvider getSourceProvider() {
        return CreateResourceActionBase.getSourceProvider(this.mySourceSetCombo);
    }

    public PsiDirectory getResourceDirectory(DataContext context, boolean create) {
        if (this.myResDirectory != null) {
            return this.myResDirectory;
        }
        if (context != null) {
            Module module = (Module)LangDataKeys.MODULE.getData(context);
            assert (module != null);
            return CreateResourceActionBase.getResourceDirectory(this.getSourceProvider(), module, create);
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JPanel jPanel;
        JComboBox jComboBox2;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setPreferredSize(new Dimension(800, 400));
        this.myResourceTypeComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Resource type:");
        jBLabel3.setDisplayedMnemonic('R');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeviceConfiguratorWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Directory name:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryNameTextField = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(true);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorLabel = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        this.mySourceSetLabel = jBLabel = new JBLabel();
        jBLabel.setText("Source set:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceSetCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel3.setLabelFor(jComboBox2);
        jLabel.setLabelFor(jTextField);
        jBLabel.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

