/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.idea.rendering.ResourceNameValidator;
import com.intellij.CommonBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.xml.refactoring.XmlTagInplaceRenamer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;

public class CreateTypedResourceFileAction
extends CreateResourceActionBase {
    protected final ResourceFolderType myResourceType;
    protected final String myResourcePresentableName;
    protected final String myDefaultRootTag;
    private final boolean myValuesResourceFile;
    private boolean myChooseTagName;

    public CreateTypedResourceFileAction(String resourcePresentableName, ResourceFolderType resourceFolderType, boolean valuesResourceFile, boolean chooseTagName) {
        super(AndroidBundle.message("new.typed.resource.action.title", resourcePresentableName), AndroidBundle.message("new.typed.resource.action.description", resourcePresentableName), StdFileTypes.XML.getIcon());
        this.myResourceType = resourceFolderType;
        this.myResourcePresentableName = resourcePresentableName;
        this.myDefaultRootTag = CreateTypedResourceFileAction.getDefaultRootTagByResourceType(resourceFolderType);
        this.myValuesResourceFile = valuesResourceFile;
        this.myChooseTagName = chooseTagName;
    }

    @Deprecated
    public String getResourceType() {
        return this.myResourceType.getName();
    }

    public ResourceFolderType getResourceFolderType() {
        return this.myResourceType;
    }

    protected InputValidator createValidator(Project project, PsiDirectory directory) {
        return new MyValidator(project, directory);
    }

    @Override
    protected PsiElement[] invokeDialog(Project project, DataContext dataContext) {
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null) {
            AbstractProjectViewPane pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane();
            if (pane instanceof AndroidProjectViewPane) {
                return CreateResourceFileAction.getInstance().invokeDialog(project, dataContext);
            }
            PsiDirectory directory = view.getOrChooseDirectory();
            if (directory != null) {
                InputValidator validator = this.createValidator(project, directory);
                Messages.showInputDialog((Project)project, (String)AndroidBundle.message("new.file.dialog.text", new Object[0]), (String)AndroidBundle.message("new.typed.resource.dialog.title", this.myResourcePresentableName), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
            }
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        return this.doCreateAndNavigate(newName, directory, this.myDefaultRootTag, this.myChooseTagName, true);
    }

    PsiElement[] doCreateAndNavigate(String newName, PsiDirectory directory, String rootTagName, boolean chooseTagName, boolean navigate) throws Exception {
        Project project;
        Editor editor;
        XmlTag rootTag;
        XmlDocument document;
        XmlFile file = AndroidResourceUtil.createFileResource(newName, directory, rootTagName, this.myResourceType.getName(), this.myValuesResourceFile);
        if (navigate) {
            this.doNavigate(file);
        }
        if (chooseTagName && (document = file.getDocument()) != null && (rootTag = document.getRootTag()) != null && (editor = FileEditorManager.getInstance((Project)(project = file.getProject())).getSelectedTextEditor()) != null) {
            CaretModel caretModel = editor.getCaretModel();
            caretModel.moveToOffset(rootTag.getTextOffset() + 1);
            XmlTagInplaceRenamer.rename((Editor)editor, (XmlTag)rootTag);
        }
        return new PsiElement[]{file};
    }

    protected void doNavigate(XmlFile file) {
        if (file.isValid() && LayoutPullParserFactory.isSupported((PsiFile)file)) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) {
                if (AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor()) {
                    new OpenFileDescriptor(file.getProject(), virtualFile, 0).navigate(true);
                } else {
                    new OpenFileDescriptor(file.getProject(), virtualFile).navigate(true);
                }
            }
        } else {
            PsiNavigateUtil.navigate((PsiElement)file);
        }
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        return super.isAvailable(context) && CreateTypedResourceFileAction.doIsAvailable(context, this.myResourceType.getName());
    }

    public boolean isChooseTagName() {
        return this.myChooseTagName;
    }

    public List<String> getAllowedTagNames(AndroidFacet facet) {
        return Collections.singletonList(this.getDefaultRootTag());
    }

    protected final List<String> getSortedAllowedTagNames(AndroidFacet facet) {
        ArrayList<String> result = new ArrayList<String>(this.getAllowedTagNames(facet));
        Collections.sort(result);
        return result;
    }

    public String getDefaultRootTag() {
        return this.myDefaultRootTag;
    }

    static boolean doIsAvailable(DataContext context, final String resourceType) {
        final PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element == null || AndroidFacet.getInstance(element) == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (PsiElement e = element; e != null; e = e.getParent()) {
                    if (!(e instanceof PsiDirectory) || !AndroidResourceUtil.isResourceSubdirectory((PsiDirectory)e, resourceType)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.typed.resource.command.name", this.myResourceType);
    }

    @Override
    protected String getActionName(PsiDirectory directory, String newName) {
        return CreateResourceFileAction.doGetActionName(directory, newName);
    }

    public String toString() {
        return this.myResourcePresentableName;
    }

    public static String getDefaultRootTagByResourceType(ResourceFolderType resourceType) {
        switch (resourceType) {
            case XML: {
                return "PreferenceScreen";
            }
            case DRAWABLE: {
                return "selector";
            }
            case COLOR: {
                return "selector";
            }
            case VALUES: {
                return "resources";
            }
            case MENU: {
                return "menu";
            }
            case ANIM: {
                return "set";
            }
            case ANIMATOR: {
                return "set";
            }
            case LAYOUT: {
                return "LinearLayout";
            }
            case TRANSITION: {
                return "transitionManager";
            }
        }
        throw new IllegalArgumentException("Incorrect resource folder type");
    }

    private class MyValidator
    extends CreateResourceActionBase.MyInputValidator
    implements InputValidatorEx {
        private final ResourceNameValidator myNameValidator;

        public MyValidator(Project project, PsiDirectory directory) {
            super(project, directory);
            this.myNameValidator = CreateTypedResourceFileAction.this.myResourceType == ResourceFolderType.VALUES ? null : ResourceNameValidator.create(true, CreateTypedResourceFileAction.this.myResourceType);
        }

        @Override
        public boolean checkInput(String inputString) {
            return this.getErrorText(inputString) == null;
        }

        public String getErrorText(String inputString) {
            return this.myNameValidator == null ? null : this.myNameValidator.getErrorText(inputString);
        }
    }
}

