/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.android.resources.ResourceType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.augment.AndroidLightClass;
import org.jetbrains.android.augment.PermissionClass;
import org.jetbrains.android.augment.PermissionGroupClass;
import org.jetbrains.android.augment.ResourceTypeClass;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;

public class AndroidPsiAugmentProvider
extends PsiAugmentProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.augment.AndroidPsiAugmentProvider");

    public <Psi extends PsiElement> List<Psi> getAugments(PsiElement element, Class<Psi> type) {
        String resClassName;
        PsiClass parentClass;
        boolean rClassAugment;
        if (type != PsiClass.class && type != PsiField.class || !(element instanceof PsiExtensibleClass)) {
            return Collections.emptyList();
        }
        PsiExtensibleClass aClass = (PsiExtensibleClass)element;
        String className = aClass.getName();
        boolean bl = rClassAugment = "R".equals(className) && type == PsiClass.class;
        if (DumbService.isDumb((Project)element.getProject())) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because of dumb mode");
            }
            return Collections.emptyList();
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because no facet");
            }
            return Collections.emptyList();
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because of no containing file");
            }
            return Collections.emptyList();
        }
        if (type == PsiClass.class) {
            if ("R".equals(className) && AndroidResourceUtil.isRJavaFile(facet, containingFile)) {
                Set<String> existingInnerClasses = AndroidPsiAugmentProvider.getOwnInnerClasses(aClass);
                Set<String> types = ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                ArrayList<ResourceTypeClass> result = new ArrayList<ResourceTypeClass>();
                for (String resType : types) {
                    if (existingInnerClasses.contains(resType)) continue;
                    ResourceTypeClass resClass = new ResourceTypeClass(facet, resType, (PsiClass)aClass);
                    result.add(resClass);
                }
                if (rClassAugment) {
                    LOG.debug("R_CLASS_AUGMENT: " + result.size() + " classes added");
                }
                return result;
            }
            if ("Manifest".equals(className) && AndroidResourceUtil.isManifestJavaFile(facet, containingFile)) {
                return Arrays.asList(new PsiElement[]{new PermissionClass(facet, (PsiClass)aClass), new PermissionGroupClass(facet, (PsiClass)aClass)});
            }
            if (rClassAugment) {
                LOG.debug("R_CLASS_AUGMENT: empty because containing file is not actual R.java file");
            }
        } else if (type == PsiField.class && !(aClass instanceof AndroidLightClass) && (parentClass = aClass.getContainingClass()) != null && "R".equals(parentClass.getName()) && AndroidResourceUtil.isRJavaFile(facet, containingFile) && (resClassName = aClass.getName()) != null && ResourceType.getEnum((String)resClassName) != null) {
            Set<String> existingFields = AndroidPsiAugmentProvider.getOwnFields(aClass);
            PsiField[] newFields = ResourceTypeClass.buildLocalResourceFields(facet, resClassName, (PsiClass)aClass);
            ArrayList<PsiField> result = new ArrayList<PsiField>();
            for (PsiField field : newFields) {
                if (existingFields.contains(field.getName())) continue;
                result.add(field);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static Set<String> getOwnInnerClasses(PsiExtensibleClass aClass) {
        HashSet result = new HashSet();
        for (PsiClass innerClass : aClass.getOwnInnerClasses()) {
            result.add(innerClass.getName());
        }
        return result;
    }

    private static Set<String> getOwnFields(PsiExtensibleClass aClass) {
        HashSet result = new HashSet();
        for (PsiField field : aClass.getOwnFields()) {
            result.add(field.getName());
        }
        return result;
    }
}

