/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.augment;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlElement;
import java.util.List;
import org.jetbrains.android.augment.AndroidLightClass;
import org.jetbrains.android.augment.AndroidLightField;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;

abstract class ManifestInnerClass
extends AndroidLightClass {
    private CachedValue<PsiField[]> myFieldsCache;
    private final AndroidFacet myFacet;

    ManifestInnerClass(AndroidFacet facet, String name, PsiClass context) {
        super(context, name);
        this.myFacet = facet;
    }

    @Override
    public PsiField[] getFields() {
        if (this.myFieldsCache == null) {
            this.myFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PsiField[]>(){

                public CachedValueProvider.Result<PsiField[]> compute() {
                    Manifest manifest = ManifestInnerClass.this.myFacet.getManifest();
                    if (manifest == null) {
                        return CachedValueProvider.Result.create((Object)PsiField.EMPTY_ARRAY, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                    List<Pair<String, String>> pairs = ManifestInnerClass.this.doGetFields(manifest);
                    PsiField[] result = new PsiField[pairs.size()];
                    PsiClassType stringType = PsiType.getJavaLangString((PsiManager)ManifestInnerClass.this.myManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)ManifestInnerClass.this.getProject()));
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ManifestInnerClass.this.getProject());
                    int i = 0;
                    for (Pair<String, String> pair : pairs) {
                        AndroidLightField field = new AndroidLightField((String)pair.getFirst(), ManifestInnerClass.this, (PsiType)stringType, true, pair.getSecond());
                        field.setInitializer(factory.createExpressionFromText("\"" + (String)pair.getSecond() + "\"", (PsiElement)field));
                        result[i++] = field;
                    }
                    XmlElement xmlElement = manifest.getXmlElement();
                    PsiFile psiManifestFile = xmlElement != null ? xmlElement.getContainingFile() : null;
                    return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiManifestFile != null ? psiManifestFile : PsiModificationTracker.MODIFICATION_COUNT});
                }
            });
        }
        return (PsiField[])this.myFieldsCache.getValue();
    }

    protected abstract List<Pair<String, String>> doGetFields(Manifest var1);
}

