/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.fileTypes.AndroidRenderscriptFileType;
import com.android.tools.idea.lang.aidl.AidlFileType;
import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.compiler.AndroidAutogenerator;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.ProguardRunningOptions;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactType;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class AndroidCompileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidCompileUtil");
    private static final Key<Boolean> RELEASE_BUILD_KEY = new Key("RELEASE_BUILD_KEY");
    @NonNls
    private static final String RESOURCES_CACHE_DIR_NAME = "res-cache";
    @NonNls
    private static final String GEN_MODULE_PREFIX = "~generated_";
    @NonNls
    public static final String OLD_PROGUARD_CFG_FILE_NAME = "proguard.cfg";
    public static final String UNSIGNED_SUFFIX = ".unsigned";
    public static Key<String> PROGUARD_CFG_PATHS_KEY = Key.create((String)"ANDROID_PROGUARD_CFG_PATHS");

    private AndroidCompileUtil() {
    }

    public static <T> Map<CompilerMessageCategory, T> toCompilerMessageCategoryKeys(Map<AndroidCompilerMessageKind, T> map) {
        HashMap result = new HashMap();
        for (Map.Entry<AndroidCompilerMessageKind, T> entry : map.entrySet()) {
            AndroidCompilerMessageKind key = entry.getKey();
            T value = entry.getValue();
            switch (key) {
                case ERROR: {
                    result.put(CompilerMessageCategory.ERROR, value);
                    break;
                }
                case INFORMATION: {
                    result.put(CompilerMessageCategory.INFORMATION, value);
                    break;
                }
                case WARNING: {
                    result.put(CompilerMessageCategory.WARNING, value);
                }
            }
        }
        return result;
    }

    public static Pair<VirtualFile, Boolean> getDefaultProguardConfigFile(AndroidFacet facet) {
        VirtualFile root = AndroidRootUtil.getMainContentRoot(facet);
        if (root == null) {
            return null;
        }
        VirtualFile proguardCfg = root.findChild("proguard-project.txt");
        if (proguardCfg != null) {
            return new Pair((Object)proguardCfg, (Object)true);
        }
        VirtualFile oldProguardCfg = root.findChild(OLD_PROGUARD_CFG_FILE_NAME);
        if (oldProguardCfg != null) {
            return new Pair((Object)oldProguardCfg, (Object)false);
        }
        return null;
    }

    public static void addMessages(CompileContext context, Map<CompilerMessageCategory, List<String>> messages, Module module) {
        AndroidCompileUtil.addMessages(context, messages, null, module);
    }

    static void addMessages(final CompileContext context, final Map<CompilerMessageCategory, List<String>> messages, final Map<VirtualFile, VirtualFile> presentableFilesMap, final Module module) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (context.getProject().isDisposed()) {
                    return;
                }
                for (CompilerMessageCategory category : messages.keySet()) {
                    List messageList = (List)messages.get(category);
                    for (String message : messageList) {
                        String fileName;
                        String url = null;
                        int line = -1;
                        Matcher matcher = AndroidCommonUtils.COMPILER_MESSAGE_PATTERN.matcher(message);
                        if (matcher.matches() && new File(fileName = matcher.group(1)).exists()) {
                            url = AndroidCompileUtil.getPresentableFile("file://" + fileName, presentableFilesMap);
                            line = Integer.parseInt(matcher.group(2));
                        }
                        context.addMessage(category, (module != null ? '[' + module.getName() + "] " : "") + message, url, line, -1);
                    }
                }
            }
        });
    }

    private static String getPresentableFile(String url, Map<VirtualFile, VirtualFile> presentableFilesMap) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return url;
        }
        if (presentableFilesMap == null) {
            return url;
        }
        for (Map.Entry<VirtualFile, VirtualFile> entry : presentableFilesMap.entrySet()) {
            if (!Comparing.equal((Object)file, (Object)entry.getValue())) continue;
            return entry.getKey().getUrl();
        }
        return url;
    }

    private static void collectChildrenRecursively(VirtualFile root, VirtualFile anchor, Collection<VirtualFile> result) {
        if (Comparing.equal((Object)root, (Object)anchor)) {
            return;
        }
        VirtualFile parent = anchor.getParent();
        if (parent == null) {
            return;
        }
        for (VirtualFile child : parent.getChildren()) {
            if (Comparing.equal((Object)child, (Object)anchor)) continue;
            result.add(child);
        }
        if (!Comparing.equal((Object)parent, (Object)root)) {
            AndroidCompileUtil.collectChildrenRecursively(root, parent, result);
        }
    }

    private static void unexcludeRootIfNecessary(VirtualFile root, ModifiableRootModel model, Ref<Boolean> modelChangedFlag) {
        VirtualFile excludedRoot;
        HashSet excludedRoots = new HashSet(Arrays.asList(model.getExcludeRoots()));
        for (excludedRoot = root; excludedRoot != null && !excludedRoots.contains(excludedRoot); excludedRoot = excludedRoot.getParent()) {
        }
        if (excludedRoot == null) {
            return;
        }
        HashSet rootsToExclude = new HashSet();
        AndroidCompileUtil.collectChildrenRecursively(excludedRoot, root, (Collection<VirtualFile>)rootsToExclude);
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model, excludedRoot);
        if (contentEntry != null) {
            if (contentEntry.removeExcludeFolder(excludedRoot.getUrl())) {
                modelChangedFlag.set((Object)true);
            }
            for (VirtualFile rootToExclude : rootsToExclude) {
                if (excludedRoots.contains(rootToExclude)) continue;
                contentEntry.addExcludeFolder(rootToExclude);
                modelChangedFlag.set((Object)true);
            }
        }
    }

    private static String getGenModuleName(Module module) {
        return GEN_MODULE_PREFIX + module.getName();
    }

    public static VirtualFile createSourceRootIfNotExist(String path, ModifiableRootModel model, Ref<Boolean> modelChangedFlag) {
        boolean created;
        ApplicationManager.getApplication().assertIsDispatchThread();
        File rootFile = new File(path);
        if (!rootFile.exists()) {
            if (!rootFile.mkdirs()) {
                return null;
            }
            created = true;
        } else {
            created = false;
        }
        Module module = model.getModule();
        Project project = module.getProject();
        if (project.isDisposed() || module.isDisposed()) {
            return null;
        }
        VirtualFile root = created ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(rootFile) : LocalFileSystem.getInstance().findFileByIoFile(rootFile);
        if (root != null) {
            AndroidCompileUtil.unexcludeRootIfNecessary(root, model, modelChangedFlag);
            boolean markedAsSource = false;
            for (VirtualFile existingRoot : model.getSourceRoots()) {
                if (!Comparing.equal((Object)existingRoot, (Object)root)) continue;
                markedAsSource = true;
            }
            if (markedAsSource) {
                AndroidCompileUtil.markRootAsGenerated(model, root, modelChangedFlag);
            } else {
                AndroidCompileUtil.addSourceRoot(model, root);
                modelChangedFlag.set((Object)true);
            }
        }
        return root;
    }

    private static void markRootAsGenerated(ModifiableRootModel model, VirtualFile root, Ref<Boolean> modelChangedFlag) {
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model, root);
        if (contentEntry == null) {
            return;
        }
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            JavaSourceRootProperties props;
            if (!root.equals(sourceFolder.getFile()) || (props = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) == null) continue;
            props.setForGeneratedSources(true);
            modelChangedFlag.set((Object)true);
            break;
        }
    }

    private static void excludeFromCompilation(Project project, VirtualFile sourceRoot, String aPackage) {
        String buildConfigPath = sourceRoot.getPath() + '/' + aPackage.replace('.', '/') + "/BuildConfig.java";
        String url = VfsUtilCore.pathToUrl((String)buildConfigPath);
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        for (ExcludeEntryDescription description : configuration.getExcludeEntryDescriptions()) {
            if (!Comparing.equal((String)description.getUrl(), (String)url)) continue;
            return;
        }
        configuration.addExcludeEntryDescription(new ExcludeEntryDescription(url, true, false, (Disposable)project));
    }

    private static void excludeFromCompilation(Project project, VirtualFile dir) {
        ExcludesConfiguration configuration = CompilerConfiguration.getInstance((Project)project).getExcludedEntriesConfiguration();
        for (ExcludeEntryDescription description : configuration.getExcludeEntryDescriptions()) {
            if (!Comparing.equal((Object)description.getVirtualFile(), (Object)dir)) continue;
            return;
        }
        configuration.addExcludeEntryDescription(new ExcludeEntryDescription(dir, true, false, (Disposable)project));
    }

    private static void removeGenModule(ModifiableRootModel model, Ref<Boolean> modelChangedFlag) {
        String genModuleName = AndroidCompileUtil.getGenModuleName(model.getModule());
        final Project project = model.getProject();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module genModule = moduleManager.findModuleByName(genModuleName);
        if (genModule == null) {
            return;
        }
        for (OrderEntry entry : model.getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry) || !genModuleName.equals(((ModuleOrderEntry)entry).getModuleName())) continue;
            model.removeOrderEntry(entry);
            modelChangedFlag.set((Object)true);
        }
        final VirtualFile moduleFile = genModule.getModuleFile();
        moduleManager.disposeModule(genModule);
        if (moduleFile != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                moduleFile.delete((Object)project);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
    }

    public static SourceFolder addSourceRoot(final ModifiableRootModel model, VirtualFile root) {
        ContentEntry contentEntry = AndroidCompileUtil.findContentEntryForRoot(model, root);
        if (contentEntry == null) {
            final Project project = model.getProject();
            String message = "Cannot mark directory '" + FileUtil.toSystemDependentName((String)root.getPath()) + "' as source root, because it is not located under content root of module '" + model.getModule().getName() + "'\n<a href='fix'>Open Project Structure</a>";
            Notification notification = new Notification(AndroidBundle.message("android.autogeneration.notification.group", new Object[0]), "Autogeneration Error", message, NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                    notification.expire();
                    final ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)project);
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

                        @Override
                        public void run() {
                            Module module = model.getModule();
                            AndroidFacet facet = AndroidFacet.getInstance(module);
                            if (facet != null) {
                                configurable.select((Facet)facet, true);
                            }
                        }
                    });
                }
            });
            Notifications.Bus.notify((Notification)notification, (Project)project);
            LOG.debug(message);
            return null;
        }
        return contentEntry.addSourceFolder(root, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE, (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties("", true));
    }

    public static ContentEntry findContentEntryForRoot(ModifiableRootModel model, VirtualFile root) {
        ContentEntry contentEntry = null;
        for (ContentEntry candidate : model.getContentEntries()) {
            VirtualFile contentRoot = candidate.getFile();
            if (contentRoot == null || !VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)root, (boolean)false)) continue;
            contentEntry = candidate;
        }
        return contentEntry;
    }

    public static void generate(Module module, AndroidAutogeneratorMode mode) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            facet.scheduleSourceRegenerating(mode);
        }
    }

    public static boolean doGenerate(AndroidFacet facet, AndroidAutogeneratorMode mode) {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        final CompileContext[] contextWrapper = new CompileContext[1];
        final Module module = facet.getModule();
        final Project project = module.getProject();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                CompilerTask task = new CompilerTask(project, "Android auto-generation", true, false, true, true);
                ModuleCompileScope scope = new ModuleCompileScope(module, false);
                contextWrapper[0] = new CompileContextImpl(project, task, (CompileScope)scope, false, false);
            }
        });
        CompileContext context = contextWrapper[0];
        if (context == null) {
            return false;
        }
        AndroidCompileUtil.generate(facet, mode, context, false);
        return context.getMessages(CompilerMessageCategory.ERROR).length == 0;
    }

    public static boolean isModuleAffected(CompileContext context, Module module) {
        return ArrayUtil.find((Object[])context.getCompileScope().getAffectedModules(), (Object)module) >= 0;
    }

    public static void generate(AndroidFacet facet, AndroidAutogeneratorMode mode, CompileContext context, boolean force) {
        if (context == null) {
            return;
        }
        AndroidAutogenerator.run(mode, facet, context, force);
    }

    public static void removeDuplicatingClasses(Module module, String packageName, String className, File classFile, String sourceRootPath) {
        if (sourceRootPath == null) {
            return;
        }
        VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByPath(sourceRootPath);
        if (sourceRoot == null) {
            return;
        }
        final Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        String interfaceQualifiedName = packageName + '.' + className;
        PsiClass[] classes = facade.findClasses(interfaceQualifiedName, GlobalSearchScope.moduleScope((Module)module));
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiClass c : classes) {
            String path;
            File f;
            VirtualFile virtualFile;
            PsiFile psiFile = c.getContainingFile();
            if (!className.equals(FileUtil.getNameWithoutExtension((String)psiFile.getName())) || (virtualFile = psiFile.getVirtualFile()) == null || !Comparing.equal((Object)projectFileIndex.getSourceRootForFile(virtualFile), (Object)sourceRoot) || FileUtil.filesEqual((File)(f = new File(path = virtualFile.getPath())), (File)classFile) || !f.exists()) continue;
            if (f.delete()) {
                virtualFile.refresh(true, false);
                continue;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((Project)project, (String)("Can't delete file " + path), (String)CommonBundle.getErrorTitle());
                }
            }, project.getDisposed());
        }
    }

    public static String findResourcesCacheDirectory(Module module, boolean createIfNotFound, CompileContext context) {
        Project project = module.getProject();
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)project);
        if (extension == null) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot get compiler settings for project " + project.getName(), null, -1, -1);
            }
            return null;
        }
        String projectOutputDirUrl = extension.getCompilerOutputUrl();
        if (projectOutputDirUrl == null) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot find output directory for project " + project.getName(), null, -1, -1);
            }
            return null;
        }
        String pngCacheDirPath = VfsUtil.urlToPath((String)projectOutputDirUrl) + '/' + RESOURCES_CACHE_DIR_NAME + '/' + module.getName();
        String pngCacheDirOsPath = FileUtil.toSystemDependentName((String)pngCacheDirPath);
        File pngCacheDir = new File(pngCacheDirOsPath);
        if (pngCacheDir.exists()) {
            if (pngCacheDir.isDirectory()) {
                return pngCacheDirOsPath;
            }
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + pngCacheDirOsPath + " because file already exists", null, -1, -1);
            }
            return null;
        }
        if (!createIfNotFound) {
            return null;
        }
        if (!pngCacheDir.mkdirs()) {
            if (context != null) {
                context.addMessage(CompilerMessageCategory.ERROR, "Cannot create directory " + pngCacheDirOsPath, null, -1, -1);
            }
            return null;
        }
        return pngCacheDirOsPath;
    }

    public static boolean isFullBuild(CompileContext context) {
        return AndroidCompileUtil.isFullBuild(context.getCompileScope());
    }

    public static boolean isFullBuild(CompileScope scope) {
        RunConfiguration c = CompileStepBeforeRun.getRunConfiguration((CompileScope)scope);
        return c == null || !AndroidCommonUtils.isTestConfiguration((String)c.getType().getId());
    }

    public static boolean isReleaseBuild(CompileContext context) {
        Boolean value = (Boolean)context.getCompileScope().getUserData(RELEASE_BUILD_KEY);
        if (value != null && value.booleanValue()) {
            return true;
        }
        Project project = context.getProject();
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)false);
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                AndroidArtifactSigningMode signingMode;
                ArtifactProperties properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance());
                if (!(properties instanceof AndroidApplicationArtifactProperties) || (signingMode = ((AndroidApplicationArtifactProperties)properties).getSigningMode()) == AndroidArtifactSigningMode.DEBUG || signingMode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) continue;
                return true;
            }
        }
        return false;
    }

    public static void setReleaseBuild(CompileScope compileScope) {
        compileScope.putUserData(RELEASE_BUILD_KEY, (Object)Boolean.TRUE);
    }

    public static boolean createGenModulesAndSourceRoots(AndroidFacet facet, ModifiableRootModel model) {
        String aidlGenRootPath;
        String aptGenRootPath;
        String renderscriptGenRootPath;
        if (facet.requiresAndroidModel() || !facet.getProperties().ENABLE_SOURCES_AUTOGENERATION) {
            return false;
        }
        Module module = facet.getModule();
        GlobalSearchScope moduleScope = facet.getModule().getModuleScope();
        Ref modelChangedFlag = Ref.create((Object)false);
        if (facet.isLibraryProject()) {
            AndroidCompileUtil.removeGenModule(model, (Ref<Boolean>)modelChangedFlag);
        }
        HashSet genRootsToCreate = new HashSet();
        HashSet genRootsToInit = new HashSet();
        String buildConfigGenRootPath = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet);
        if (buildConfigGenRootPath != null) {
            genRootsToCreate.add(buildConfigGenRootPath);
        }
        if ((renderscriptGenRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet)) != null) {
            boolean createIfNotExist = FileTypeIndex.getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, (GlobalSearchScope)moduleScope).size() > 0;
            (createIfNotExist ? genRootsToCreate : genRootsToInit).add(renderscriptGenRootPath);
        }
        if ((aptGenRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet)) != null) {
            genRootsToCreate.add(aptGenRootPath);
        }
        if ((aidlGenRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet)) != null) {
            boolean createIfNotExist = FileTypeIndex.getFiles((FileType)AidlFileType.INSTANCE, (GlobalSearchScope)moduleScope).size() > 0;
            (createIfNotExist ? genRootsToCreate : genRootsToInit).add(aidlGenRootPath);
        }
        genRootsToInit.addAll(genRootsToCreate);
        for (String genRootPath : genRootsToInit) {
            AndroidCompileUtil.initializeGenSourceRoot(model, genRootPath, genRootsToCreate.contains(genRootPath), true, (Ref<Boolean>)modelChangedFlag);
        }
        return (Boolean)modelChangedFlag.get();
    }

    private static void excludeAllBuildConfigsFromCompilation(AndroidFacet facet, VirtualFile sourceRoot) {
        String aPackage;
        Module module = facet.getModule();
        Project project = module.getProject();
        HashSet packages = new HashSet();
        Manifest manifest = facet.getManifest();
        String string = aPackage = manifest != null ? manifest.getPackage().getStringValue() : null;
        if (aPackage != null) {
            packages.add(aPackage);
        }
        packages.addAll(AndroidUtils.getDepLibsPackages(module));
        for (String p : packages) {
            AndroidCompileUtil.excludeFromCompilation(project, sourceRoot, p);
        }
    }

    private static void includeAaptGenSourceRootToCompilation(AndroidFacet facet) {
        Project project = facet.getModule().getProject();
        ExcludesConfiguration configuration = ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project)).getExcludedEntriesConfiguration();
        ExcludeEntryDescription[] descriptions = configuration.getExcludeEntryDescriptions();
        configuration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : descriptions) {
            VirtualFile vFile = description.getVirtualFile();
            if (Comparing.equal((Object)vFile, (Object)AndroidRootUtil.getAaptGenDir(facet))) continue;
            configuration.addExcludeEntryDescription(description);
        }
    }

    private static VirtualFile initializeGenSourceRoot(ModifiableRootModel model, String sourceRootPath, boolean createIfNotExist, boolean excludeInNonExternalMode, Ref<Boolean> modelChangedFlag) {
        VirtualFile root;
        if (sourceRootPath == null) {
            return null;
        }
        VirtualFile sourceRoot = null;
        if (createIfNotExist && (root = AndroidCompileUtil.createSourceRootIfNotExist(sourceRootPath, model, modelChangedFlag)) != null) {
            sourceRoot = root;
        }
        if (sourceRoot == null) {
            sourceRoot = LocalFileSystem.getInstance().findFileByPath(sourceRootPath);
        }
        if (sourceRoot != null && excludeInNonExternalMode) {
            Module module = model.getModule();
            CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)module.getProject());
        }
        return sourceRoot;
    }

    public static String[] toOsPaths(VirtualFile[] classFilesDirs) {
        String[] classFilesDirOsPaths = new String[classFilesDirs.length];
        for (int i = 0; i < classFilesDirs.length; ++i) {
            classFilesDirOsPaths[i] = FileUtil.toSystemDependentName((String)classFilesDirs[i].getPath());
        }
        return classFilesDirOsPaths;
    }

    public static Map<CompilerMessageCategory, List<String>> execute(String ... argv) throws IOException {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Map messages = AndroidExecutionUtil.doExecute((String[])argv);
        return AndroidCompileUtil.toCompilerMessageCategoryKeys(messages);
    }

    public static String getApkName(Module module) {
        return module.getName() + ".apk";
    }

    public static String getOutputPackage(Module module) {
        VirtualFile compilerOutput = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
        if (compilerOutput == null) {
            return null;
        }
        return new File(compilerOutput.getPath(), AndroidCompileUtil.getApkName(module)).getPath();
    }

    public static boolean isExcludedFromCompilation(File file, Project project) {
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        return vFile != null && AndroidCompileUtil.isExcludedFromCompilation(vFile, project);
    }

    public static boolean isExcludedFromCompilation(VirtualFile child, Project project) {
        CompilerManager compilerManager;
        CompilerManager compilerManager2 = compilerManager = project != null ? CompilerManager.getInstance((Project)project) : null;
        if (compilerManager == null) {
            return false;
        }
        if (!compilerManager.isExcludedFromCompilation(child)) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)child, (Project)project);
        if (module == null) {
            return true;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || !facet.isLibraryProject()) {
            return true;
        }
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            return true;
        }
        return platform.getSdkData().getPlatformToolsRevision() > 7;
    }

    public static ProguardRunningOptions getProguardConfigFilePathIfShouldRun(AndroidFacet facet, CompileContext context) {
        String[] paths;
        String pathsStr = (String)context.getCompileScope().getUserData(PROGUARD_CFG_PATHS_KEY);
        if (pathsStr != null && (paths = pathsStr.split(File.pathSeparator)).length > 0) {
            return new ProguardRunningOptions(Arrays.asList(paths));
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(facet.getModule());
        String sdkHomePath = platform != null ? FileUtil.toCanonicalPath((String)platform.getSdkData().getPath()) : null;
        Project project = context.getProject();
        Set artifacts = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)false);
        for (Artifact artifact : artifacts) {
            AndroidApplicationArtifactProperties p;
            ArtifactProperties properties;
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !facet.equals((Object)AndroidArtifactUtil.getPackagedFacet(project, artifact)) || !((properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) || !(p = (AndroidApplicationArtifactProperties)properties).isRunProGuard()) continue;
            List<String> paths2 = AndroidUtils.urlsToOsPaths(p.getProGuardCfgFiles(), sdkHomePath);
            return new ProguardRunningOptions(paths2);
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        JpsAndroidModuleProperties properties = configuration.getState();
        if (properties != null && properties.RUN_PROGUARD) {
            List urls = properties.myProGuardCfgFiles;
            List<String> paths3 = AndroidUtils.urlsToOsPaths(urls, sdkHomePath);
            return new ProguardRunningOptions(paths3);
        }
        return null;
    }

    public static Module findCircularDependencyOnLibraryWithSamePackage(AndroidFacet facet) {
        String aPackage;
        Manifest manifest = facet.getManifest();
        String string = aPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
        if (aPackage == null) {
            return null;
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            List<AndroidFacet> depDependencies;
            Manifest depManifest = depFacet.getManifest();
            String depPackage = depManifest != null ? (String)depManifest.getPackage().getValue() : null;
            if (!aPackage.equals(depPackage) || !(depDependencies = AndroidUtils.getAllAndroidDependencies(depFacet.getModule(), false)).contains((Object)facet)) continue;
            return depFacet.getModule();
        }
        return null;
    }

    public static String[] getLibPackages(Module module, String packageName) {
        HashSet packageSet = new HashSet();
        packageSet.add(packageName);
        ArrayList<String> result = new ArrayList<String>();
        for (String libPackage : AndroidUtils.getDepLibsPackages(module)) {
            if (!packageSet.add(libPackage)) continue;
            result.add(libPackage);
        }
        return ArrayUtil.toStringArray(result);
    }

    public static boolean isLibraryWithBadCircularDependency(AndroidFacet facet) {
        if (!facet.isLibraryProject()) {
            return false;
        }
        List<AndroidFacet> dependencies = AndroidUtils.getAllAndroidDependencies(facet.getModule(), false);
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        String aPackage = (String)manifest.getPackage().getValue();
        if (aPackage == null || aPackage.length() == 0) {
            return false;
        }
        for (AndroidFacet depFacet : dependencies) {
            List<AndroidFacet> depDependencies = AndroidUtils.getAllAndroidDependencies(depFacet.getModule(), true);
            if (!depDependencies.contains((Object)facet) || !dependencies.contains((Object)depFacet) || depFacet.getModule().getName().compareTo(facet.getModule().getName()) >= 0 && depFacet.isLibraryProject()) continue;
            return true;
        }
        return false;
    }

    public static String getUnsignedApkPath(AndroidFacet facet) {
        return AndroidRootUtil.getApkPath(facet);
    }

    public static void reportException(CompileContext context, String messagePrefix, Exception e) {
        context.addMessage(CompilerMessageCategory.ERROR, messagePrefix + e.getClass().getSimpleName() + ": " + e.getMessage(), null, -1, -1);
    }

    public static String getAaptManifestPackage(AndroidFacet facet) {
        if (facet.getProperties().USE_CUSTOM_MANIFEST_PACKAGE) {
            return facet.getProperties().CUSTOM_MANIFEST_PACKAGE;
        }
        Manifest manifest = facet.getManifest();
        return manifest != null ? manifest.getPackage().getStringValue() : null;
    }

    public static void createGenModulesAndSourceRoots(Project project, final Collection<AndroidFacet> facets) {
        if (project.isDisposed()) {
            return;
        }
        final ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ArrayList<ModifiableRootModel> modelsToCommit = new ArrayList<ModifiableRootModel>();
                for (AndroidFacet facet : facets) {
                    Module module;
                    if (facet.requiresAndroidModel() || (module = facet.getModule()).isDisposed()) continue;
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    if (AndroidCompileUtil.createGenModulesAndSourceRoots(facet, model)) {
                        modelsToCommit.add(model);
                        continue;
                    }
                    model.dispose();
                }
                if (modelsToCommit.size() == 0) {
                    return;
                }
                ModifiableModelCommitter.multiCommit((ModifiableRootModel[])modelsToCommit.toArray(new ModifiableRootModel[modelsToCommit.size()]), (ModifiableModuleModel)moduleModel);
            }
        });
    }
}

