/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.FacetBasedPackagingSourceItemsProvider;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElementType;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackagePresentation;
import org.jetbrains.android.facet.AndroidFacet;

public class AndroidSourceItemsProvider
extends FacetBasedPackagingSourceItemsProvider<AndroidFacet, AndroidFinalPackageElement> {
    public AndroidSourceItemsProvider() {
        super(AndroidFacet.ID, (PackagingElementType)AndroidFinalPackageElementType.getInstance());
    }

    protected AndroidFinalPackagePresentation createPresentation(AndroidFacet facet) {
        return new AndroidFinalPackagePresentation((FacetPointer<AndroidFacet>)FacetPointersManager.getInstance((Project)facet.getModule().getProject()).create((Facet)facet));
    }

    protected AndroidFinalPackageElement createElement(ArtifactEditorContext context, AndroidFacet facet) {
        return new AndroidFinalPackageElement(context.getProject(), facet);
    }

    public Collection<? extends PackagingSourceItem> getSourceItems(ArtifactEditorContext editorContext, Artifact artifact, PackagingSourceItem parent) {
        if (parent instanceof ModuleSourceItemGroup && !AndroidArtifactUtil.containsAndroidPackage(editorContext, artifact)) {
            Module module = ((ModuleSourceItemGroup)parent).getModule();
            HashSet facets = new HashSet(editorContext.getFacetsProvider().getFacetsByType(module, AndroidFacet.ID));
            if (facets.size() > 0) {
                return Collections.singletonList(new FacetBasedPackagingSourceItemsProvider.FacetBasedSourceItem((FacetBasedPackagingSourceItemsProvider)this, (Facet)facets.iterator().next()));
            }
        }
        return Collections.emptyList();
    }

    protected AndroidFacet getFacet(AndroidFinalPackageElement element) {
        return element.getFacet();
    }
}

