/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.CommonBundle;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.Border;
import org.jetbrains.android.exportSignedPackage.NewKeyForm;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.SaveFileListener;

public class NewKeyStoreDialog
extends DialogWrapper {
    private JPanel myNewKeyPanel;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myKeyStorePathField;
    private JPasswordField myPasswordField;
    private JPasswordField myConfirmedPassword;
    private final NewKeyForm myNewKeyForm;
    private final Project myProject;

    public NewKeyStoreDialog(Project project, String defaultKeyStorePath) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myKeyStorePathField.setText(defaultKeyStorePath);
        this.setTitle("New Key Store");
        this.myNewKeyForm = new MyNewKeyForm();
        this.myNewKeyPanel.add((Component)this.myNewKeyForm.getContentPanel(), "Center");
        this.myKeyStorePathField.addActionListener((ActionListener)new SaveFileListener(this.myPanel, this.myKeyStorePathField, AndroidBundle.message("android.extract.package.choose.keystore.title", new Object[0]), "jks"){

            @Override
            protected String getDefaultLocation() {
                return NewKeyStoreDialog.this.getKeyStorePath();
            }
        });
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myKeyStorePathField;
    }

    protected void doOKAction() {
        if (this.getKeyStorePath().length() == 0) {
            Messages.showErrorDialog((Component)this.myPanel, (String)"Specify key store path", (String)CommonBundle.getErrorTitle());
            return;
        }
        try {
            AndroidUtils.checkNewPassword(this.myPasswordField, this.myConfirmedPassword);
            this.myNewKeyForm.createKey();
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog((Component)this.myPanel, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return;
        }
        super.doOKAction();
    }

    public String getKeyStorePath() {
        return this.myKeyStorePathField.getText().trim();
    }

    public char[] getKeyStorePassword() {
        return this.myPasswordField.getPassword();
    }

    public String getKeyAlias() {
        return this.myNewKeyForm.getKeyAlias();
    }

    public char[] getKeyPassword() {
        return this.myNewKeyForm.getKeyPassword();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPasswordField jPasswordField;
        JPasswordField jPasswordField2;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key store path:");
        jBLabel.setDisplayedMnemonic('K');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myKeyStorePathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myNewKeyPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Key", (int)0, (int)0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Password:");
        jBLabel2.setDisplayedMnemonic('P');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel2.add((Component)jPasswordField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Confirm:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConfirmedPassword = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel2.setLabelFor(jPasswordField2);
        jLabel.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyNewKeyForm
    extends NewKeyForm {
        private MyNewKeyForm() {
        }

        @Override
        protected List<String> getExistingKeyAliasList() {
            return Collections.emptyList();
        }

        @Override
        protected Project getProject() {
            return NewKeyStoreDialog.this.myProject;
        }

        @Override
        protected char[] getKeyStorePassword() {
            return NewKeyStoreDialog.this.getKeyStorePassword();
        }

        @Override
        protected String getKeyStoreLocation() {
            return NewKeyStoreDialog.this.getKeyStorePath();
        }
    }
}

