/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.converter;

import com.intellij.conversion.ModuleSettings;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.annotations.NonNls;

class AndroidConversionUtil {
    @NonNls
    static final String OPTION_VALUE_ATTRIBUTE = "value";

    private AndroidConversionUtil() {
    }

    public static String getOptionValue(Element e, String optionName) {
        Element element = AndroidConversionUtil.getOptionElement(e, optionName);
        return element != null ? element.getAttributeValue(OPTION_VALUE_ATTRIBUTE) : null;
    }

    public static Element getOptionElement(Element e, String optionName) {
        for (Element optionElement : e.getChildren("option")) {
            if (!optionName.equals(optionElement.getAttributeValue("name"))) continue;
            return optionElement;
        }
        return null;
    }

    public static Element findAndroidFacetConfigurationElement(ModuleSettings moduleSettings) {
        Collection facetElements;
        AndroidFacetType facetType;
        if (moduleSettings != null && (facetType = AndroidFacet.getFacetType()) != null && !(facetElements = moduleSettings.getFacetElements(facetType.getStringId())).isEmpty()) {
            return ((Element)facetElements.iterator().next()).getChild("configuration");
        }
        return null;
    }
}

