/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceType;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.DimensionConverter;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.converters.FragmentClassConverter;
import org.jetbrains.android.dom.converters.IntegerConverter;
import org.jetbrains.android.dom.converters.LightFlagConverter;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.layout.LayoutElement;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.ManifestElement;
import org.jetbrains.android.dom.manifest.Provider;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.menu.Group;
import org.jetbrains.android.dom.menu.Menu;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.IntegerArray;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.resources.StringArray;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyledText;
import org.jetbrains.android.dom.xml.PreferenceElement;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;

public class AndroidDomUtil {
    public static final StaticEnumConverter BOOLEAN_CONVERTER = new StaticEnumConverter("true", "false");
    public static final Map<String, String> SPECIAL_RESOURCE_TYPES = Maps.newHashMapWithExpectedSize((int)20);
    private static final PackageClassConverter ACTIVITY_CONVERTER = new PackageClassConverter("android.app.Activity");
    private static final FragmentClassConverter FRAGMENT_CLASS_CONVERTER = new FragmentClassConverter();

    private AndroidDomUtil() {
    }

    public static String getResourceType(AttributeFormat format) {
        switch (format) {
            case Color: {
                return ResourceType.COLOR.getName();
            }
            case Dimension: {
                return ResourceType.DIMEN.getName();
            }
            case String: {
                return ResourceType.STRING.getName();
            }
            case Float: 
            case Integer: {
                return ResourceType.INTEGER.getName();
            }
            case Fraction: {
                return ResourceType.FRACTION.getName();
            }
            case Boolean: {
                return ResourceType.BOOL.getName();
            }
        }
        return null;
    }

    public static ResolvingConverter<String> getStringConverter(AttributeFormat format, String[] values) {
        switch (format) {
            case Enum: {
                return new StaticEnumConverter(values);
            }
            case Boolean: {
                return BOOLEAN_CONVERTER;
            }
            case Integer: {
                return IntegerConverter.INSTANCE;
            }
            case Dimension: {
                return DimensionConverter.INSTANCE;
            }
        }
        return null;
    }

    public static ResourceReferenceConverter getResourceReferenceConverter(AttributeDefinition attr) {
        boolean containsReference = false;
        boolean containsNotReference = false;
        HashSet<String> resourceTypes = new HashSet<String>();
        Set<AttributeFormat> formats = attr.getFormats();
        for (AttributeFormat format : formats) {
            String type;
            if (format == AttributeFormat.Reference) {
                containsReference = true;
            } else {
                containsNotReference = true;
            }
            if ((type = AndroidDomUtil.getResourceType(format)) == null) continue;
            resourceTypes.add(type);
        }
        String specialResourceType = AndroidDomUtil.getSpecialResourceType(attr.getName());
        if (specialResourceType != null) {
            resourceTypes.add(specialResourceType);
        }
        if (containsReference) {
            if (resourceTypes.contains(ResourceType.COLOR.getName())) {
                resourceTypes.add(ResourceType.DRAWABLE.getName());
            }
            if (resourceTypes.size() == 0) {
                resourceTypes.addAll(AndroidResourceUtil.getNames(AndroidResourceUtil.REFERRABLE_RESOURCE_TYPES));
            }
        }
        if (resourceTypes.size() > 0) {
            ResourceReferenceConverter converter = new ResourceReferenceConverter(resourceTypes);
            converter.setAllowLiterals(containsNotReference);
            return converter;
        }
        return null;
    }

    public static ResolvingConverter<String> simplify(CompositeConverter composite) {
        switch (composite.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return composite.getConverters().get(0);
            }
        }
        return composite;
    }

    public static Converter getSpecificConverter(XmlName attrName, DomElement context) {
        if (context == null) {
            return null;
        }
        if (!"http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            return null;
        }
        XmlTag xmlTag = context.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        String localName = attrName.getLocalName();
        String tagName = xmlTag.getName();
        if (context instanceof XmlResourceElement) {
            if ("configure".equals(localName) && "appwidget-provider".equals(tagName)) {
                return ACTIVITY_CONVERTER;
            }
            if ("fragment".equals(localName)) {
                return FRAGMENT_CLASS_CONVERTER;
            }
        } else if ((context instanceof LayoutViewElement || context instanceof MenuItem) && "onClick".equals(localName)) {
            return context instanceof LayoutViewElement ? OnClickConverter.CONVERTER_FOR_LAYOUT : OnClickConverter.CONVERTER_FOR_MENU;
        }
        return null;
    }

    public static ResolvingConverter getConverter(AttributeDefinition attr) {
        Set<AttributeFormat> formats = attr.getFormats();
        CompositeConverter composite = new CompositeConverter();
        String[] values = attr.getValues();
        boolean containsUnsupportedFormats = false;
        for (AttributeFormat format : formats) {
            ResolvingConverter<String> converter = AndroidDomUtil.getStringConverter(format, values);
            if (converter != null) {
                composite.addConverter(converter);
                continue;
            }
            containsUnsupportedFormats = true;
        }
        ResourceReferenceConverter resConverter = AndroidDomUtil.getResourceReferenceConverter(attr);
        if (formats.contains((Object)AttributeFormat.Flag)) {
            if (resConverter != null) {
                composite.addConverter(new LightFlagConverter(values));
            }
            return new FlagConverter(AndroidDomUtil.simplify(composite), values);
        }
        if (resConverter == null && formats.contains((Object)AttributeFormat.Enum)) {
            resConverter = new ResourceReferenceConverter(Arrays.asList(ResourceType.INTEGER.getName()));
            resConverter.setQuiet(true);
        }
        ResolvingConverter<String> stringConverter = AndroidDomUtil.simplify(composite);
        if (resConverter != null) {
            resConverter.setAdditionalConverter(AndroidDomUtil.simplify(composite), containsUnsupportedFormats);
            return resConverter;
        }
        return stringConverter;
    }

    public static String getSpecialResourceType(String attrName) {
        String type = SPECIAL_RESOURCE_TYPES.get(attrName);
        if (type != null) {
            return type;
        }
        if (attrName.endsWith("Animation")) {
            return "anim";
        }
        return null;
    }

    static void addSpecialResourceType(String type, String ... attrs) {
        for (String attr : attrs) {
            SPECIAL_RESOURCE_TYPES.put(attr, type);
        }
    }

    public static boolean containsAction(IntentFilter filter, String name) {
        for (Action action : filter.getActions()) {
            if (!name.equals(action.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(IntentFilter filter, String name) {
        for (Category category : filter.getCategories()) {
            if (!name.equals(category.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    public static Activity getActivityDomElementByClass(List<Activity> activities, PsiClass c) {
        for (Activity activity : activities) {
            PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
            if (!c.getManager().areElementsEquivalent((PsiElement)c, (PsiElement)activityClass)) continue;
            return activity;
        }
        return null;
    }

    public static String[] getStaticallyDefinedSubtags(AndroidDomElement element) {
        if (element instanceof ManifestElement) {
            return AndroidManifestUtils.getStaticallyDefinedSubtags((ManifestElement)element);
        }
        if (element instanceof LayoutViewElement) {
            return new String[]{"include", "requestFocus", "tag"};
        }
        if (element instanceof LayoutElement) {
            return new String[]{"requestFocus"};
        }
        if (element instanceof Group || element instanceof StringArray || element instanceof IntegerArray || element instanceof Style) {
            return new String[]{"item"};
        }
        if (element instanceof MenuItem) {
            return new String[]{"menu"};
        }
        if (element instanceof Menu) {
            return new String[]{"item", "group"};
        }
        if (element instanceof Attr) {
            return new String[]{"enum", "flag"};
        }
        if (element instanceof DeclareStyleable) {
            return new String[]{"attr"};
        }
        if (element instanceof Resources) {
            return new String[]{"string", "drawable", "dimen", "color", "style", "string-array", "integer-array", "array", "plurals", "declare-styleable", "integer", "bool", "attr", "item", "eat-comment"};
        }
        if (element instanceof StyledText) {
            return new String[]{"b", "i", "u"};
        }
        if (element instanceof PreferenceElement) {
            return new String[]{"intent", "extra"};
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public static AttributeDefinition getAttributeDefinition(AndroidFacet facet, XmlAttribute attribute) {
        AttributeDefinitions attrDefs;
        ResourceManager manager;
        String localName = attribute.getLocalName();
        String namespace = attribute.getNamespace();
        boolean isFramework = namespace.equals("http://schemas.android.com/apk/res/android");
        if (!isFramework && "http://schemas.android.com/tools".equals(namespace)) {
            isFramework = true;
            if ("context".equals(localName) || "ignore".equals(localName) || "locale".equals(localName) || "targetApi".equals(localName)) {
                return null;
            }
        }
        if ((manager = facet.getResourceManager(isFramework ? "android" : null)) != null && (attrDefs = manager.getAttributeDefinitions()) != null) {
            return attrDefs.getAttrDefByName(localName);
        }
        return null;
    }

    public static Collection<String> removeUnambiguousNames(Map<String, PsiClass> viewClassMap) {
        HashMap class2Name = new HashMap();
        for (String tagName : viewClassMap.keySet()) {
            String qName;
            String prevTagName;
            PsiClass viewClass = viewClassMap.get(tagName);
            if (AndroidUtils.isAbstract(viewClass) || (prevTagName = (String)class2Name.get(qName = viewClass.getQualifiedName())) != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        return class2Name.values();
    }

    public static AndroidResourceReferenceBase getAndroidResourceReference(GenericAttributeValue<ResourceValue> attribute, boolean localOnly) {
        if (attribute == null) {
            return null;
        }
        ResourceValue resValue = (ResourceValue)attribute.getValue();
        if (resValue == null || localOnly && resValue.getPackage() != null) {
            return null;
        }
        XmlAttributeValue value = attribute.getXmlAttributeValue();
        if (value == null) {
            return null;
        }
        for (PsiReference reference : value.getReferences()) {
            if (!(reference instanceof AndroidResourceReferenceBase)) continue;
            return (AndroidResourceReferenceBase)reference;
        }
        return null;
    }

    public static AndroidAttributeValue<PsiClass> findComponentDeclarationInManifest(PsiClass aClass) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)aClass);
        if (facet == null) {
            return null;
        }
        boolean isActivity = AndroidDomUtil.isInheritor(aClass, "android.app.Activity");
        boolean isService = AndroidDomUtil.isInheritor(aClass, "android.app.Service");
        boolean isReceiver = AndroidDomUtil.isInheritor(aClass, "android.content.BroadcastReceiver");
        boolean isProvider = AndroidDomUtil.isInheritor(aClass, "android.content.ContentProvider");
        if (!(isActivity || isService || isReceiver || isProvider)) {
            return null;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (isActivity) {
            for (Activity activity : application.getActivities()) {
                AndroidAttributeValue<PsiClass> activityClass = activity.getActivityClass();
                if (activityClass.getValue() != aClass) continue;
                return activityClass;
            }
        } else if (isService) {
            for (Service service : application.getServices()) {
                AndroidAttributeValue<PsiClass> serviceClass = service.getServiceClass();
                if (serviceClass.getValue() != aClass) continue;
                return serviceClass;
            }
        } else if (isReceiver) {
            for (Receiver receiver : application.getReceivers()) {
                AndroidAttributeValue<PsiClass> receiverClass = receiver.getReceiverClass();
                if (receiverClass.getValue() != aClass) continue;
                return receiverClass;
            }
        } else {
            for (Provider provider : application.getProviders()) {
                AndroidAttributeValue<PsiClass> providerClass = provider.getProviderClass();
                if (providerClass.getValue() != aClass) continue;
                return providerClass;
            }
        }
        return null;
    }

    public static boolean isInheritor(PsiClass aClass, String baseClassQName) {
        Project project = aClass.getProject();
        PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(baseClassQName, aClass.getResolveScope());
        return baseClass != null && aClass.isInheritor(baseClass, true);
    }

    static {
        AndroidDomUtil.addSpecialResourceType(ResourceType.STRING.getName(), "label", "description", "title");
        AndroidDomUtil.addSpecialResourceType(ResourceType.DRAWABLE.getName(), "icon");
        AndroidDomUtil.addSpecialResourceType(ResourceType.STYLE.getName(), "theme");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ANIM.getName(), "animation");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ID.getName(), "id", "layout_toRightOf", "layout_toLeftOf", "layout_above", "layout_below", "layout_alignBaseline", "layout_alignLeft", "layout_alignTop", "layout_alignRight", "layout_alignBottom", "layout_alignStart", "layout_alignEnd", "layout_toStartOf", "layout_toEndOf");
    }
}

