/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.ide.common.res2.ResourceItem;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.DynamicResourceValueItem;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;

public class AndroidResourceReferenceBase
extends PsiReferenceBase.Poly<XmlElement> {
    protected final AndroidFacet myFacet;
    protected final ResourceValue myResourceValue;

    public AndroidResourceReferenceBase(GenericDomValue value, TextRange range, ResourceValue resourceValue, AndroidFacet facet) {
        super((PsiElement)DomUtil.getValueElement((GenericDomValue)value), range, true);
        this.myResourceValue = resourceValue;
        this.myFacet = facet;
    }

    public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public ResourceValue getResourceValue() {
        return this.myResourceValue;
    }

    public PsiElement[] computeTargetElements() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        ArrayList<PsiElement> results = new ArrayList<PsiElement>();
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof LazyValueResourceElementWrapper) {
                element = ((LazyValueResourceElementWrapper)element).computeElement();
            }
            if (element instanceof ResourceElementWrapper) {
                element = ((ResourceElementWrapper)element).getWrappee();
            }
            if (element == null) continue;
            results.add(element);
        }
        return results.toArray(new PsiElement[results.size()]);
    }

    public ResolveResult[] multiResolve(boolean incompleteCode) {
        return ResolveCache.getInstance((Project)((XmlElement)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<AndroidResourceReferenceBase>(){

            public ResolveResult[] resolve(AndroidResourceReferenceBase reference, boolean incompleteCode) {
                return AndroidResourceReferenceBase.this.resolveInner();
            }
        }, false, incompleteCode);
    }

    private ResolveResult[] resolveInner() {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        boolean attrReference = this.myResourceValue.getPrefix() == '?';
        this.collectTargets(this.myFacet, this.myResourceValue, elements, attrReference);
        ArrayList<Object> result = new ArrayList<Object>();
        if (elements.isEmpty() && this.myResourceValue.getResourceName() != null && !"android".equals(this.myResourceValue.getPackage())) {
            AppResourceRepository resources = AppResourceRepository.getAppResources(this.myFacet.getModule(), true);
            ResourceType resourceType = this.myResourceValue.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                assert (resources != null);
                List items = resources.getResourceItem(resourceType, this.myResourceValue.getResourceName());
                if (items != null && FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                    for (ResourceItem item : items) {
                        XmlTag tag = LocalResourceRepository.getItemTag(this.myFacet.getModule().getProject(), item);
                        if (tag != null) {
                            elements.add((PsiElement)tag);
                            continue;
                        }
                        if (!(item instanceof DynamicResourceValueItem)) continue;
                        result.add(((DynamicResourceValueItem)item).createResolveResult());
                    }
                }
            }
        }
        if (elements.size() > 1) {
            Collections.sort(elements, AndroidResourceUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result.add(new PsiElementResolveResult(target));
        }
        return result.toArray(new ResolveResult[result.size()]);
    }

    private void collectTargets(AndroidFacet facet, ResourceValue resValue, List<PsiElement> elements, boolean attrReference) {
        String resName;
        ResourceType resType = resValue.getType();
        if (resType == null) {
            return;
        }
        ResourceManager manager = facet.getResourceManager(resValue.getPackage(), this.myElement);
        if (manager != null && (resName = resValue.getResourceName()) != null) {
            manager.collectLazyResourceElements(resType.getName(), resName, attrReference, this.myElement, elements);
        }
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper && (element = ((LazyValueResourceElementWrapper)element).computeElement()) == null) {
            return false;
        }
        ResolveResult[] results = this.multiResolve(false);
        PsiFile psiFile = element.getContainingFile();
        VirtualFile vFile = psiFile != null ? psiFile.getVirtualFile() : null;
        for (ResolveResult result : results) {
            ValueResourceInfo info;
            PsiElement target = result.getElement();
            if (element.getManager().areElementsEquivalent(target, element)) {
                return true;
            }
            if (!(target instanceof LazyValueResourceElementWrapper) || vFile == null || !(info = ((LazyValueResourceElementWrapper)target).getResourceInfo()).getContainingFile().equals(vFile)) continue;
            XmlAttributeValue realTarget = info.computeXmlElement();
            if (!element.getManager().areElementsEquivalent((PsiElement)realTarget, element)) continue;
            return true;
        }
        return false;
    }

    public Object[] getVariants() {
        return EMPTY_ARRAY;
    }
}

