/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.IAndroidTarget;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.LookupClass;
import org.jetbrains.android.dom.LookupPrefix;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NonNls;

public class ConstantFieldConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(String value, ConvertContext context) {
        return value;
    }

    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        ArrayList<MyReference> result = new ArrayList<MyReference>();
        DomElement domElement = context.getInvocationElement();
        LookupClass lookupClass = (LookupClass)domElement.getAnnotation(LookupClass.class);
        LookupPrefix lookupPrefix = (LookupPrefix)domElement.getAnnotation(LookupPrefix.class);
        if (lookupClass != null && lookupPrefix != null) {
            Module module = context.getModule();
            GlobalSearchScope scope = module != null ? GlobalSearchScope.allScope((Project)module.getProject()) : domElement.getResolveScope();
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject()).findClass(lookupClass.value(), scope);
            if (psiClass != null) {
                Set<String> filteringSet = ConstantFieldConverter.getFilteringSet(context);
                result.add(new MyReference(element, psiClass, lookupPrefix.value(), filteringSet));
            }
        }
        return result.toArray(new PsiReference[result.size()]);
    }

    private static Set<String> getFilteringSet(ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return null;
        }
        IAndroidTarget target = platform.getTarget();
        AndroidTargetData targetData = platform.getSdkData().getTargetData(target);
        DomElement element = context.getInvocationElement().getParent();
        if (element instanceof Category) {
            return targetData.getStaticConstantsData().getCategories();
        }
        if (element instanceof Action && (element = element.getParent()) instanceof IntentFilter) {
            if ((element = element.getParent()) instanceof Activity) {
                return targetData.getStaticConstantsData().getActivityActions();
            }
            if (element instanceof Service) {
                return targetData.getStaticConstantsData().getServiceActions();
            }
            if (element instanceof Receiver) {
                return targetData.getStaticConstantsData().getReceiverActions();
            }
        }
        return null;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myClass;
        private final String myLookupPrefix;
        private final Set<String> myFilteringSet;

        public MyReference(PsiElement element, PsiClass aClass, String lookupPrefix, Set<String> filteringSet) {
            super(element, true);
            this.myClass = aClass;
            this.myLookupPrefix = lookupPrefix;
            this.myFilteringSet = filteringSet;
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(PsiReference reference, boolean incompleteCode) {
                    return MyReference.this.resolveInner();
                }
            }, false, false);
        }

        private PsiElement resolveInner() {
            final String value = this.getValue();
            if (value.isEmpty()) {
                return null;
            }
            final Ref ref = Ref.create();
            this.processFields(new Processor<Pair<PsiField, String>>(){

                public boolean process(Pair<PsiField, String> pair) {
                    if (value.equals(pair.getSecond())) {
                        ref.set(pair.getFirst());
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)ref.get();
        }

        public Object[] getVariants() {
            ArrayList result = new ArrayList();
            HashSet added = new HashSet();
            this.processFields(new Processor<Pair<PsiField, String>>((Set)added, result){
                final /* synthetic */ Set val$added;
                final /* synthetic */ List val$result;
                {
                    this.val$added = set;
                    this.val$result = list;
                }

                public boolean process(Pair<PsiField, String> pair) {
                    String s = (String)pair.getSecond();
                    if (MyReference.this.myFilteringSet != null && !MyReference.this.myFilteringSet.contains(s)) {
                        return true;
                    }
                    if (this.val$added.add(s)) {
                        int lastDot;
                        boolean isManifestPermission = "android.Manifest.permission".equals(MyReference.this.myClass.getQualifiedName());
                        LookupElementBuilder builder = LookupElementBuilder.create((Object)pair.getFirst(), (String)s).withCaseSensitivity(isManifestPermission);
                        if (isManifestPermission && (lastDot = s.lastIndexOf(46)) != -1 && lastDot + 1 < s.length()) {
                            String suffix = s.substring(lastDot + 1);
                            builder = builder.withLookupString(suffix);
                        }
                        this.val$result.add(builder);
                    }
                    return true;
                }
            });
            return ArrayUtil.toObjectArray(result);
        }

        private void processFields(Processor<Pair<PsiField, String>> processor) {
            PsiField[] psiFields;
            for (PsiField field : psiFields = this.myClass.getFields()) {
                PsiLiteralExpression literalExpression;
                Object o;
                PsiExpression initializer;
                if (!field.hasModifierProperty("static") || !field.hasModifierProperty("public") || !((initializer = field.getInitializer()) instanceof PsiLiteralExpression) || !((o = (literalExpression = (PsiLiteralExpression)initializer).getValue()) instanceof String) || !o.toString().startsWith(this.myLookupPrefix) || processor.process((Object)Pair.create((Object)field, (Object)o.toString()))) continue;
                return;
            }
        }
    }
}

