/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;

public class IntegerConverter
extends ResolvingConverter<String> {
    public static final IntegerConverter INSTANCE = new IntegerConverter();

    public Collection<? extends String> getVariants(ConvertContext context) {
        return Collections.emptyList();
    }

    public String fromString(@NonNls String s, ConvertContext context) {
        if (s == null || AndroidResourceUtil.isIdDeclaration(s) || AndroidResourceUtil.isIdReference(s)) {
            return s;
        }
        try {
            Long l = Long.decode(s);
            if (l >= 0x100000000L || l <= -4294967295L) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return s;
    }

    public String toString(String s, ConvertContext context) {
        return s;
    }
}

