/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.annotations.NonNls;

public class MetadataValueConverter
extends ResolvingConverter<Object>
implements CustomReferenceConverter<Object> {
    private ResourceReferenceConverter myResourceReferenceConverter = new ResourceReferenceConverter();
    private PackageClassConverter myPsiClassConverter = new PackageClassConverter();

    private static boolean isClassContext(ConvertContext context) {
        XmlTag xmlTag = context.getTag();
        return xmlTag != null && "android.support.PARENT_ACTIVITY".equals(xmlTag.getAttributeValue("android:name"));
    }

    public String toString(Object object, ConvertContext context) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Collection<Object> getVariants(ConvertContext context) {
        if (MetadataValueConverter.isClassContext(context)) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        results.addAll(this.myResourceReferenceConverter.getVariants(context));
        return results;
    }

    public Object fromString(@NonNls String s, ConvertContext context) {
        if (MetadataValueConverter.isClassContext(context)) {
            return this.myPsiClassConverter.fromString(s, context);
        }
        return this.myResourceReferenceConverter.fromString(s, context);
    }

    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        if (MetadataValueConverter.isClassContext(context)) {
            return this.myPsiClassConverter.createReferences((GenericDomValue<PsiClass>)value, element, context);
        }
        return this.myResourceReferenceConverter.createReferences((GenericDomValue<ResourceValue>)value, element, context);
    }
}

