/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.dom.converters.CompleteNonModuleClass;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;

public class PackageClassConverter
extends ResolvingConverter<PsiClass>
implements CustomReferenceConverter<PsiClass> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.converters.PackageClassConverter");
    private final String[] myExtendClassesNames;

    public PackageClassConverter(String ... extendClassesNames) {
        this.myExtendClassesNames = extendClassesNames;
    }

    public PackageClassConverter() {
        this.myExtendClassesNames = ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        return Collections.emptyList();
    }

    public PsiClass fromString(@NonNls String s, ConvertContext context) {
        PsiClass psiClass;
        if (s == null) {
            return null;
        }
        DomElement domElement = context.getInvocationElement();
        Manifest manifest = (Manifest)domElement.getParentOfType(Manifest.class, true);
        s = s.replace('$', '.');
        String packageName = manifest != null ? (String)manifest.getPackage().getValue() : null;
        String className = null;
        if (packageName != null) {
            className = s.startsWith(".") ? packageName + s : packageName + "." + s;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject());
        Module module = context.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : context.getInvocationElement().getResolveScope();
        PsiClass psiClass2 = psiClass = className != null ? facade.findClass(className, scope) : null;
        if (psiClass == null) {
            psiClass = facade.findClass(s, scope);
        }
        return psiClass;
    }

    public PsiReference[] createReferences(GenericDomValue<PsiClass> value, PsiElement element, ConvertContext context) {
        String[] classNameParts;
        String[] stringArray;
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        String strValue = attrValue.getValue();
        boolean startsWithPoint = strValue.startsWith(".");
        int start = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        DomElement domElement = context.getInvocationElement();
        Manifest manifest = (Manifest)domElement.getParentOfType(Manifest.class, true);
        String basePackage = manifest == null ? null : (String)manifest.getPackage().getValue();
        ExtendClass extendClassAnnotation = (ExtendClass)domElement.getAnnotation(ExtendClass.class);
        if (extendClassAnnotation != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = extendClassAnnotation.value();
        } else {
            stringArray = this.myExtendClassesNames;
        }
        String[] extendClassesNames = stringArray;
        boolean inModuleOnly = domElement.getAnnotation(CompleteNonModuleClass.class) == null;
        ArrayList<MyReference> result = new ArrayList<MyReference>();
        String[] nameParts = strValue.split("\\.");
        if (nameParts.length == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        int offset = start;
        int n = nameParts.length;
        for (int i = 0; i < n - 1; ++i) {
            String packageName = nameParts[i];
            if (packageName.length() > 0) {
                TextRange range = new TextRange((offset += packageName.length()) - packageName.length(), offset);
                result.add(new MyReference(element, range, basePackage, startsWithPoint, start, true, module, extendClassesNames, inModuleOnly));
            }
            ++offset;
        }
        String className = nameParts[nameParts.length - 1];
        for (String s : classNameParts = className.split("\\$")) {
            if (s.length() > 0) {
                TextRange range = new TextRange((offset += s.length()) - s.length(), offset);
                result.add(new MyReference(element, range, basePackage, startsWithPoint, start, false, module, extendClassesNames, inModuleOnly));
            }
            ++offset;
        }
        return result.toArray(new PsiReference[result.size()]);
    }

    public static String getQualifiedName(PsiClass aClass) {
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiClass) {
            String parentQName = PackageClassConverter.getQualifiedName((PsiClass)parent);
            if (parentQName == null) {
                return null;
            }
            return parentQName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    private static String getName(PsiClass aClass) {
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiClass) {
            String parentName = PackageClassConverter.getName((PsiClass)parent);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getName();
    }

    public String toString(PsiClass psiClass, ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        Manifest manifest = (Manifest)domElement.getParentOfType(Manifest.class, true);
        String packageName = manifest == null ? null : (String)manifest.getPackage().getValue();
        return PackageClassConverter.classToString(psiClass, packageName, "");
    }

    public static String getPackageName(PsiClass psiClass) {
        PsiFile file = psiClass.getContainingFile();
        return file instanceof PsiClassOwner ? ((PsiClassOwner)file).getPackageName() : null;
    }

    private static String classToString(PsiClass psiClass, String basePackageName, String prefix) {
        if (psiClass == null) {
            return null;
        }
        String qName = PackageClassConverter.getQualifiedName(psiClass);
        if (qName == null) {
            return null;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof PsiClassOwner) {
            String name;
            PsiClassOwner psiFile = (PsiClassOwner)file;
            if (Comparing.equal((String)psiFile.getPackageName(), (String)basePackageName)) {
                String name2 = PackageClassConverter.getName(psiClass);
                if (name2 != null) {
                    String dottedName = '.' + name2;
                    if (dottedName.startsWith(prefix)) {
                        return dottedName;
                    }
                    if (name2.startsWith(prefix)) {
                        return name2;
                    }
                }
            } else if (basePackageName != null && qName.startsWith(basePackageName + ".") && (name = qName.substring(basePackageName.length())).startsWith(prefix)) {
                return name;
            }
        }
        return qName;
    }

    public static Collection<PsiClass> findInheritors(Project project, Module module, String className, boolean inModuleOnly) {
        PsiClass base = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (base != null) {
            GlobalSearchScope scope = inModuleOnly && module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
            Query query = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true);
            return query.findAll();
        }
        return new ArrayList<PsiClass>();
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final int myStart;
        private final String myBasePackage;
        private final boolean myStartsWithPoint;
        private final boolean myIsPackage;
        private final Module myModule;
        private final String[] myExtendsClasses;
        private final boolean myCompleteOnlyModuleClasses;

        public MyReference(PsiElement element, TextRange range, String basePackage, boolean startsWithPoint, int start, boolean isPackage, Module module, String[] extendsClasses, boolean completeOnlyModuleClasses) {
            super(element, range, true);
            this.myBasePackage = basePackage;
            this.myStartsWithPoint = startsWithPoint;
            this.myStart = start;
            this.myIsPackage = isPackage;
            this.myModule = module;
            this.myExtendsClasses = extendsClasses;
            this.myCompleteOnlyModuleClasses = completeOnlyModuleClasses;
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(PsiReference reference, boolean incompleteCode) {
                    return MyReference.this.resolveInner();
                }
            }, false, false);
        }

        private PsiElement resolveInner() {
            String absName;
            String value = this.getCurrentValue();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            if (!this.myStartsWithPoint) {
                PsiPackage element;
                PsiPackage psiPackage = this.myIsPackage ? facade.findPackage(value) : (element = facade.findClass(value, this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(false) : this.myElement.getResolveScope()));
                if (element != null) {
                    return element;
                }
            }
            if ((absName = this.getAbsoluteName(value)) != null) {
                return this.myIsPackage ? facade.findPackage(absName) : facade.findClass(absName, this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(false) : this.myElement.getResolveScope());
            }
            return null;
        }

        private String getCurrentValue() {
            int end = this.getRangeInElement().getEndOffset();
            return this.myElement.getText().substring(this.myStart, end).replace('$', '.');
        }

        private String getAbsoluteName(String value) {
            if (this.myBasePackage == null) {
                return null;
            }
            return this.myBasePackage + (this.myStartsWithPoint ? "" : ".") + value;
        }

        public Object[] getVariants() {
            if (this.myExtendsClasses != null) {
                ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
                for (String extendsClass : this.myExtendsClasses) {
                    classes.addAll(PackageClassConverter.findInheritors(this.myElement.getProject(), this.myModule, extendsClass, this.myCompleteOnlyModuleClasses));
                }
                ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>(classes.size());
                int n = classes.size();
                for (int i = 0; i < n; ++i) {
                    String prefix;
                    PsiClass psiClass = (PsiClass)classes.get(i);
                    String name = PackageClassConverter.classToString(psiClass, this.myBasePackage, prefix = this.myElement.getText().substring(this.myStart, this.getRangeInElement().getStartOffset()));
                    if (name == null || !name.startsWith(prefix)) continue;
                    name = name.substring(prefix.length());
                    result.add(JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)name, (boolean)true));
                }
                return ArrayUtil.toObjectArray(result);
            }
            return EMPTY_ARRAY;
        }

        public PsiElement bindToElement(PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiClass || element instanceof PsiPackage) {
                String newName;
                if (this.myIsPackage && this.myBasePackage != null && AndroidUtils.isPackagePrefix(this.getCurrentValue(), this.myBasePackage)) {
                    return super.bindToElement(element);
                }
                String string = newName = element instanceof PsiClass ? PackageClassConverter.classToString((PsiClass)element, this.myBasePackage, "") : MyReference.packageToString((PsiPackage)element, this.myBasePackage);
                assert (newName != null);
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
                TextRange range = new TextRange(this.myStart, this.getRangeInElement().getEndOffset());
                if (manipulator != null) {
                    PsiElement newElement = manipulator.handleContentChange(this.myElement, range, newName);
                    if (newElement instanceof XmlAttributeValue) {
                        XmlAttributeValue attrValue = (XmlAttributeValue)newElement;
                        String newRef = attrValue.getValue();
                        if (this.myBasePackage != null && this.myBasePackage.length() > 0 && newRef.startsWith(this.myBasePackage + ".")) {
                            return manipulator.handleContentChange(this.myElement, newRef.substring(this.myBasePackage.length()));
                        }
                    }
                    return newElement;
                }
                return element;
            }
            LOG.error("PackageClassConverter resolved to " + element.getClass());
            return super.bindToElement(element);
        }

        private static String packageToString(PsiPackage psiPackage, String basePackageName) {
            String qName = psiPackage.getQualifiedName();
            return basePackageName != null && AndroidUtils.isPackagePrefix(basePackageName, qName) ? qName.substring(basePackageName.length()) : qName;
        }
    }
}

