/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.ResourceNameConverter;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;

public class ParentStyleConverter
extends ResourceReferenceConverter {
    public ParentStyleConverter() {
        super(ResourceType.STYLE.getName(), false, false);
        this.setAllowAttributeReferences(false);
    }

    @Override
    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value, PsiElement element, ConvertContext context) {
        Object[] refs;
        XmlAttributeValue attributeValue;
        if (element instanceof XmlAttributeValue && (attributeValue = (XmlAttributeValue)element).isValid() && attributeValue.getValue().isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] refsFromSuper = super.createReferences(value, element, context);
        ResourceValue resValue = (ResourceValue)value.getValue();
        if (resValue == null || resValue.getPackage() != null) {
            return refsFromSuper;
        }
        AndroidFacet facet = AndroidFacet.getInstance(context);
        if (facet != null && (refs = ParentStyleConverter.getReferencesInStyleName(value, facet)).length > 0) {
            return (PsiReference[])ArrayUtil.mergeArrays((Object[])refsFromSuper, (Object[])refs);
        }
        return refsFromSuper;
    }

    private static PsiReference[] getReferencesInStyleName(GenericDomValue<?> value, AndroidFacet facet) {
        String[] ids;
        String s = value.getStringValue();
        if (s == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        int start = 0;
        int idx = s.indexOf(47);
        if (idx >= 0) {
            start = idx + 1;
            s = s.substring(start);
        }
        if ((ids = s.split("\\.")).length < 2) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<ResourceNameConverter.MyParentStyleReference> result = new ArrayList<ResourceNameConverter.MyParentStyleReference>(ids.length - 1);
        int offset = s.length();
        for (int i = ids.length - 1; i >= 0; --i) {
            String styleName = s.substring(0, offset);
            if (i < ids.length - 1) {
                ResourceValue val = ResourceValue.referenceTo('\u0000', null, ResourceType.STYLE.getName(), styleName);
                result.add(new ResourceNameConverter.MyParentStyleReference(value, new TextRange(1 + start, 1 + start + offset), val, facet));
            }
            if (ResourceNameConverter.hasExplicitParent(facet, styleName)) break;
            offset = offset - ids[i].length() - 1;
        }
        return result.toArray(new PsiReference[result.size()]);
    }

    @Override
    public String toString(ResourceValue element, ConvertContext context) {
        if (element != null && element.getPrefix() == '@') {
            return element.toString();
        }
        return super.toString(element, context);
    }
}

