/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.resources.ResourceType;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.AdditionalConverter;
import org.jetbrains.android.dom.AndroidResourceType;
import org.jetbrains.android.dom.converters.AndroidResourceReference;
import org.jetbrains.android.dom.converters.AttributeValueDocumentationProvider;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.CreateFileResourceQuickFix;
import org.jetbrains.android.inspections.CreateValueResourceQuickFix;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NonNls;

public class ResourceReferenceConverter
extends ResolvingConverter<ResourceValue>
implements CustomReferenceConverter<ResourceValue>,
AttributeValueDocumentationProvider {
    private final List<String> myResourceTypes;
    private ResolvingConverter<String> myAdditionalConverter;
    private boolean myAdditionalConverterSoft = false;
    private boolean myWithPrefix = true;
    private boolean myWithExplicitResourceType = true;
    private boolean myQuiet = false;
    private boolean myAllowAttributeReferences = true;
    private boolean myAllowLiterals = true;

    public ResourceReferenceConverter() {
        this(new ArrayList<String>());
    }

    public ResourceReferenceConverter(Collection<String> resourceTypes) {
        this.myResourceTypes = new ArrayList<String>(resourceTypes);
    }

    public void setAllowLiterals(boolean allowLiterals) {
        this.myAllowLiterals = allowLiterals;
    }

    public ResourceReferenceConverter(String resourceType, boolean withPrefix, boolean withExplicitResourceType) {
        this.myResourceTypes = Arrays.asList(resourceType);
        this.myWithPrefix = withPrefix;
        this.myWithExplicitResourceType = withExplicitResourceType;
    }

    public void setAdditionalConverter(ResolvingConverter<String> additionalConverter, boolean soft) {
        this.myAdditionalConverter = additionalConverter;
        this.myAdditionalConverterSoft = soft;
    }

    public void setQuiet(boolean quiet) {
        this.myQuiet = quiet;
    }

    public void setAllowAttributeReferences(boolean allowAttributeReferences) {
        this.myAllowAttributeReferences = allowAttributeReferences;
    }

    private String getPackagePrefix(String resourcePackage) {
        String prefix;
        String string = prefix = this.myWithPrefix ? "@" : "";
        if (resourcePackage == null) {
            return prefix;
        }
        return prefix + resourcePackage + ':';
    }

    static String getValue(XmlElement element) {
        if (element instanceof XmlAttribute) {
            return ((XmlAttribute)element).getValue();
        }
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getValue().getText();
        }
        return null;
    }

    public Collection<? extends ResourceValue> getVariants(ConvertContext context) {
        ResolvingConverter<String> additionalConverter;
        XmlElement element;
        HashSet<ResourceValue> result = new HashSet<ResourceValue>();
        Module module = context.getModule();
        if (module == null) {
            return result;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return result;
        }
        Set<String> recommendedTypes = this.getResourceTypes(context);
        if (recommendedTypes.contains(ResourceType.ID.getName()) && recommendedTypes.size() == 1) {
            result.add(ResourceValue.reference("@+id/"));
        }
        if ((element = context.getXmlElement()) == null) {
            return result;
        }
        String value = ResourceReferenceConverter.getValue(element);
        assert (value != null);
        if (!this.myQuiet || StringUtil.startsWithChar((CharSequence)value, (char)'@')) {
            char prefix;
            String resourcePackage = null;
            String systemPrefix = this.getPackagePrefix("android");
            if (value.startsWith(systemPrefix)) {
                resourcePackage = "android";
            } else {
                result.add(ResourceValue.literal(systemPrefix));
            }
            char c = prefix = this.myWithPrefix ? (char)'@' : '\u0000';
            if (value.startsWith("@+id/")) {
                this.addVariantsForIdDeclaration(result, facet, prefix, value);
            }
            if (recommendedTypes.size() == 1) {
                String type = recommendedTypes.iterator().next();
                boolean explicitResourceType = value.startsWith(this.getTypePrefix(resourcePackage, type)) || this.myWithExplicitResourceType;
                ResourceReferenceConverter.addResourceReferenceValues(facet, prefix, type, resourcePackage, result, explicitResourceType);
            } else {
                Set<String> filteringSet = "android".equals(resourcePackage) ? null : ResourceReferenceConverter.getResourceTypesInCurrentModule(facet);
                for (ResourceType resourceType : ResourceType.values()) {
                    String type = resourceType.getName();
                    String typePrefix = this.getTypePrefix(resourcePackage, type);
                    if (value.startsWith(typePrefix)) {
                        ResourceReferenceConverter.addResourceReferenceValues(facet, prefix, type, resourcePackage, result, true);
                        continue;
                    }
                    if (!recommendedTypes.contains(type) || filteringSet != null && !filteringSet.contains(type)) continue;
                    result.add(ResourceValue.literal(typePrefix));
                }
            }
        }
        if (this.myAllowAttributeReferences) {
            ResourceReferenceConverter.completeAttributeReferences(value, facet, result);
        }
        if ((additionalConverter = this.getAdditionalConverter(context)) != null) {
            for (String variant : additionalConverter.getVariants(context)) {
                result.add(ResourceValue.literal(variant));
            }
        }
        return result;
    }

    private void addVariantsForIdDeclaration(Set<ResourceValue> result, AndroidFacet facet, char prefix, String value) {
        for (String name : facet.getLocalResourceManager().getIds(false)) {
            ResourceValue ref = ResourceReferenceConverter.referenceTo(prefix, "+id", null, name, true);
            if (value.startsWith(this.doToString(ref))) continue;
            result.add(ref);
        }
    }

    private static void completeAttributeReferences(String value, AndroidFacet facet, Set<ResourceValue> result) {
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"?attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR.getName(), null, result, true);
        } else if (StringUtil.startsWith((CharSequence)value, (CharSequence)"?android:attr/")) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR.getName(), "android", result, true);
        } else if (StringUtil.startsWithChar((CharSequence)value, (char)'?')) {
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR.getName(), null, result, false);
            ResourceReferenceConverter.addResourceReferenceValues(facet, '?', ResourceType.ATTR.getName(), "android", result, false);
            result.add(ResourceValue.literal("?attr/"));
            result.add(ResourceValue.literal("?android:attr/"));
        }
    }

    public static Set<String> getResourceTypesInCurrentModule(AndroidFacet facet) {
        final HashSet<String> result = new HashSet<String>();
        LocalResourceManager manager = facet.getLocalResourceManager();
        manager.processFileResources(null, new FileResourceProcessor(){

            @Override
            public boolean process(VirtualFile resFile, String resName, String resFolderType) {
                if (ResourceType.getEnum((String)resFolderType) != null) {
                    result.add(resFolderType);
                }
                return true;
            }
        });
        result.addAll(manager.getValueResourceTypes());
        if (manager.getIds(true).size() > 0) {
            result.add(ResourceType.ID.getName());
        }
        return result;
    }

    private String getTypePrefix(String resourcePackage, String type) {
        String typePart = type + '/';
        return this.getPackagePrefix(resourcePackage) + typePart;
    }

    private Set<String> getResourceTypes(ConvertContext context) {
        return this.getResourceTypes(context.getInvocationElement());
    }

    public Set<String> getResourceTypes(DomElement element) {
        String s;
        AndroidResourceType resourceType = (AndroidResourceType)element.getAnnotation(AndroidResourceType.class);
        HashSet<String> types = new HashSet<String>(this.myResourceTypes);
        if (resourceType != null && (s = resourceType.value()) != null) {
            types.add(s);
        }
        if (types.size() == 0) {
            types.addAll(AndroidResourceUtil.getNames(AndroidResourceUtil.VALUE_RESOURCE_TYPES));
        } else if (types.contains(ResourceType.DRAWABLE.getName())) {
            types.add(ResourceType.COLOR.getName());
        }
        return types;
    }

    private static void addResourceReferenceValues(AndroidFacet facet, char prefix, String type, String resPackage, Collection<ResourceValue> result, boolean explicitResourceType) {
        ResourceManager manager = facet.getResourceManager(resPackage);
        if (manager != null) {
            for (String name : manager.getResourceNames(type)) {
                result.add(ResourceReferenceConverter.referenceTo(prefix, type, resPackage, name, explicitResourceType));
            }
        }
    }

    private static ResourceValue referenceTo(char prefix, String type, String resPackage, String name, boolean explicitResourceType) {
        return ResourceValue.referenceTo(prefix, resPackage, explicitResourceType ? type : null, name);
    }

    public String getErrorMessage(String s, ConvertContext context) {
        if (s == null || s.isEmpty()) {
            return "Missing value";
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, false);
        if (parsed == null || !parsed.isReference()) {
            ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
            if (additionalConverter != null) {
                return additionalConverter.getErrorMessage(s, context);
            }
        } else {
            String errorMessage = parsed.getErrorMessage();
            if (errorMessage != null) {
                return errorMessage;
            }
        }
        return super.getErrorMessage(s, context);
    }

    public ResourceValue fromString(@NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        ResourceValue parsed = ResourceValue.parse(s, true, this.myWithPrefix, true);
        ResolvingConverter<String> additionalConverter = this.getAdditionalConverter(context);
        if (parsed == null || !parsed.isReference()) {
            if (additionalConverter != null) {
                String value = (String)additionalConverter.fromString(s, context);
                if (value != null) {
                    return ResourceValue.literal(value);
                }
                if (!this.myAdditionalConverterSoft) {
                    return null;
                }
            } else if (!this.myAllowLiterals) {
                return null;
            }
        }
        if (parsed != null) {
            String resType = parsed.getResourceType();
            if (parsed.getPrefix() == '?') {
                if (!this.myAllowAttributeReferences) {
                    return null;
                }
                if (resType == null) {
                    parsed.setResourceType(ResourceType.ATTR.getName());
                } else if (!ResourceType.ATTR.getName().equals(resType)) {
                    return null;
                }
            } else if (resType == null && parsed.isReference()) {
                if (this.myWithExplicitResourceType && !"@null".equals(s)) {
                    return null;
                }
                if (this.myResourceTypes.size() == 1) {
                    parsed.setResourceType(this.myResourceTypes.get(0));
                }
            }
        }
        return parsed;
    }

    private ResolvingConverter<String> getAdditionalConverter(ConvertContext context) {
        Class<? extends ResolvingConverter> converterClass;
        if (this.myAdditionalConverter != null) {
            return this.myAdditionalConverter;
        }
        AdditionalConverter additionalConverterAnnotation = (AdditionalConverter)context.getInvocationElement().getAnnotation(AdditionalConverter.class);
        if (additionalConverterAnnotation != null && (converterClass = additionalConverterAnnotation.value()) != null) {
            ConverterManager converterManager = (ConverterManager)ServiceManager.getService(ConverterManager.class);
            return (ResolvingConverter)converterManager.getConverterInstance(converterClass);
        }
        return null;
    }

    public String toString(ResourceValue element, ConvertContext context) {
        return this.doToString(element);
    }

    private String doToString(ResourceValue element) {
        if (element == null) {
            return null;
        }
        if (this.myWithExplicitResourceType || !element.isReference()) {
            return element.toString();
        }
        return ResourceValue.referenceTo(element.getPrefix(), element.getPackage(), null, element.getResourceName()).toString();
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        ResourceValue resourceValue;
        String value;
        DomElement domElement;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        if (facet != null && (domElement = context.getInvocationElement()) instanceof GenericDomValue && (value = ((GenericDomValue)domElement).getStringValue()) != null && (resourceValue = ResourceValue.parse(value, false, this.myWithPrefix, true)) != null) {
            String aPackage = resourceValue.getPackage();
            ResourceType resType = resourceValue.getType();
            if (resType == null && this.myResourceTypes.size() == 1) {
                resType = ResourceType.getEnum((String)this.myResourceTypes.get(0));
            }
            String resourceName = resourceValue.getResourceName();
            if (aPackage == null && resType != null && resourceName != null && AndroidResourceUtil.isCorrectAndroidResourceName(resourceName)) {
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.contains(resType)) {
                    fixes.add(new CreateFileResourceQuickFix(facet, resType, resourceName, (PsiFile)context.getFile(), false));
                }
                if (AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resType) && resType != ResourceType.LAYOUT) {
                    fixes.add(new CreateValueResourceQuickFix(facet, resType, resourceName, (PsiFile)context.getFile(), false));
                }
                return fixes.toArray(new LocalQuickFix[fixes.size()]);
            }
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    public PsiReference[] createReferences(GenericDomValue<ResourceValue> value, PsiElement element, ConvertContext context) {
        ResourceValue resValue;
        AndroidFacet facet;
        if ("@null".equals(value.getStringValue())) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (resValue = (ResourceValue)value.getValue()) != null && resValue.isReference()) {
            XmlAttribute attribute;
            String resType = resValue.getResourceType();
            if (resType == null) {
                return PsiReference.EMPTY_ARRAY;
            }
            if (resValue.getPackage() == null && "+id".equals(resType) && element != null && element.getParent() instanceof XmlAttribute && "id".equals((attribute = (XmlAttribute)element.getParent()).getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespace())) {
                return PsiReference.EMPTY_ARRAY;
            }
            return new PsiReference[]{new AndroidResourceReference(value, facet, resValue, null)};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public String getDocumentation(String value) {
        return this.myAdditionalConverter instanceof AttributeValueDocumentationProvider ? ((AttributeValueDocumentationProvider)this.myAdditionalConverter).getDocumentation(value) : null;
    }
}

