/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileDescription;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;

public class ManifestDomFileDescription
extends DomFileDescription<Manifest> {
    public ManifestDomFileDescription() {
        super(Manifest.class, "manifest", new String[0]);
    }

    public boolean isMyFile(XmlFile file, Module module) {
        return module == null ? ManifestDomFileDescription.isManifestFile(file) : ManifestDomFileDescription.isManifestFile(file, module);
    }

    public static boolean isManifestFile(XmlFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return ManifestDomFileDescription.isManifestFile(file, module);
    }

    public static boolean isManifestFile(XmlFile file, Module module) {
        AndroidFacet facet;
        if (module != null && !module.isDisposed() && (facet = AndroidFacet.getInstance(module)) != null) {
            return ManifestDomFileDescription.isManifestFile(file, facet);
        }
        return file.getName().equals("AndroidManifest.xml");
    }

    public static boolean isManifestFile(XmlFile file, AndroidFacet facet) {
        return file.getName().equals("AndroidManifest.xml") || facet.requiresAndroidModel() && IdeaSourceProvider.isManifestFile(facet, file.getVirtualFile());
    }

    public static boolean isManifestFile(VirtualFile file, AndroidFacet facet) {
        return file.getName().equals("AndroidManifest.xml") || facet.requiresAndroidModel() && IdeaSourceProvider.isManifestFile(facet, file);
    }

    protected void initializeFileDescription() {
        this.registerNamespacePolicy("android", new String[]{"http://schemas.android.com/apk/res/android"});
    }
}

