/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;

class CreateNewModuleTask
extends ModuleProvidingTask {
    private final Project myProject;
    private final VirtualFile myContentRoot;

    public CreateNewModuleTask(Project project, VirtualFile contentRoot) {
        this.myContentRoot = contentRoot;
        this.myProject = project;
    }

    @Override
    public Exception perform() {
        Module depModule = (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                Module depModule = ModuleManager.getInstance((Project)CreateNewModuleTask.this.myProject).newModule(CreateNewModuleTask.this.myContentRoot.getPath() + '/' + CreateNewModuleTask.this.myContentRoot.getName() + ".iml", StdModuleTypes.JAVA.getId());
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)depModule).getModifiableModel();
                model.addContentEntry(CreateNewModuleTask.this.myContentRoot);
                model.commit();
                return depModule;
            }
        });
        if (AndroidFacet.getInstance(depModule) == null) {
            AndroidUtils.addAndroidFacetInWriteAction(depModule, this.myContentRoot, true);
        }
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(depModule, false);
        this.setDepModule(depModule);
        return null;
    }

    @Override
    public String getTitle() {
        String contentRootPath = FileUtil.toSystemDependentName((String)this.myContentRoot.getPath());
        return AndroidBundle.message("android.import.dependencies.new.module.task.title", this.getModuleName(), contentRootPath);
    }

    @Override
    public String getModuleName() {
        return this.myContentRoot.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNewModuleTask that = (CreateNewModuleTask)o;
        if (!this.myContentRoot.equals(that.myContentRoot)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myContentRoot.hashCode();
        return result;
    }

    @Override
    public VirtualFile getContentRoot() {
        return this.myContentRoot;
    }
}

