/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jdom.JDOMException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;

class ImportModuleTask
extends ModuleProvidingTask {
    private final Project myProject;
    private final String myModuleFilePath;
    private final VirtualFile myContentRoot;

    public ImportModuleTask(Project project, String moduleFilePath, VirtualFile contentRoot) {
        this.myModuleFilePath = moduleFilePath;
        this.myContentRoot = contentRoot;
        this.myProject = project;
    }

    @Override
    public Exception perform() {
        final Module[] moduleWrapper = new Module[]{null};
        Exception exception = (Exception)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Exception>(){

            public Exception compute() {
                try {
                    moduleWrapper[0] = ModuleManager.getInstance((Project)ImportModuleTask.this.myProject).loadModule(ImportModuleTask.this.myModuleFilePath);
                }
                catch (InvalidDataException e) {
                    return e;
                }
                catch (IOException e) {
                    return e;
                }
                catch (JDOMException e) {
                    return e;
                }
                catch (ModuleWithNameAlreadyExists e) {
                    return e;
                }
                return null;
            }
        });
        if (exception != null) {
            return exception;
        }
        assert (moduleWrapper[0] != null);
        if (AndroidFacet.getInstance(moduleWrapper[0]) == null) {
            AndroidUtils.addAndroidFacetInWriteAction(moduleWrapper[0], this.myContentRoot, true);
        }
        AndroidSdkUtils.setupAndroidPlatformIfNecessary(moduleWrapper[0], false);
        this.setDepModule(moduleWrapper[0]);
        return null;
    }

    @Override
    public String getTitle() {
        return AndroidBundle.message("android.import.dependencies.import.module.task.title", this.getModuleName(), FileUtil.toSystemDependentName((String)this.myModuleFilePath));
    }

    @Override
    public String getModuleName() {
        return FileUtil.getNameWithoutExtension((String)new File(this.myModuleFilePath).getName());
    }

    @Override
    public VirtualFile getContentRoot() {
        return this.myContentRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportModuleTask that = (ImportModuleTask)o;
        if (!this.myContentRoot.equals(that.myContentRoot)) {
            return false;
        }
        if (!this.myModuleFilePath.equals(that.myModuleFilePath)) {
            return false;
        }
        return this.myProject.equals(that.myProject);
    }

    public int hashCode() {
        int result = this.myProject.hashCode();
        result = 31 * result + this.myModuleFilePath.hashCode();
        result = 31 * result + this.myContentRoot.hashCode();
        return result;
    }
}

