/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.importDependencies;

import com.intellij.openapi.module.Module;
import org.jetbrains.android.importDependencies.ModuleProvidingTask;

abstract class ModuleProvider {
    private ModuleProvider() {
    }

    public abstract Module getModule();

    public abstract String getModuleName();

    public static ModuleProvider create(ModuleProvidingTask task) {
        return new MyNewModuleProvider(task);
    }

    public static ModuleProvider create(Module module) {
        return new MyExistingModuleProvider(module);
    }

    private static class MyExistingModuleProvider
    extends ModuleProvider {
        private final Module myModule;

        public MyExistingModuleProvider(Module module) {
            this.myModule = module;
        }

        @Override
        public Module getModule() {
            return this.myModule;
        }

        @Override
        public String getModuleName() {
            return this.myModule.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyExistingModuleProvider that = (MyExistingModuleProvider)o;
            return this.myModule.equals(that.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }
    }

    private static class MyNewModuleProvider
    extends ModuleProvider {
        private final ModuleProvidingTask myTask;

        public MyNewModuleProvider(ModuleProvidingTask task) {
            this.myTask = task;
        }

        @Override
        public Module getModule() {
            return this.myTask.getDepModule();
        }

        @Override
        public String getModuleName() {
            return this.myTask.getModuleName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyNewModuleProvider that = (MyNewModuleProvider)o;
            return this.myTask.equals(that.myTask);
        }

        public int hashCode() {
            return this.myTask.hashCode();
        }
    }
}

