/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;

public class CreateFileResourceQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.CreateFileResourceQuickFix");
    private final AndroidFacet myFacet;
    private final ResourceType myResourceType;
    private final String myResourceName;
    private final PsiFile myFile;
    private final boolean myChooseResName;

    public CreateFileResourceQuickFix(AndroidFacet facet, ResourceType resourceType, String resourceName, PsiFile file, boolean chooseResName) {
        this.myFacet = facet;
        this.myResourceType = resourceType;
        this.myResourceName = resourceName;
        this.myFile = file;
        this.myChooseResName = chooseResName;
    }

    public String getName() {
        return AndroidBundle.message("create.file.resource.quickfix.name", this.myResourceName, '\'' + this.myResourceType.getName() + "' directory");
    }

    public String getText() {
        return AndroidBundle.message("create.file.resource.intention.name", this.myResourceType, this.myResourceName + ".xml");
    }

    public String getFamilyName() {
        return AndroidBundle.message("quick.fixes.family", new Object[0]);
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        XmlFile newFile = CreateResourceFileAction.createFileResource(this.myFacet, this.myResourceType, this.myResourceName + ".xml", null, null, this.myChooseResName, null);
        if (newFile != null) {
            UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(Project project, ProblemDescriptor descriptor) {
        VirtualFile resourceDir = this.myFacet.getPrimaryResourceDir();
        if (resourceDir == null) {
            return;
        }
        final PsiDirectory psiResDir = PsiManager.getInstance((Project)project).findDirectory(resourceDir);
        if (psiResDir == null) {
            return;
        }
        final String resDirName = this.myResourceType.getName();
        PsiDirectory resSubdir = psiResDir.findSubdirectory(resDirName);
        if (resSubdir == null) {
            resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    return psiResDir.createSubdirectory(resDirName);
                }
            });
        }
        try {
            AndroidResourceUtil.createFileResource(this.myResourceName, resSubdir, CreateTypedResourceFileAction.getDefaultRootTagByResourceType(ResourceFolderType.getFolderType((String)resDirName)), resDirName, false);
            UndoUtil.markPsiFileForUndo((PsiFile)this.myFile);
            AndroidLayoutPreviewToolWindowManager.renderIfApplicable(project);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }
}

