/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.android.resources.ResourceType;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.DeclaredPermissionsLookup;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.ast.BinaryOperator;
import lombok.ast.NullLiteral;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.LombokPsiParser;
import org.jetbrains.android.util.AndroidUtils;

public class ResourceTypeInspection
extends BaseJavaLocalInspectionTool {
    private static final int VALID = 1001;
    private static final int INVALID = 1002;
    private static final int UNCERTAIN = 1003;
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"TYPE_DEF_LITERAL_EXPRESSION");

    public PsiElementVisitor buildVisitor(final ProblemsHolder holder, boolean isOnTheFly, LocalInspectionToolSession session) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)holder.getFile());
        if (facet == null) {
            return new PsiElementVisitor(){};
        }
        return new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression callExpression) {
                ResourceTypeInspection.checkCall((PsiCall)callExpression, holder);
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                ResourceTypeInspection.checkCall((PsiCall)enumConstant, holder);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                PsiExpression r = expression.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression.getLExpression();
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                PsiType type = expression.getType();
                ResourceTypeInspection.checkExpression(r, owner, type, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiMethod method;
                PsiExpression value = statement.getReturnValue();
                if (value == null) {
                    return;
                }
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression(value, (PsiModifierListOwner)method, value.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!(value instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                ResourceTypeInspection.checkExpression((PsiExpression)value, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression.getLOperand();
                PsiExpression r = expression.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(PsiExpression l, PsiExpression r) {
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)l).resolveMethod()) != null) {
                    ResourceTypeInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                }
            }
        };
    }

    private static void checkExpression(PsiExpression expression, PsiModifierListOwner owner, PsiType type, ProblemsHolder holder) {
        Constraints allowed = ResourceTypeInspection.getAllowedValues(owner, type, null);
        if (allowed == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression, null);
        if (scope == null) {
            scope = expression;
        }
        ResourceTypeInspection.checkConstraints(scope, expression, allowed, holder);
    }

    private static void checkConstraints(PsiElement scope, PsiExpression expression, Constraints constraints, ProblemsHolder holder) {
        if (expression.getTextRange().isEmpty()) {
            return;
        }
        PsiManager manager = expression.getManager();
        if (constraints.next != null && ExpressionUtils.isLiteral((PsiExpression)expression)) {
            if (!ResourceTypeInspection.isAllowed(scope, expression, constraints, manager, null)) {
                if (!ResourceTypeInspection.isAllowed(scope, expression, constraints.next, manager, null)) {
                    ResourceTypeInspection.registerProblem(expression, constraints, holder);
                }
            } else if (!ResourceTypeInspection.isAllowed(scope, expression, constraints.next, manager, null)) {
                ResourceTypeInspection.registerProblem(expression, constraints.next, holder);
            }
        } else if (!ResourceTypeInspection.isAllowed(scope, expression, constraints, manager, null)) {
            ResourceTypeInspection.registerProblem(expression, constraints, holder);
        }
    }

    private static void checkCall(PsiCall methodCall, ProblemsHolder holder) {
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiExpressionList argumentList = methodCall.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            Constraints values = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)parameter, parameter.getType(), null);
            if (values == null) continue;
            if (i >= arguments.length) break;
            PsiExpression argument = arguments[i];
            if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
            ResourceTypeInspection.checkConstraints(parameter.getDeclarationScope(), argument, values, holder);
        }
        ResourceTypeInspection.checkMethodAnnotations(methodCall, holder, method);
    }

    private static void checkMethodAnnotations(PsiCall methodCall, ProblemsHolder holder, PsiMethod method) {
        PsiAnnotation[] annotations;
        for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)method)) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (!qualifiedName.startsWith("android.support.annotation.")) {
                PsiElement resolved;
                if (qualifiedName.startsWith("java.lang")) continue;
                PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
                if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                PsiClass cls = (PsiClass)resolved;
                for (PsiAnnotation a : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    qualifiedName = a.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.endsWith("android.support.annotation.RequiresPermission")) continue;
                    ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, a);
                }
                continue;
            }
            if ("android.support.annotation.RequiresPermission".equals(qualifiedName)) {
                ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, annotation);
                continue;
            }
            if ("android.support.annotation.CheckResult".equals(qualifiedName)) {
                ResourceTypeInspection.checkReturnValueUsage(methodCall, holder, method);
                continue;
            }
            if (!qualifiedName.endsWith("Thread")) continue;
            ResourceTypeInspection.checkThreadAnnotation(methodCall, holder, method, qualifiedName);
        }
        PsiClass cls = method.getContainingClass();
        if (cls != null) {
            for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                PsiElement resolved;
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName != null && qualifiedName.endsWith("Thread")) {
                    ResourceTypeInspection.checkThreadAnnotation(methodCall, holder, method, qualifiedName);
                    continue;
                }
                if (qualifiedName == null || qualifiedName.startsWith("java.lang")) continue;
                PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
                PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
                if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                cls = (PsiClass)resolved;
                for (PsiAnnotation a : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    qualifiedName = a.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.endsWith("android.support.annotation.RequiresPermission")) continue;
                    ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, a);
                }
            }
        }
    }

    private static PermissionFinder.Result search(PsiElement node, PermissionFinder.Operation operation) {
        block23: {
            PsiElement resolved;
            block24: {
                block22: {
                    if (node instanceof NullLiteral) {
                        return null;
                    }
                    if (!(node instanceof PsiTypeCastExpression)) break block22;
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)node;
                    PsiExpression operand = cast.getOperand();
                    if (operand != null) {
                        return ResourceTypeInspection.search((PsiElement)operand, operation);
                    }
                    break block23;
                }
                if (node instanceof PsiNewExpression && operation == PermissionFinder.Operation.ACTION) {
                    PsiExpression[] expressions;
                    PsiExpressionList argumentList;
                    String qualifiedName;
                    PsiNewExpression call = (PsiNewExpression)node;
                    PsiJavaCodeReferenceElement classOrAnonymousClassReference = call.getClassOrAnonymousClassReference();
                    if (classOrAnonymousClassReference != null && "android.content.Intent".equals(qualifiedName = classOrAnonymousClassReference.getQualifiedName()) && (argumentList = call.getArgumentList()) != null && (expressions = argumentList.getExpressions()).length > 0) {
                        return ResourceTypeInspection.search((PsiElement)expressions[0], operation);
                    }
                    return null;
                }
                if (!(node instanceof PsiJavaReference)) break block23;
                resolved = ((PsiJavaReference)node).resolve();
                if (!(resolved instanceof PsiField)) break block24;
                PsiField field = (PsiField)resolved;
                if (operation == PermissionFinder.Operation.ACTION) {
                    for (PsiAnnotation annotation : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)field)) {
                        if (!"android.support.annotation.RequiresPermission".equals(annotation.getQualifiedName())) continue;
                        return ResourceTypeInspection.getPermissionRequirement(field, annotation, operation);
                    }
                } else if (operation == PermissionFinder.Operation.READ || operation == PermissionFinder.Operation.WRITE) {
                    PsiExpression[] expressions;
                    PsiMethodCallExpression call;
                    String fqn = operation == PermissionFinder.Operation.READ ? "android.support.annotation.RequiresPermission.Read" : "android.support.annotation.RequiresPermission.Write";
                    PsiAnnotation annotation = null;
                    for (PsiAnnotation a : ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)field)) {
                        if (!fqn.equals(a.getQualifiedName())) continue;
                        annotation = null;
                        if (AnnotationUtil.isExternalAnnotation((PsiAnnotation)a)) {
                            annotation = a;
                            break;
                        }
                        PsiAnnotationMemberValue o = a.findAttributeValue("value");
                        if (o instanceof PsiAnnotation && "android.support.annotation.RequiresPermission".equals((annotation = (PsiAnnotation)o).getQualifiedName())) break;
                    }
                    if (annotation != null) {
                        return ResourceTypeInspection.getPermissionRequirement(field, annotation, operation);
                    }
                    PsiExpression initializer = field.getInitializer();
                    if (initializer instanceof PsiMethodCallExpression && (call = (PsiMethodCallExpression)initializer).getMethodExpression().getQualifiedName().equals("Uri.withAppendedPath") && (expressions = call.getArgumentList().getExpressions()).length == 2) {
                        return ResourceTypeInspection.search((PsiElement)expressions[0], operation);
                    }
                } else assert (false) : operation;
                break block23;
            }
            if (!(resolved instanceof PsiLocalVariable)) break block23;
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PsiStatement.class, (boolean)false);
            while (statement != null) {
                PsiBinaryExpression binary;
                if (statement instanceof PsiDeclarationStatement) {
                    PsiElement[] declaredElements;
                    PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement;
                    for (PsiElement declared : declaredElements = declaration.getDeclaredElements()) {
                        PsiExpression initializer;
                        if (declared != resolved || !(declared instanceof PsiLocalVariable) || (initializer = ((PsiLocalVariable)declared).getInitializer()) == null) continue;
                        return ResourceTypeInspection.search((PsiElement)initializer, operation);
                    }
                } else if (statement instanceof PsiExpressionStatement) {
                    PsiExpression value;
                    PsiElement variable;
                    PsiAssignmentExpression assignment;
                    PsiExpression expression = ((PsiExpressionStatement)statement).getExpression();
                    if (expression instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)expression).getLExpression() instanceof PsiReferenceExpression && (variable = ((PsiReferenceExpression)assignment.getLExpression()).resolve()) == resolved && (value = assignment.getRExpression()) != null) {
                        return ResourceTypeInspection.search((PsiElement)value, operation);
                    }
                } else if (statement instanceof PsiBinaryExpression && (binary = (PsiBinaryExpression)statement).getOperationTokenType() == JavaTokenType.EQ && binary.getLOperand() == resolved && binary.getROperand() != null) {
                    return ResourceTypeInspection.search((PsiElement)binary.getROperand(), operation);
                }
                statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            }
        }
        return null;
    }

    private static PermissionFinder.Result getPermissionRequirement(PsiField field, PsiAnnotation annotation, PermissionFinder.Operation operation) {
        PermissionRequirement requirement = PermissionRequirement.create(null, (JavaParser.ResolvedAnnotation)LombokPsiParser.createResolvedAnnotation(annotation));
        PsiClass containingClass = field.getContainingClass();
        String name = containingClass != null ? containingClass.getName() + "." + field.getName() : field.getName();
        return new PermissionFinder.Result(operation, requirement, name);
    }

    private static void checkThreadAnnotation(PsiCall methodCall, ProblemsHolder holder, PsiMethod method, String qualifiedName) {
        String threadContext = ResourceTypeInspection.getThreadContext(methodCall);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread((String)threadContext, (String)qualifiedName)) {
            String message = String.format("Method %1$s must be called from the %2$s thread, currently inferred thread is %3$s", method.getName(), SupportAnnotationDetector.describeThread((String)qualifiedName), SupportAnnotationDetector.describeThread((String)threadContext));
            holder.registerProblem((PsiElement)methodCall, message, new LocalQuickFix[0]);
        }
    }

    private static String getThreadContext(PsiCall methodCall) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true);
        if (method != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)method)) {
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null || !qualifiedName.startsWith("android.support.annotation.") || !qualifiedName.endsWith("Thread")) continue;
                return qualifiedName;
            }
            PsiClass cls = method.getContainingClass();
            if (cls != null) {
                for (PsiAnnotation annotation : annotations = ResourceTypeInspection.getAllAnnotations((PsiModifierListOwner)cls)) {
                    String qualifiedName = annotation.getQualifiedName();
                    if (qualifiedName == null || !qualifiedName.startsWith("android.support.annotation.") || !qualifiedName.endsWith("Thread")) continue;
                    return qualifiedName;
                }
            }
        }
        return null;
    }

    private static void checkPermissionRequirement(PsiCall methodCall, ProblemsHolder holder, PsiMethod method, PsiAnnotation annotation) {
        PermissionRequirement requirement = PermissionRequirement.create(null, (JavaParser.ResolvedAnnotation)LombokPsiParser.createResolvedAnnotation(annotation));
        ResourceTypeInspection.checkPermissionRequirement(methodCall, holder, method, null, requirement);
    }

    private static void checkPermissionRequirement(PsiCall methodCall, ProblemsHolder holder, PsiMethod method, PermissionFinder.Result result, PermissionRequirement requirement) {
        if (!requirement.isConditional()) {
            Project project = methodCall.getProject();
            AndroidFacet facet = AndroidFacet.getInstance((PsiElement)methodCall);
            assert (facet != null);
            PermissionHolder lookup = DeclaredPermissionsLookup.getPermissionHolder(facet.getModule());
            if (!requirement.isSatisfied(lookup)) {
                String methodName;
                PermissionFinder.Operation operation;
                if (requirement.isSatisfied(lookup = ResourceTypeInspection.addLocalPermissions(lookup, methodCall))) {
                    return;
                }
                if (result != null) {
                    operation = result.operation;
                    methodName = result.name;
                } else {
                    assert (method != null);
                    operation = PermissionFinder.Operation.CALL;
                    PsiClass containingClass = method.getContainingClass();
                    methodName = containingClass != null ? containingClass.getName() + "." + method.getName() : method.getName();
                }
                String message = SupportAnnotationDetector.getMissingPermissionMessage((PermissionRequirement)requirement, (String)methodName, (PermissionHolder)lookup, (PermissionFinder.Operation)operation);
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                ArrayList list = Lists.newArrayList();
                for (String permissionName : requirement.getMissingPermissions(lookup)) {
                    list.add(new AddPermissionFix(facet, permissionName));
                }
                if (!list.isEmpty()) {
                    fixes = list.toArray(new LocalQuickFix[list.size()]);
                }
                holder.registerProblem((PsiElement)methodCall, message, fixes);
            } else if (requirement.isRevocable(lookup) && AndroidModuleInfo.get(facet).getTargetSdkVersion().getFeatureLevel() >= 23) {
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                PsiClass securityException = psiFacade.findClass("java.lang.SecurityException", GlobalSearchScope.allScope((Project)project));
                if (securityException != null && ResourceTypeInspection.isHandled((PsiElement)methodCall, PsiTypesUtil.getClassType((PsiClass)securityException), (PsiElement)methodCall.getContainingFile())) {
                    return;
                }
                PsiMethod methodNode = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true);
                if (methodNode != null) {
                    for (PsiMethodCallExpression call : PsiTreeUtil.collectElementsOfType((PsiElement)methodNode, (Class[])new Class[]{PsiMethodCallExpression.class})) {
                        String name = call.getMethodExpression().getReferenceName();
                        if (name == null || !name.endsWith("Permission") || !name.startsWith("check") && !name.startsWith("enforce")) continue;
                        return;
                    }
                    Set revocablePermissions = requirement.getRevocablePermissions(lookup);
                    AddCheckPermissionFix fix = new AddCheckPermissionFix(facet, requirement, methodCall, revocablePermissions);
                    holder.registerProblem((PsiElement)methodCall, SupportAnnotationDetector.getUnhandledPermissionMessage(), new LocalQuickFix[]{fix});
                }
            }
        }
    }

    private static PermissionHolder addLocalPermissions(PermissionHolder lookup, PsiCall call) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class);
        if (method == null) {
            return lookup;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton("android.support.annotation.RequiresPermission"));
        if (annotation == null) {
            return lookup;
        }
        PermissionRequirement requirement = PermissionRequirement.create(null, (JavaParser.ResolvedAnnotation)LombokPsiParser.createResolvedAnnotation(annotation));
        return PermissionHolder.SetPermissionLookup.join((PermissionHolder)lookup, (PermissionRequirement)requirement);
    }

    private static void checkReturnValueUsage(PsiCall methodCall, ProblemsHolder holder, PsiMethod method) {
        if (methodCall.getParent() instanceof PsiExpressionStatement) {
            String suggest;
            PsiLiteral literal;
            Object literalValue;
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"android.support.annotation.CheckResult"});
            if (annotation == null) {
                return;
            }
            String message = String.format("The result of '%1$s' is not used", method.getName());
            PsiAnnotationMemberValue value = annotation.findAttributeValue("suggest");
            if (value instanceof PsiLiteral && (literalValue = (literal = (PsiLiteral)value).getValue()) instanceof String && !(suggest = (String)literalValue).isEmpty()) {
                String name = suggest;
                if (name.startsWith("#")) {
                    name = name.substring(1);
                }
                message = String.format("The result of '%1$s' is not used; did you mean to call '%2$s'?", method.getName(), name);
                if (suggest.startsWith("#") && methodCall instanceof PsiMethodCallExpression) {
                    holder.registerProblem((PsiElement)methodCall, message, new LocalQuickFix[]{new ReplaceCallFix((PsiMethodCallExpression)methodCall, suggest)});
                    return;
                }
            }
            holder.registerProblem((PsiElement)methodCall, message, new LocalQuickFix[0]);
        }
    }

    private static Constraints getAllowedValuesFromTypedef(PsiType type, PsiAnnotation magic, PsiManager manager) {
        boolean canBeOred;
        PsiAnnotationMemberValue[] allowedValues;
        boolean isString;
        boolean isInt = TypeConversionUtil.getTypeRank((PsiType)type) <= 5;
        boolean bl = isString = !isInt && type.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())));
        if (isInt || isString) {
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("value");
            PsiAnnotationMemberValue[] psiAnnotationMemberValueArray = allowedValues = intValues instanceof PsiArrayInitializerMemberValue ? ((PsiArrayInitializerMemberValue)intValues).getInitializers() : PsiAnnotationMemberValue.EMPTY_ARRAY;
            canBeOred = isInt ? (orValue = magic.findAttributeValue("flag")) instanceof PsiLiteral && Boolean.TRUE.equals(((PsiLiteral)orValue).getValue()) : false;
        } else {
            return null;
        }
        if (allowedValues.length != 0) {
            return new AllowedValues(allowedValues, canBeOred);
        }
        return null;
    }

    public static ResourceType getResourceTypeFromAnnotation(String qualifiedName) {
        String resourceTypeName = Character.toLowerCase(qualifiedName.charAt("android.support.annotation.".length())) + qualifiedName.substring("android.support.annotation.".length() + 1, qualifiedName.length() - "Res".length());
        return ResourceType.getEnum((String)resourceTypeName);
    }

    private static Constraints merge(Constraints head, Constraints tail) {
        if (head != null) {
            if (tail != null) {
                head.next = tail;
                if (tail instanceof AllowedValues) {
                    head.next = tail.next;
                    tail.next = head;
                    head = tail;
                }
                return head;
            }
            return head;
        }
        return tail;
    }

    public static Constraints getAllowedValues(PsiModifierListOwner element, PsiType type, Set<PsiClass> visited) {
        PsiAnnotation[] annotations = ResourceTypeInspection.getAllAnnotations(element);
        PsiManager manager = element.getManager();
        ArrayList resourceTypes = null;
        Constraints constraint = null;
        for (PsiAnnotation annotation : annotations) {
            PsiElement resolved;
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            if (qualifiedName.startsWith("android.support.annotation.") || qualifiedName.startsWith("test.pkg.")) {
                ResourceType resourceType;
                if ("android.support.annotation.IntDef".equals(qualifiedName) || "android.support.annotation.StringDef".equals(qualifiedName)) {
                    if (type != null) {
                        constraint = ResourceTypeInspection.merge(ResourceTypeInspection.getAllowedValuesFromTypedef(type, annotation, manager), constraint);
                    }
                } else if ("android.support.annotation.IntRange".equals(qualifiedName) || "test.pkg.IntRange".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new IntRangeConstraint(annotation), constraint);
                } else if ("android.support.annotation.FloatRange".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new FloatRangeConstraint(annotation), constraint);
                } else if ("android.support.annotation.Size".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new SizeConstraint(annotation), constraint);
                } else if ("android.support.annotation.ColorInt".equals(qualifiedName)) {
                    constraint = ResourceTypeInspection.merge(new ResourceTypeAllowedValues(Collections.<ResourceType>emptyList()), constraint);
                } else if (qualifiedName.startsWith("android.support.annotation.RequiresPermission")) {
                    constraint = ResourceTypeInspection.merge(new IndirectPermission(qualifiedName), constraint);
                } else if (qualifiedName.endsWith("Res") && (resourceType = ResourceTypeInspection.getResourceTypeFromAnnotation(qualifiedName)) != null) {
                    if (resourceTypes == null) {
                        resourceTypes = Lists.newArrayList();
                    }
                    resourceTypes.add(resourceType);
                }
            }
            if (constraint != null) continue;
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass)) continue;
            constraint = ResourceTypeInspection.merge(ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)aClass, type, (Set<PsiClass>)visited), constraint);
        }
        if (resourceTypes != null) {
            constraint = ResourceTypeInspection.merge(new ResourceTypeAllowedValues(resourceTypes), constraint);
        }
        return constraint;
    }

    public static PsiAnnotation[] getAllAnnotations(final PsiModifierListOwner element) {
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)element, (CachedValueProvider)new CachedValueProvider<PsiAnnotation[]>(){

            public CachedValueProvider.Result<PsiAnnotation[]> compute() {
                return CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)element, (boolean)true, null), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
    }

    private static PsiType getType(PsiModifierListOwner element) {
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void registerProblem(PsiExpression argument, Constraints constraint, ProblemsHolder holder) {
        if (constraint instanceof IndirectPermission) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiMethodCallExpression.class);
            IndirectPermission ip = (IndirectPermission)constraint;
            if (call != null && ip.result != null) {
                ResourceTypeInspection.checkPermissionRequirement((PsiCall)call, holder, null, ip.result, ip.result.requirement);
            }
        } else if (constraint instanceof ResourceTypeAllowedValues) {
            List<ResourceType> types = ((ResourceTypeAllowedValues)constraint).types;
            String message = types.isEmpty() ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.getText()) : (types.size() == 1 ? "Expected resource of type " + types.get(0) : "Expected resource type to be one of " + Joiner.on((String)", ").join(types));
            holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
        } else if (constraint instanceof RangeAllowedValues) {
            String message = ((RangeAllowedValues)constraint).describe(argument);
            holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
        } else {
            assert (constraint instanceof AllowedValues);
            AllowedValues typedef = (AllowedValues)constraint;
            Function<PsiAnnotationMemberValue, String> formatter = new Function<PsiAnnotationMemberValue, String>(){

                public String fun(PsiAnnotationMemberValue value) {
                    PsiElement resolved;
                    if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiVariable) {
                        return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    }
                    return value.getText();
                }
            };
            String values = StringUtil.join((Object[])typedef.values, (Function)formatter, (String)", ");
            String message = typedef.canBeOred ? "Must be one or more of: " + values : "Must be one of: " + values;
            if (constraint.next instanceof RangeAllowedValues) {
                message = message + " or " + StringUtil.decapitalize((String)((RangeAllowedValues)constraint.next).describe(argument));
            }
            holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
        }
    }

    private static boolean isAllowed(final PsiElement scope, PsiExpression argument, Constraints constraints, final PsiManager manager, final Set<PsiExpression> visited) {
        if (constraints instanceof ResourceTypeAllowedValues) {
            return ResourceTypeInspection.isResourceTypeAllowed(scope, argument, (ResourceTypeAllowedValues)constraints, manager, visited);
        }
        if (constraints instanceof RangeAllowedValues) {
            return ResourceTypeInspection.isInRange(scope, argument, (RangeAllowedValues)constraints, manager, visited);
        }
        if (constraints instanceof IndirectPermission) {
            return ResourceTypeInspection.isGrantedPermission(argument, (IndirectPermission)constraints);
        }
        assert (constraints instanceof AllowedValues);
        final AllowedValues a = (AllowedValues)constraints;
        if (ResourceTypeInspection.isGoodExpression(argument, a, scope, manager, visited)) {
            return true;
        }
        boolean allowed = ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                return ResourceTypeInspection.isGoodExpression(expression, a, scope, manager, visited);
            }
        });
        return allowed;
    }

    private static boolean isGoodExpression(PsiExpression e, AllowedValues allowedValues, PsiElement scope, PsiManager manager, Set<PsiExpression> visited) {
        Constraints allowedForRef;
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return true;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited);
        }
        if (ResourceTypeInspection.isOneOf(expression, allowedValues, manager)) {
            return true;
        }
        if (allowedValues.canBeOred) {
            IElementType tokenType;
            PsiExpression zero = ResourceTypeInspection.getLiteralExpression(expression, manager, "0");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)zero, manager)) {
                return true;
            }
            PsiExpression one = ResourceTypeInspection.getLiteralExpression(expression, manager, "-1");
            if (ResourceTypeInspection.same((PsiElement)expression, (PsiElement)one, manager)) {
                return true;
            }
            if (expression instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand : ((PsiPolyadicExpression)expression).getOperands()) {
                    if (ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited)) continue;
                    return false;
                }
                return true;
            }
            if (expression instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                PsiExpression operand = ((PsiPrefixExpression)expression).getOperand();
                return operand == null || ResourceTypeInspection.isAllowed(scope, operand, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            resolved = ((PsiReference)expression).resolve();
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return true;
        }
        return PsiType.NULL.equals((Object)expression.getType());
    }

    private static long getLongValue(PsiElement value, long defaultValue) {
        PsiElement resolved;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            Object o = ((PsiLiteral)value).getValue();
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
        } else if (value instanceof PsiPrefixExpression) {
            Object o;
            PsiExpression operand;
            PsiPrefixExpression exp = (PsiPrefixExpression)value;
            if (exp.getOperationTokenType() == JavaTokenType.MINUS && (operand = exp.getOperand()) instanceof PsiLiteral && (o = ((PsiLiteral)operand).getValue()) instanceof Number) {
                return -((Number)o).longValue();
            }
        } else if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) {
            return ResourceTypeInspection.getLongValue((PsiElement)((PsiField)resolved).getInitializer(), defaultValue);
        }
        return defaultValue;
    }

    private static double getDoubleValue(PsiAnnotationMemberValue value, double defaultValue) {
        PsiElement resolved;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral) {
            Object o = ((PsiLiteral)value).getValue();
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
        } else if (value instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value).resolve()) instanceof PsiField) {
            return ResourceTypeInspection.getDoubleValue((PsiAnnotationMemberValue)((PsiField)resolved).getInitializer(), defaultValue);
        }
        return defaultValue;
    }

    private static boolean getBooleanValue(PsiAnnotationMemberValue value, boolean defaultValue) {
        Object o;
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof PsiLiteral && (o = ((PsiLiteral)value).getValue()) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    private static boolean isResourceTypeAllowed(final PsiElement scope, PsiExpression argument, final ResourceTypeAllowedValues allowedValues, final PsiManager manager, final Set<PsiExpression> visited) {
        int result = ResourceTypeInspection.isValidResourceTypeExpression(argument, allowedValues, scope, manager, visited);
        if (result == 1001) {
            return true;
        }
        if (result == 1002) {
            return false;
        }
        assert (result == 1003);
        final AtomicInteger b = new AtomicInteger();
        ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                int goodExpression = ResourceTypeInspection.isValidResourceTypeExpression(expression, allowedValues, scope, manager, visited);
                b.set(goodExpression);
                return goodExpression == 1003;
            }
        });
        result = b.get();
        return result != 1002;
    }

    private static int isValidResourceTypeExpression(PsiExpression e, ResourceTypeAllowedValues allowedValues, PsiElement scope, PsiManager manager, Set<PsiExpression> visited) {
        PsiType type;
        Constraints allowedForRef;
        Object value;
        PsiPrefixExpression ppe;
        PsiExpression r;
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return 1001;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return 1001;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return 1002;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited) ? 1001 : 1003;
        }
        if (expression instanceof PsiReferenceExpression) {
            String typeName;
            PsiReferenceExpression typeDef;
            PsiReferenceExpression refExpression = (PsiReferenceExpression)expression;
            PsiExpression qualifierExpression = refExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && (r = (typeDef = (PsiReferenceExpression)qualifierExpression).getQualifierExpression()) instanceof PsiReferenceExpression && "R".equals(((PsiReferenceExpression)r).getReferenceName()) && (typeName = typeDef.getReferenceName()) != null) {
                return allowedValues.isTypeAllowed(typeName) ? 1001 : 1002;
            }
        } else if (expression instanceof PsiLiteral) {
            Object value2;
            if (expression instanceof PsiLiteralExpression) {
                PsiElement outerMost;
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiField && (parent = parent.getParent()) instanceof PsiClass && (outerMost = parent.getParent()) instanceof PsiClass && "R".equals(((PsiClass)outerMost).getName())) {
                    PsiClass typeClass = (PsiClass)parent;
                    String typeClassName = typeClass.getName();
                    return allowedValues.isTypeAllowed(typeClassName) ? 1001 : 1002;
                }
                if (allowedValues.types.isEmpty() && expression.getType() == PsiType.INT) {
                    return 1001;
                }
            }
            if ((value2 = ((PsiLiteral)expression).getValue()) instanceof Integer) {
                return (Integer)value2 == 0 ? 1001 : 1002;
            }
        } else if (expression instanceof PsiPrefixExpression && (ppe = (PsiPrefixExpression)expression).getOperationTokenType() == JavaTokenType.MINUS && ppe.getOperand() instanceof PsiLiteral && (value = ((PsiLiteral)ppe.getOperand()).getValue()) instanceof Integer) {
            return (Integer)value == 1 ? 1001 : 1002;
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            ResourceType type2;
            PsiField field;
            PsiClass containingClass;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (containingClass = (field = (PsiField)resolved).getContainingClass()) != null && (r = containingClass.getContainingClass()) != null && "R".equals(r.getName()) && (type2 = ResourceType.getEnum((String)containingClass.getName())) != null) {
                for (ResourceType t : allowedValues.types) {
                    if (t != type2) continue;
                    return 1001;
                }
                return 1002;
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) instanceof ResourceTypeAllowedValues) {
            return allowedValues.isCompatibleWith((ResourceTypeAllowedValues)allowedForRef) ? 1001 : 1002;
        }
        return 1003;
    }

    private static boolean isInRange(final PsiElement scope, PsiExpression argument, final RangeAllowedValues allowedValues, final PsiManager manager, final Set<PsiExpression> visited) {
        int result = ResourceTypeInspection.isValidRangeExpression(argument, allowedValues, scope, manager, visited);
        if (result == 1001) {
            return true;
        }
        if (result == 1002) {
            return false;
        }
        assert (result == 1003);
        final AtomicInteger b = new AtomicInteger();
        ResourceTypeInspection.processValuesFlownTo(argument, scope, manager, new Processor<PsiExpression>(){

            public boolean process(PsiExpression expression) {
                int goodExpression = ResourceTypeInspection.isValidRangeExpression(expression, allowedValues, scope, manager, visited);
                b.set(goodExpression);
                return goodExpression == 1003;
            }
        });
        result = b.get();
        return result != 1002;
    }

    private static int isValidRangeExpression(PsiExpression e, RangeAllowedValues allowedValues, PsiElement scope, PsiManager manager, Set<PsiExpression> visited) {
        PsiType type;
        Constraints allowedForRef;
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)e);
        if (expression == null) {
            return 1001;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression)) {
            return 1001;
        }
        if (expression instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression = ((PsiConditionalExpression)expression).getThenExpression();
            boolean bl = thenAllowed = thenExpression == null || ResourceTypeInspection.isAllowed(scope, thenExpression, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return 1002;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expression).getElseExpression();
            return elseExpression == null || ResourceTypeInspection.isAllowed(scope, elseExpression, allowedValues, manager, (Set<PsiExpression>)visited) ? 1001 : 1003;
        }
        int valid = allowedValues.isValid(expression);
        if (valid != 1003) {
            return valid;
        }
        PsiElement resolved = null;
        if (expression instanceof PsiReference) {
            int fieldValid;
            PsiField field;
            resolved = ((PsiReference)expression).resolve();
            if (resolved instanceof PsiField && (field = (PsiField)resolved).getInitializer() != null && (fieldValid = allowedValues.isValid(field.getInitializer())) != 1003) {
                return fieldValid;
            }
        } else if (expression instanceof PsiCallExpression) {
            resolved = ((PsiCallExpression)expression).resolveMethod();
        }
        if (resolved instanceof PsiModifierListOwner && (allowedForRef = ResourceTypeInspection.getAllowedValues((PsiModifierListOwner)resolved, type = ResourceTypeInspection.getType((PsiModifierListOwner)resolved), null)) instanceof RangeAllowedValues) {
            return allowedValues.isCompatibleWith((RangeAllowedValues)allowedForRef);
        }
        return 1003;
    }

    private static boolean isGrantedPermission(PsiExpression argument, IndirectPermission permission) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiMethodCallExpression.class);
        if (call != null) {
            PermissionFinder.Operation operation;
            String signature = permission.signature;
            if (signature.equals("android.support.annotation.RequiresPermission.Read")) {
                operation = PermissionFinder.Operation.READ;
            } else if (signature.equals("android.support.annotation.RequiresPermission.Write")) {
                operation = PermissionFinder.Operation.WRITE;
            } else {
                PsiType type = argument.getType();
                if (type == null || !"android.content.Intent".equals(type.getCanonicalText())) {
                    return true;
                }
                operation = PermissionFinder.Operation.ACTION;
            }
            permission.result = ResourceTypeInspection.search((PsiElement)argument, operation);
            if (permission.result != null) {
                return false;
            }
        }
        return true;
    }

    private static PsiExpression getLiteralExpression(PsiExpression context, PsiManager manager, String text) {
        PsiExpression expression;
        Map cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager);
        if (cache == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression = (PsiExpression)cache.get(text)) == null) {
            expression = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text, (PsiElement)context);
            cache.put(text, expression);
        }
        return expression;
    }

    private static boolean isOneOf(PsiExpression expression, AllowedValues allowedValues, PsiManager manager) {
        for (PsiAnnotationMemberValue allowedValue : allowedValues.values) {
            if (!ResourceTypeInspection.same((PsiElement)allowedValue, (PsiElement)expression, manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(PsiElement e1, PsiElement e2, PsiManager manager) {
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            return ResourceTypeInspection.same((PsiElement)((PsiPrefixExpression)e1).getOperand(), (PsiElement)((PsiPrefixExpression)e2).getOperand(), manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    private static boolean processValuesFlownTo(PsiExpression argument, PsiElement scope, PsiManager manager, Processor<PsiExpression> processor) {
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), SliceUsage.createRootUsage((PsiElement)argument, (SliceAnalysisParams)params));
        Collection children = ((AbstractTreeNode)rootNode.getChildren().iterator().next()).getChildren();
        for (AbstractTreeNode child : children) {
            PsiElement element;
            SliceUsage usage = (SliceUsage)child.getValue();
            if (usage == null || !((element = usage.getElement()) instanceof PsiExpression) || processor.process((Object)((PsiExpression)element))) continue;
            return false;
        }
        return !children.isEmpty();
    }

    private static boolean isHandled(PsiElement element, PsiClassType exceptionType, PsiElement topElement) {
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ResourceTypeInspection.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ResourceTypeInspection.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ResourceTypeInspection.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ResourceTypeInspection.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ResourceTypeInspection.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else if (parent instanceof PsiFile) {
            return false;
        }
        return ResourceTypeInspection.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isHandledByMethodThrowsClause(PsiMethod method, PsiClassType exceptionType, PsiSubstitutor substitutor) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ResourceTypeInspection.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(PsiClassType exceptionType, PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute((PsiType)classType);
            if (psiType == null || !psiType.equals(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ResourceTypeInspection.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.equals(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(PsiCodeBlock finallyBlock) {
        try {
            ControlFlow flow = ControlFlowFactory.getInstance((Project)finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons((ControlFlow)flow, (int)0, (int)flow.getSize());
            if ((completionReasons & 1) == 0) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    static class IndirectPermission
    extends Constraints {
        public final String signature;
        public PermissionFinder.Result result;

        public IndirectPermission(String signature) {
            this.signature = signature;
        }
    }

    static class SizeConstraint
    extends RangeAllowedValues {
        final long exact;
        final long min;
        final long max;
        final long multiple;

        public SizeConstraint(PsiAnnotation annotation) {
            PsiAnnotationMemberValue exactValue = annotation.findAttributeValue("value");
            PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("min");
            PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("max");
            PsiAnnotationMemberValue multipleValue = annotation.findDeclaredAttributeValue("multiple");
            this.exact = ResourceTypeInspection.getLongValue((PsiElement)exactValue, -1L);
            this.min = ResourceTypeInspection.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
            this.max = ResourceTypeInspection.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
            this.multiple = ResourceTypeInspection.getLongValue((PsiElement)multipleValue, 1L);
        }

        @Override
        public int isValid(PsiExpression argument) {
            Number size = this.guessSize(argument);
            if (size == null) {
                return 1003;
            }
            int actual = size.intValue();
            if (this.exact != -1L ? this.exact != (long)actual : (long)actual < this.min || (long)actual > this.max || (long)actual % this.multiple != 0L) {
                return 1002;
            }
            return 1001;
        }

        @Override
        protected Number guessSize(PsiExpression argument) {
            if (argument instanceof PsiNewExpression) {
                PsiNewExpression pne = (PsiNewExpression)argument;
                PsiArrayInitializerExpression initializer = pne.getArrayInitializer();
                if (initializer != null) {
                    return initializer.getInitializers().length;
                }
                PsiExpression[] dimensions = pne.getArrayDimensions();
                if (dimensions.length > 0) {
                    PsiExpression dimension = dimensions[0];
                    return super.guessSize(dimension);
                }
            } else if (argument instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)argument;
                Object o = literal.getValue();
                if (o instanceof String) {
                    return ((String)o).length();
                }
            } else if (argument instanceof PsiBinaryExpression) {
                Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argument, (boolean)false);
                if (v instanceof String) {
                    return ((String)v).length();
                }
            } else if (argument instanceof PsiReferenceExpression) {
                PsiLocalVariable variable;
                PsiExpression initializer;
                PsiReferenceExpression ref = (PsiReferenceExpression)argument;
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    PsiExpression initializer2 = field.getInitializer();
                    if (initializer2 != null) {
                        return this.guessSize(initializer2);
                    }
                } else if (resolved instanceof PsiLocalVariable && (initializer = (variable = (PsiLocalVariable)resolved).getInitializer()) != null) {
                    return this.guessSize(initializer);
                }
            }
            return null;
        }

        @Override
        public String describe(PsiExpression argument) {
            Number actual;
            StringBuilder sb = new StringBuilder(20);
            if (argument.getType() != null && argument.getType().getCanonicalText().equals("java.lang.String")) {
                sb.append("Length");
            } else {
                sb.append("Size");
            }
            sb.append(" must be");
            if (this.exact != -1L) {
                sb.append(" exactly ");
                sb.append(Long.toString(this.exact));
                return sb.toString();
            }
            boolean continued = true;
            if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
                sb.append(" at least ");
                sb.append(Long.toString(this.min));
                sb.append(" and at most ");
                sb.append(Long.toString(this.max));
            } else if (this.min != Long.MIN_VALUE) {
                sb.append(" at least ");
                sb.append(Long.toString(this.min));
            } else if (this.max != Long.MAX_VALUE) {
                sb.append(" at most ");
                sb.append(Long.toString(this.max));
            } else {
                continued = false;
            }
            if (this.multiple != 1L) {
                if (continued) {
                    sb.append(" and");
                }
                sb.append(" a multiple of ");
                sb.append(Long.toString(this.multiple));
            }
            if ((actual = this.guessSize(argument)) != null) {
                sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
            }
            return sb.toString();
        }

        @Override
        public int isCompatibleWith(RangeAllowedValues other) {
            if (other instanceof SizeConstraint) {
                SizeConstraint otherRange = (SizeConstraint)other;
                if ((this.exact != -1L || otherRange.exact != -1L) && this.exact != otherRange.exact) {
                    return 1002;
                }
                return otherRange.min > this.max || otherRange.max < this.min ? 1002 : 1001;
            }
            return 1003;
        }
    }

    static class FloatRangeConstraint
    extends RangeAllowedValues {
        final double from;
        final double to;
        final boolean fromInclusive;
        final boolean toInclusive;

        public FloatRangeConstraint(PsiAnnotation annotation) {
            PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
            PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
            PsiAnnotationMemberValue fromInclusiveValue = annotation.findDeclaredAttributeValue("fromInclusive");
            PsiAnnotationMemberValue toInclusiveValue = annotation.findDeclaredAttributeValue("toInclusive");
            this.from = ResourceTypeInspection.getDoubleValue(fromValue, Double.NEGATIVE_INFINITY);
            this.to = ResourceTypeInspection.getDoubleValue(toValue, Double.POSITIVE_INFINITY);
            this.fromInclusive = ResourceTypeInspection.getBooleanValue(fromInclusiveValue, true);
            this.toInclusive = ResourceTypeInspection.getBooleanValue(toInclusiveValue, true);
        }

        @Override
        public int isValid(PsiExpression argument) {
            Number number = this.guessSize(argument);
            if (number != null) {
                double value = number.doubleValue();
                if (!((this.fromInclusive && value >= this.from || !this.fromInclusive && value > this.from) && (this.toInclusive && value <= this.to || !this.toInclusive && value < this.to))) {
                    return 1002;
                }
                return 1001;
            }
            return 1003;
        }

        @Override
        public String describe(PsiExpression argument) {
            StringBuilder sb = new StringBuilder(20);
            if (this.from != Double.NEGATIVE_INFINITY) {
                if (this.to != Double.POSITIVE_INFINITY) {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.from));
                    sb.append(" and ");
                    if (this.toInclusive) {
                        sb.append('\u2264');
                    } else {
                        sb.append('<');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.to));
                } else {
                    sb.append("Value must be ");
                    if (this.fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(this.from));
                }
            } else if (this.to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (this.toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(this.to));
            }
            Number actual = this.guessSize(argument);
            if (actual != null) {
                sb.append(" (was ");
                if (argument instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)argument;
                    sb.append(literal.getText());
                } else {
                    sb.append(Double.toString(actual.doubleValue()));
                }
                sb.append(')');
            }
            return sb.toString();
        }

        @Override
        public int isCompatibleWith(RangeAllowedValues other) {
            if (other instanceof FloatRangeConstraint) {
                FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
                return otherRange.from > this.to || otherRange.to < this.from ? 1002 : 1001;
            }
            if (other instanceof IntRangeConstraint) {
                IntRangeConstraint otherRange = (IntRangeConstraint)other;
                return (double)otherRange.from > this.to || (double)otherRange.to < this.from ? 1002 : 1001;
            }
            return 1003;
        }
    }

    static class IntRangeConstraint
    extends RangeAllowedValues {
        final long from;
        final long to;

        public IntRangeConstraint(PsiAnnotation annotation) {
            PsiAnnotationMemberValue fromValue = annotation.findDeclaredAttributeValue("from");
            PsiAnnotationMemberValue toValue = annotation.findDeclaredAttributeValue("to");
            this.from = ResourceTypeInspection.getLongValue((PsiElement)fromValue, Long.MIN_VALUE);
            this.to = ResourceTypeInspection.getLongValue((PsiElement)toValue, Long.MAX_VALUE);
        }

        @Override
        public int isValid(PsiExpression argument) {
            Number literalValue = this.guessSize(argument);
            if (literalValue != null) {
                long value = literalValue.longValue();
                return value >= this.from && value <= this.to ? 1001 : 1002;
            }
            return 1003;
        }

        @Override
        public String describe(PsiExpression argument) {
            StringBuilder sb = new StringBuilder(20);
            if (this.to == Long.MAX_VALUE) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(this.from));
            } else if (this.from == Long.MIN_VALUE) {
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(this.to));
            } else {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(this.from));
                sb.append(" and \u2264 ");
                sb.append(Long.toString(this.to));
            }
            Number actual = this.guessSize(argument);
            if (actual != null) {
                sb.append(" (was ").append(Integer.toString(actual.intValue())).append(')');
            }
            return sb.toString();
        }

        @Override
        public int isCompatibleWith(RangeAllowedValues other) {
            if (other instanceof IntRangeConstraint) {
                IntRangeConstraint otherRange = (IntRangeConstraint)other;
                return otherRange.from > this.to || otherRange.to < this.from ? 1002 : 1001;
            }
            if (other instanceof FloatRangeConstraint) {
                FloatRangeConstraint otherRange = (FloatRangeConstraint)other;
                return otherRange.from > (double)this.to || otherRange.to < (double)this.from ? 1002 : 1001;
            }
            return 1003;
        }
    }

    static class RangeAllowedValues
    extends Constraints {
        RangeAllowedValues() {
        }

        public String describe(PsiExpression argument) {
            assert (false);
            return "";
        }

        public int isValid(PsiExpression argument) {
            return 1003;
        }

        protected Number guessSize(PsiExpression argument) {
            Number number;
            PsiExpression operand;
            PsiPrefixExpression prefix;
            if (argument instanceof PsiLiteral) {
                PsiLiteral literal = (PsiLiteral)argument;
                Object v = literal.getValue();
                if (v instanceof Number) {
                    return (Number)v;
                }
            } else if (argument instanceof PsiBinaryExpression) {
                Object v = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)argument, (boolean)false);
                if (v instanceof Number) {
                    return (Number)v;
                }
            } else if (argument instanceof PsiReferenceExpression) {
                PsiLocalVariable variable;
                PsiExpression initializer;
                PsiReferenceExpression ref = (PsiReferenceExpression)argument;
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiField) {
                    PsiField field = (PsiField)resolved;
                    PsiExpression initializer2 = field.getInitializer();
                    if (initializer2 != null) {
                        return this.guessSize(initializer2);
                    }
                } else if (resolved instanceof PsiLocalVariable && (initializer = (variable = (PsiLocalVariable)resolved).getInitializer()) != null) {
                    return this.guessSize(initializer);
                }
            } else if (argument instanceof PsiPrefixExpression && (prefix = (PsiPrefixExpression)argument).getOperationTokenType() == JavaTokenType.MINUS && (operand = prefix.getOperand()) != null && (number = this.guessSize(operand)) != null) {
                if (number instanceof Long) {
                    return -number.longValue();
                }
                if (number instanceof Integer) {
                    return -number.intValue();
                }
                if (number instanceof Double) {
                    return -number.doubleValue();
                }
                if (number instanceof Float) {
                    return Float.valueOf(-number.floatValue());
                }
                if (number instanceof Short) {
                    return (int)(-number.shortValue());
                }
                if (number instanceof Byte) {
                    return (int)(-number.byteValue());
                }
            }
            return null;
        }

        public int isCompatibleWith(RangeAllowedValues other) {
            return 1003;
        }
    }

    static class ResourceTypeAllowedValues
    extends Constraints {
        final List<ResourceType> types;

        public ResourceTypeAllowedValues(List<ResourceType> types) {
            this.types = types;
        }

        public boolean isTypeAllowed(String typeName) {
            for (ResourceType type : this.types) {
                if (!type.getName().equals(typeName) && (type != ResourceType.DRAWABLE || !ResourceType.COLOR.getName().equals(typeName) && !ResourceType.MIPMAP.getName().equals(typeName))) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleWith(ResourceTypeAllowedValues other) {
            if (other.types.isEmpty() && this.types.isEmpty()) {
                return true;
            }
            for (ResourceType t1 : other.types) {
                for (ResourceType t2 : this.types) {
                    if (t1 != t2) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class AllowedValues
    extends Constraints {
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;

        private AllowedValues(PsiAnnotationMemberValue[] values, boolean canBeOred) {
            this.values = values;
            this.canBeOred = canBeOred;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value : v1) {
                for (PsiAnnotationMemberValue value2 : v2) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)value2, value.getManager())) continue;
                    v2.remove(value2);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        @Override
        public boolean isSubsetOf(Constraints other, PsiManager manager) {
            if (!(other instanceof AllowedValues)) {
                return false;
            }
            AllowedValues o = (AllowedValues)other;
            for (PsiAnnotationMemberValue value : this.values) {
                boolean found = false;
                for (PsiAnnotationMemberValue otherValue : o.values) {
                    if (!ResourceTypeInspection.same((PsiElement)value, (PsiElement)otherValue, manager)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }

    static class Constraints {
        public Constraints next;

        Constraints() {
        }

        public boolean isSubsetOf(Constraints other, PsiManager manager) {
            return false;
        }
    }

    private static class ReplaceCallFix
    implements LocalQuickFix {
        private final PsiMethodCallExpression myMethodCall;
        private final String mySuggest;

        public ReplaceCallFix(PsiMethodCallExpression methodCall, String suggest) {
            this.myMethodCall = methodCall;
            this.mySuggest = suggest;
        }

        public String getName() {
            return String.format("Call %1$s instead", this.getMethodName());
        }

        public String getFamilyName() {
            return "Replace Calls";
        }

        private String getMethodName() {
            assert (this.mySuggest.startsWith("#"));
            int start = 1;
            int parameters = this.mySuggest.indexOf(40, start);
            if (parameters == -1) {
                parameters = this.mySuggest.length();
            }
            return this.mySuggest.substring(start, parameters).trim();
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            TextRange range;
            PsiReferenceExpression methodExpression;
            PsiElement referenceNameElement;
            if (!this.myMethodCall.isValid()) {
                return;
            }
            String name = this.getMethodName();
            PsiFile file = this.myMethodCall.getContainingFile();
            if (file == null || !FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document != null && (referenceNameElement = (methodExpression = this.myMethodCall.getMethodExpression()).getReferenceNameElement()) != null && (range = referenceNameElement.getTextRange()) != null) {
                if (name.startsWith("enforce") && methodExpression.getReferenceName() != null && methodExpression.getReferenceName().startsWith("check")) {
                    PsiExpressionList argumentList = this.myMethodCall.getArgumentList();
                    int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
                    document.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                }
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
            }
        }
    }

    private static class AddCheckPermissionFix
    implements LocalQuickFix {
        private final AndroidFacet myFacet;
        private final PermissionRequirement myRequirement;
        private final Set<String> myRevocablePermissions;
        private final PsiCall myCall;

        public AddCheckPermissionFix(AndroidFacet facet, PermissionRequirement requirement, PsiCall call, Set<String> revocablePermissions) {
            this.myFacet = facet;
            this.myRequirement = requirement;
            this.myCall = call;
            this.myRevocablePermissions = revocablePermissions;
        }

        public String getName() {
            return "Add Permission Check";
        }

        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            BinaryOperator operator;
            HashMap permissionNames;
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myCall, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass manifest = facade.findClass("android.Manifest.permission", GlobalSearchScope.moduleWithLibrariesScope((Module)this.myFacet.getModule()));
            if (manifest != null) {
                PsiField[] fields = manifest.getFields();
                permissionNames = Maps.newHashMapWithExpectedSize((int)fields.length);
                for (PsiField field : fields) {
                    Object value;
                    PsiExpression initializer = field.getInitializer();
                    if (!(initializer instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)initializer).getValue()) instanceof String)) continue;
                    permissionNames.put((String)value, field);
                }
            } else {
                permissionNames = Collections.emptyMap();
            }
            if ((operator = this.myRequirement.getOperator()) == null || operator == BinaryOperator.LOGICAL_AND) {
                operator = BinaryOperator.LOGICAL_OR;
            } else if (operator == BinaryOperator.LOGICAL_OR) {
                operator = BinaryOperator.LOGICAL_AND;
            }
            PsiElementFactory factory = facade.getElementFactory();
            StringBuilder sb = new StringBuilder(200);
            sb.append("if (");
            boolean first = true;
            for (String permission : this.myRevocablePermissions) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                    sb.append(operator.getSymbol());
                    sb.append(' ');
                }
                sb.append("checkSelfPermission(");
                PsiField field = (PsiField)permissionNames.get(permission);
                if (field != null && field.getContainingClass() != null) {
                    sb.append(field.getContainingClass().getQualifiedName()).append('.').append(field.getName());
                } else {
                    sb.append('\"').append(permission).append('\"');
                }
                sb.append(") != android.content.pm.PackageManager.PERMISSION_GRANTED");
            }
            sb.append(") {\n");
            sb.append(" // TODO: Consider calling\n //    public void requestPermissions(@NonNull String[] permissions, int requestCode)\n // here to request the missing permissions, and then overriding\n //   public void onRequestPermissionsResult(int requestCode, String[] permissions,\n //                                          int[] grantResults)\n // to handle the case where the user grants the permission. See the documentation\n // for Activity#requestPermissions for more details.\n");
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myCall, PsiMethod.class, (boolean)true);
            if (method != null && !PsiType.VOID.equals((Object)method.getReturnType())) {
                sb.append("return TODO;\n");
            } else {
                sb.append("return;\n");
            }
            sb.append("}\n");
            String code = sb.toString();
            PsiStatement check = factory.createStatementFromText(code, (PsiElement)this.myCall);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)check);
            parent.addBefore((PsiElement)check, (PsiElement)statement);
            CodeStyleManager.getInstance((Project)project).reformatRange(parent, check.getTextOffset(), statement.getTextOffset() + statement.getTextLength());
        }
    }

    private static class AddPermissionFix
    implements LocalQuickFix {
        private final AndroidFacet myFacet;
        private final String myPermissionName;

        public AddPermissionFix(AndroidFacet facet, String permissionName) {
            this.myFacet = facet;
            this.myPermissionName = permissionName;
        }

        public String getName() {
            return String.format("Add Permission %1$s", this.myPermissionName.substring(this.myPermissionName.lastIndexOf(46) + 1));
        }

        public String getFamilyName() {
            return "Add Permissions";
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
            if (manifestFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myFacet.getModule().getProject(), (VirtualFile[])new VirtualFile[]{manifestFile})) {
                return;
            }
            Manifest manifest = AndroidUtils.loadDomElement(this.myFacet.getModule(), manifestFile, Manifest.class);
            if (manifest == null) {
                return;
            }
            XmlTag manifestTag = manifest.getXmlTag();
            if (manifestTag == null) {
                return;
            }
            XmlTag permissionTag = manifestTag.createChildTag("uses-permission", "", null, false);
            if (permissionTag != null) {
                XmlTag before = null;
                for (XmlTag tag : manifestTag.getSubTags()) {
                    String name;
                    String tagName = tag.getName();
                    if (tagName.equals("application")) {
                        before = tag;
                        break;
                    }
                    if (!tagName.equals("uses-permission") && !tagName.equals("uses-permission-sdk-23") && !tagName.equals("uses-permission-sdk-m") || (name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) == null || name.compareTo(this.myPermissionName) <= 0) continue;
                    before = tag;
                    break;
                }
                permissionTag = before == null ? manifestTag.addSubTag(permissionTag, false) : (XmlTag)manifestTag.addBefore((PsiElement)permissionTag, before);
                permissionTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myPermissionName);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)permissionTag);
                DeclaredPermissionsLookup.getInstance(project).reset();
                FileDocumentManager.getInstance().saveAllDocuments();
                PsiFile containingFile = permissionTag.getContainingFile();
                if (containingFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            }
        }
    }
}

