/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.inspections.lint.AndroidLintGlobalInspectionContext;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.android.inspections.lint.SuppressLintIntentionAction;
import org.jetbrains.android.util.AndroidBundle;

public abstract class AndroidLintInspectionBase
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AndroidLintInspectionBase");
    private static final Object ISSUE_MAP_LOCK = new Object();
    private static volatile Map<Issue, String> ourIssue2InspectionShortName;
    protected final Issue myIssue;
    private final String[] myGroupPath;
    private final String myDisplayName;

    protected AndroidLintInspectionBase(String displayName, Issue issue) {
        this.myIssue = issue;
        Category category = issue.getCategory();
        String[] categoryNames = category != null ? AndroidLintInspectionBase.computeAllNames(category) : ArrayUtil.EMPTY_STRING_ARRAY;
        this.myGroupPath = ArrayUtil.mergeArrays((String[])new String[]{AndroidBundle.message("android.inspections.group.name", new Object[0]), AndroidBundle.message("android.lint.inspections.subgroup.name", new Object[0])}, (String[])categoryNames);
        this.myDisplayName = displayName;
    }

    public AndroidLintQuickFix[] getQuickFixes(PsiElement startElement, PsiElement endElement, String message) {
        return this.getQuickFixes(message);
    }

    public AndroidLintQuickFix[] getQuickFixes(String message) {
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    public IntentionAction[] getIntentions(PsiElement startElement, PsiElement endElement) {
        return IntentionAction.EMPTY_ARRAY;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    private LocalQuickFix[] getLocalQuickFixes(PsiElement startElement, PsiElement endElement, String message) {
        AndroidLintQuickFix[] fixes = this.getQuickFixes(startElement, endElement, message);
        LocalQuickFix[] result = new LocalQuickFix[fixes.length];
        for (int i = 0; i < fixes.length; ++i) {
            if (!fixes[i].isApplicable(startElement, endElement, AndroidQuickfixContexts.BatchContext.TYPE)) continue;
            result[i] = new MyLocalQuickFix(fixes[i]);
        }
        return result;
    }

    public void runInspection(AnalysisScope scope, final InspectionManager manager, final GlobalInspectionContext globalContext, final ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        AndroidLintGlobalInspectionContext androidLintContext = (AndroidLintGlobalInspectionContext)globalContext.getExtension(AndroidLintGlobalInspectionContext.ID);
        if (androidLintContext == null) {
            return;
        }
        Map<Issue, Map<File, List<ProblemData>>> problemMap = androidLintContext.getResults();
        if (problemMap == null) {
            return;
        }
        Map<File, List<ProblemData>> file2ProblemList = problemMap.get(this.myIssue);
        if (file2ProblemList == null) {
            return;
        }
        for (final Map.Entry<File, List<ProblemData>> entry : file2ProblemList.entrySet()) {
            File file = entry.getKey();
            final VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (vFile == null) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ProblemDescriptor[] descriptors;
                    PsiDirectory psiDirectory;
                    PsiManager psiManager = PsiManager.getInstance((Project)globalContext.getProject());
                    PsiFile psiFile = psiManager.findFile(vFile);
                    if (psiFile != null) {
                        ProblemDescriptor[] descriptors2 = AndroidLintInspectionBase.this.computeProblemDescriptors((PsiElement)psiFile, manager, (List)entry.getValue());
                        if (descriptors2.length > 0) {
                            problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiFile), (CommonProblemDescriptor[])descriptors2);
                        }
                    } else if (vFile.isDirectory() && (psiDirectory = psiManager.findDirectory(vFile)) != null && (descriptors = AndroidLintInspectionBase.this.computeProblemDescriptors((PsiElement)psiDirectory, manager, (List)entry.getValue())).length > 0) {
                        problemDescriptionsProcessor.addProblemElement((RefEntity)globalContext.getRefManager().getReference((PsiElement)psiDirectory), (CommonProblemDescriptor[])descriptors);
                    }
                }
            });
        }
    }

    private ProblemDescriptor[] computeProblemDescriptors(PsiElement psiFile, InspectionManager manager, List<ProblemData> problems) {
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (ProblemData problemData : problems) {
            String originalMessage = problemData.getMessage();
            String formattedMessage = "<html>" + TextFormat.RAW.convertTo(originalMessage, TextFormat.HTML) + "</html>";
            TextRange range = problemData.getTextRange();
            if (range.getStartOffset() == range.getEndOffset()) {
                if (psiFile instanceof PsiBinaryFile || psiFile instanceof PsiDirectory) {
                    LocalQuickFix[] fixes = this.getLocalQuickFixes(psiFile, psiFile, originalMessage);
                    result.add(new NonTextFileProblemDescriptor((PsiFileSystemItem)psiFile, formattedMessage, fixes));
                    continue;
                }
                if (this.isSuppressedFor(psiFile)) continue;
                result.add(manager.createProblemDescriptor(psiFile, formattedMessage, false, this.getLocalQuickFixes(psiFile, psiFile, originalMessage), ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                continue;
            }
            PsiElement startElement = psiFile.findElementAt(range.getStartOffset());
            PsiElement endElement = psiFile.findElementAt(range.getEndOffset() - 1);
            if (startElement == null || endElement == null || this.isSuppressedFor(startElement)) continue;
            result.add(manager.createProblemDescriptor(startElement, endElement, formattedMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, this.getLocalQuickFixes(startElement, endElement, originalMessage)));
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    public SuppressQuickFix[] getBatchSuppressActions(PsiElement element) {
        SuppressLintQuickFix suppressLintQuickFix = new SuppressLintQuickFix(this.myIssue);
        return new SuppressQuickFix[]{suppressLintQuickFix};
    }

    public static void invalidateInspectionShortName2IssueMap() {
        ourIssue2InspectionShortName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInspectionShortNameByIssue(Project project, Issue issue) {
        Object object = ISSUE_MAP_LOCK;
        synchronized (object) {
            if (ourIssue2InspectionShortName == null) {
                ourIssue2InspectionShortName = new HashMap();
                InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
                for (InspectionToolWrapper e : profile.getInspectionTools(null)) {
                    InspectionProfileEntry entry;
                    String shortName = e.getShortName();
                    if (!shortName.startsWith("AndroidLint") || !((entry = e.getTool()) instanceof AndroidLintInspectionBase)) continue;
                    Issue s = ((AndroidLintInspectionBase)entry).getIssue();
                    ourIssue2InspectionShortName.put(s, shortName);
                }
            }
            return ourIssue2InspectionShortName.get(issue);
        }
    }

    private static String[] computeAllNames(Category category) {
        ArrayList<String> result = new ArrayList<String>();
        for (Category c = category; c != null; c = c.getParent()) {
            String name = c.getName();
            if (name == null) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            result.add(name);
        }
        return (String[])ArrayUtil.reverseArray((Object[])ArrayUtil.toStringArray(result));
    }

    public String getGroupDisplayName() {
        return AndroidBundle.message("android.lint.inspections.group.name", new Object[0]);
    }

    public String[] getGroupPath() {
        return this.myGroupPath;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getStaticDescription() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html><body>");
        sb.append(this.myIssue.getBriefDescription(TextFormat.HTML));
        sb.append("<br><br>");
        sb.append(this.myIssue.getExplanation(TextFormat.HTML));
        List urls = this.myIssue.getMoreInfo();
        if (!urls.isEmpty()) {
            boolean separated = false;
            for (String url : urls) {
                if (this.myIssue.getExplanation(TextFormat.RAW).contains(url)) continue;
                if (!separated) {
                    sb.append("<br><br>");
                    separated = true;
                } else {
                    sb.append("<br>");
                }
                sb.append("<a href=\"");
                sb.append(url);
                sb.append("\">");
                sb.append(url);
                sb.append("</a>");
            }
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isEnabledByDefault() {
        return this.myIssue.isEnabledByDefault();
    }

    public String getShortName() {
        return InspectionProfileEntry.getShortName((String)((Object)((Object)this)).getClass().getSimpleName());
    }

    public HighlightDisplayLevel getDefaultLevel() {
        Severity defaultSeverity = this.myIssue.getDefaultSeverity();
        if (defaultSeverity == null) {
            return HighlightDisplayLevel.WARNING;
        }
        HighlightDisplayLevel displayLevel = AndroidLintInspectionBase.toHighlightDisplayLevel(defaultSeverity);
        return displayLevel != null ? displayLevel : HighlightDisplayLevel.WARNING;
    }

    static HighlightDisplayLevel toHighlightDisplayLevel(Severity severity) {
        switch (severity) {
            case ERROR: {
                return HighlightDisplayLevel.ERROR;
            }
            case FATAL: {
                return HighlightDisplayLevel.ERROR;
            }
            case WARNING: {
                return HighlightDisplayLevel.WARNING;
            }
            case INFORMATIONAL: {
                return HighlightDisplayLevel.WEAK_WARNING;
            }
            case IGNORE: {
                return null;
            }
        }
        LOG.error("Unknown severity " + severity);
        return null;
    }

    private static boolean isSingleFileScope(EnumSet<Scope> scopes) {
        if (scopes.size() != 1) {
            return false;
        }
        Scope scope = (Scope)scopes.iterator().next();
        return scope == Scope.JAVA_FILE || scope == Scope.RESOURCE_FILE || scope == Scope.MANIFEST || scope == Scope.PROGUARD_FILE || scope == Scope.OTHER;
    }

    public boolean worksInBatchModeOnly() {
        Implementation implementation = this.myIssue.getImplementation();
        if (AndroidLintInspectionBase.isSingleFileScope(implementation.getScope())) {
            return false;
        }
        for (EnumSet scopes : implementation.getAnalysisScopes()) {
            if (!AndroidLintInspectionBase.isSingleFileScope(scopes)) continue;
            return false;
        }
        return true;
    }

    public Issue getIssue() {
        return this.myIssue;
    }

    private static class NonTextFileProblemDescriptor
    implements ProblemDescriptor {
        private final PsiFileSystemItem myFile;
        private final String myMessage;
        private final LocalQuickFix[] myFixes;
        private ProblemGroup myGroup;

        public NonTextFileProblemDescriptor(PsiFileSystemItem file, String message, LocalQuickFix[] fixes) {
            this.myFile = file;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        public PsiElement getPsiElement() {
            return this.myFile;
        }

        public PsiElement getStartElement() {
            return this.myFile;
        }

        public PsiElement getEndElement() {
            return this.myFile;
        }

        public TextRange getTextRangeInElement() {
            return new TextRange(0, 0);
        }

        public int getLineNumber() {
            return 0;
        }

        public ProblemHighlightType getHighlightType() {
            return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }

        public boolean isAfterEndOfLine() {
            return false;
        }

        public void setTextAttributes(TextAttributesKey key) {
        }

        public ProblemGroup getProblemGroup() {
            return this.myGroup;
        }

        public void setProblemGroup(ProblemGroup problemGroup) {
            this.myGroup = problemGroup;
        }

        public boolean showTooltip() {
            return false;
        }

        public String getDescriptionTemplate() {
            return this.myMessage;
        }

        public QuickFix[] getFixes() {
            return this.myFixes;
        }
    }

    static class MyLocalQuickFix
    implements LocalQuickFix {
        private final AndroidLintQuickFix myLintQuickFix;

        MyLocalQuickFix(AndroidLintQuickFix lintQuickFix) {
            this.myLintQuickFix = lintQuickFix;
        }

        public String getName() {
            return this.myLintQuickFix.getName();
        }

        public String getFamilyName() {
            return AndroidBundle.message("android.lint.quickfixes.family", new Object[0]);
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            this.myLintQuickFix.apply(descriptor.getStartElement(), descriptor.getEndElement(), AndroidQuickfixContexts.BatchContext.getInstance());
        }
    }

    private static class SuppressLintQuickFix
    implements SuppressQuickFix {
        private Issue myIssue;

        private SuppressLintQuickFix(Issue issue) {
            this.myIssue = issue;
        }

        public boolean isAvailable(Project project, PsiElement context) {
            return true;
        }

        public String getName() {
            return "Suppress with @SuppressLint (Java) or tools:ignore (XML)";
        }

        public String getFamilyName() {
            return "Suppress";
        }

        public void applyFix(Project project, ProblemDescriptor descriptor) {
            PsiElement myElement = descriptor.getPsiElement();
            PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)myElement, PsiFile.class, (boolean)false);
            if (file != null) {
                new SuppressLintIntentionAction(this.myIssue.getId(), myElement).invoke(project, null, file);
            }
        }
    }
}

