/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NonNls;

public class AndroidLintUtil {
    @NonNls
    static final String ATTR_VALUE_VERTICAL = "vertical";
    @NonNls
    static final String ATTR_VALUE_WRAP_CONTENT = "wrap_content";
    @NonNls
    static final String ATTR_LAYOUT_HEIGHT = "layout_height";
    @NonNls
    static final String ATTR_LAYOUT_WIDTH = "layout_width";
    @NonNls
    static final String ATTR_ORIENTATION = "orientation";

    private AndroidLintUtil() {
    }

    public static Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlighLevelAndInspection(Project project, Issue issue, PsiElement context) {
        String inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue);
        if (inspectionShortName == null) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionShortName);
        if (key == null) {
            return null;
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getInspectionProfile();
        if (!profile.isToolEnabled(key, context)) {
            return null;
        }
        AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
        if (inspection == null) {
            return null;
        }
        HighlightDisplayLevel errorLevel = profile.getErrorLevel(key, context);
        return Pair.create((Object)((Object)inspection), (Object)(errorLevel != null ? errorLevel : HighlightDisplayLevel.WARNING));
    }
}

