/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

class DomPsiConverter {
    private static final NodeList EMPTY = new NodeList(){

        @Override
        public Node item(int i) {
            throw new IllegalArgumentException();
        }

        @Override
        public int getLength() {
            return 0;
        }
    };
    private static final NamedNodeMap EMPTY_ATTRIBUTES = new NamedNodeMap(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public Node getNamedItem(String s) {
            return null;
        }

        @Override
        public Node getNamedItemNS(String s, String s2) throws DOMException {
            return null;
        }

        @Override
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node item(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node setNamedItemNS(Node node) throws DOMException {
            return null;
        }

        @Override
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    };

    private DomPsiConverter() {
    }

    public static Document convert(XmlFile xmlFile) {
        try {
            XmlDocument xmlDocument = xmlFile.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            return DomPsiConverter.convert(xmlDocument);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            String path = xmlFile.getName();
            VirtualFile virtualFile = xmlFile.getVirtualFile();
            if (virtualFile != null) {
                path = virtualFile.getPath();
            }
            throw new RuntimeException("Could not convert file " + path, e);
        }
    }

    private static Document convert(XmlDocument document) {
        return new DomDocument(document);
    }

    public static TextRange getTextRange(Node node) {
        assert (node instanceof DomNode);
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        if (node.getNodeType() == 1) {
            return DomPsiConverter.getTextNameRange(node);
        }
        return element.getTextRange();
    }

    public static TextRange getTextNameRange(Node node) {
        XmlElement nameElement;
        assert (node instanceof DomNode);
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        if (node.getNodeType() == 1 && element instanceof XmlTag) {
            String tag = node.getNodeName();
            int index = element.getText().indexOf(tag);
            if (index != -1) {
                TextRange textRange = element.getTextRange();
                int start = textRange.getStartOffset() + index;
                return new TextRange(start, start + tag.length());
            }
        } else if (node.getNodeType() == 2 && element instanceof XmlAttribute && (nameElement = ((XmlAttribute)element).getNameElement()) != null) {
            return nameElement.getTextRange();
        }
        return element.getTextRange();
    }

    public static TextRange getTextValueRange(Node node) {
        XmlAttributeValue valueElement;
        assert (node instanceof DomNode);
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        TextRange textRange = element.getTextRange();
        if (node.getNodeType() == 2 && element instanceof XmlAttribute && (valueElement = ((XmlAttribute)element).getValueElement()) != null) {
            return valueElement.getValueTextRange();
        }
        return textRange;
    }

    private static class DomAttr
    extends DomNode
    implements Attr {
        private final DomElement myOwner;
        private final XmlAttribute myAttribute;

        private DomAttr(Document document, DomElement owner, XmlAttribute attribute) {
            super(document, null, (XmlElement)attribute);
            this.myOwner = owner;
            this.myAttribute = attribute;
        }

        @Override
        public String getNodeName() {
            return this.getName();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getValue();
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        public String getName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomAttr.this.getName();
                    }
                });
            }
            return this.myAttribute.getName();
        }

        @Override
        public boolean getSpecified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomAttr.this.getValue();
                    }
                });
            }
            String value = this.myAttribute.getValue();
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        public String getLocalName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomAttr.this.getLocalName();
                    }
                });
            }
            return this.myAttribute.getLocalName();
        }

        @Override
        public String getPrefix() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomAttr.this.getPrefix();
                    }
                });
            }
            return this.myAttribute.getNamespacePrefix();
        }

        @Override
        public String getNamespaceURI() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomAttr.this.getNamespaceURI();
                    }
                });
            }
            return this.myAttribute.getNamespace();
        }

        @Override
        public void setValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getOwnerElement() {
            return this.myOwner;
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomComment
    extends DomNode
    implements Comment {
        private final XmlComment myComment;

        private DomComment(Document owner, DomNode parent, XmlComment comment) {
            super(owner, parent, (XmlElement)comment);
            this.myComment = comment;
        }

        @Override
        public String getNodeName() {
            return null;
        }

        @Override
        public String getNodeValue() throws DOMException {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomComment.this.getNodeValue();
                    }
                });
            }
            return this.myComment.getText();
        }

        @Override
        public short getNodeType() {
            return 8;
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.getNodeValue();
        }
    }

    private static class DomText
    extends DomNode
    implements Text {
        private final XmlText myText;

        private DomText(Document owner, DomNode parent, XmlText text) {
            super(owner, parent, (XmlElement)text);
            this.myText = text;
        }

        @Override
        public String getNodeName() {
            return null;
        }

        @Override
        public String getNodeValue() throws DOMException {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomText.this.getNodeValue();
                    }
                });
            }
            return this.myText.getText();
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public Text splitText(int i) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isElementContentWhitespace() {
            String s = this.myText.getText();
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getWholeText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text replaceWholeText(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomElement
    extends DomNode
    implements Element {
        private final XmlTag myTag;
        private NamedNodeMap myAttributes;

        private DomElement(Document owner, DomNode parent, XmlTag tag) {
            super(owner, parent, (XmlElement)tag);
            this.myTag = tag;
        }

        @Override
        public String getNodeName() {
            return this.getTagName();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public NamedNodeMap getAttributes() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (NamedNodeMap)application.runReadAction((Computable)new Computable<NamedNodeMap>(){

                    public NamedNodeMap compute() {
                        return DomElement.this.getAttributes();
                    }
                });
            }
            if (this.myAttributes == null) {
                XmlAttribute[] attributes = this.myTag.getAttributes();
                this.myAttributes = attributes.length == 0 ? EMPTY_ATTRIBUTES : new DomNamedNodeMap(this, attributes);
            }
            return this.myAttributes;
        }

        @Override
        public String getTagName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return DomElement.this.getTagName();
                    }
                });
            }
            return this.myTag.getName();
        }

        @Override
        public String getAttribute(String name) {
            Node node = this.getAttributes().getNamedItem(name);
            if (node != null) {
                return node.getNodeValue();
            }
            return "";
        }

        @Override
        public String getAttributeNS(String namespace, String name) throws DOMException {
            Node node = this.getAttributes().getNamedItemNS(namespace, name);
            if (node != null) {
                return node.getNodeValue();
            }
            return "";
        }

        @Override
        public Attr getAttributeNodeNS(String namespace, String name) throws DOMException {
            Node node = this.getAttributes().getNamedItemNS(namespace, name);
            if (node != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        public Attr getAttributeNode(String name) {
            Node node = this.getAttributes().getNamedItem(name);
            if (node != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        public boolean hasAttribute(String name) {
            return this.getAttributes().getNamedItem(name) != null;
        }

        @Override
        public boolean hasAttributeNS(String namespace, String name) throws DOMException {
            return this.getAttributes().getNamedItemNS(namespace, name) != null;
        }

        @Override
        public NodeList getElementsByTagName(String s) {
            NodeList childNodes = this.getChildNodes();
            if (childNodes == EMPTY) {
                return EMPTY;
            }
            DomNodeList matches = new DomNodeList();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = childNodes.item(i);
                if (!s.equals(node.getNodeName())) continue;
                matches.add((DomNode)node);
            }
            return matches;
        }

        @Override
        public NodeList getElementsByTagNameNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Attr setAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Attr removeAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttributeNS(String s, String s2, String s3) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttribute(String s, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNS(String s, String s2, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNode(Attr attr, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomDocument
    extends DomNode
    implements Document {
        private final XmlDocument myPsiDocument;
        private DomElement myRoot;

        private DomDocument(XmlDocument document) {
            super(null, null, (XmlElement)document);
            this.myPsiDocument = document;
        }

        @Override
        public String getNodeName() {
            return null;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 9;
        }

        @Override
        public NodeList getChildNodes() {
            if (this.myChildren == null) {
                DomNodeList list = new DomNodeList();
                this.myChildren = list;
                DomNode documentElement = (DomNode)((Object)this.getDocumentElement());
                if (documentElement != null) {
                    list.add(documentElement);
                }
            }
            return this.myChildren;
        }

        @Override
        public DocumentType getDoctype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DOMImplementation getImplementation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getDocumentElement() {
            if (this.myRoot == null) {
                XmlTag rootTag = this.myPsiDocument.getRootTag();
                if (rootTag == null) {
                    return null;
                }
                this.myRoot = new DomElement(this, this, rootTag);
            }
            return this.myRoot;
        }

        @Override
        public NodeList getElementsByTagName(String s) {
            Element root = this.getDocumentElement();
            if (root != null) {
                return root.getElementsByTagName(s);
            }
            return EMPTY;
        }

        @Override
        public NodeList getElementsByTagNameNS(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element createElement(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DocumentFragment createDocumentFragment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text createTextNode(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comment createComment(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CDATASection createCDATASection(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessingInstruction createProcessingInstruction(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Attr createAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityReference createEntityReference(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node importNode(Node node, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element createElementNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Attr createAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getElementById(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getInputEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getXmlEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getXmlStandalone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlStandalone(boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getXmlVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlVersion(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getStrictErrorChecking() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStrictErrorChecking(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDocumentURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDocumentURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node adoptNode(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public DOMConfiguration getDomConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalizeDocument() {
        }

        @Override
        public Node renameNode(Node node, String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class DomNode
    implements Node {
        protected final Document myOwner;
        protected final DomNode myParent;
        protected final XmlElement myElement;
        protected NodeList myChildren;
        protected DomNode myNext;
        protected DomNode myPrevious;

        protected DomNode(Document owner, DomNode parent, XmlElement element) {
            this.myOwner = owner;
            this.myParent = parent;
            this.myElement = element;
        }

        @Override
        public Node getParentNode() {
            return this.myParent;
        }

        @Override
        public NodeList getChildNodes() {
            if (this.myChildren == null) {
                PsiElement[] children = this.myElement.getChildren();
                if (children.length > 0) {
                    DomNodeList list = new DomNodeList();
                    this.myChildren = list;
                    assert (this.myOwner != null);
                    for (PsiElement child : children) {
                        if (child instanceof XmlTag) {
                            list.add(new DomElement(this.myOwner, this, (XmlTag)child));
                            continue;
                        }
                        if (child instanceof XmlText) {
                            list.add(new DomText(this.myOwner, this, (XmlText)child));
                            continue;
                        }
                        if (!(child instanceof XmlComment)) continue;
                        list.add(new DomComment(this.myOwner, this, (XmlComment)child));
                    }
                } else {
                    this.myChildren = EMPTY;
                }
            }
            return this.myChildren;
        }

        @Override
        public Node getFirstChild() {
            NodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        public Node getLastChild() {
            NodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        public Node getPreviousSibling() {
            return this.myPrevious;
        }

        @Override
        public Node getNextSibling() {
            return this.myNext;
        }

        @Override
        public NamedNodeMap getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Document getOwnerDocument() {
            return this.myOwner;
        }

        @Override
        public void setNodeValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node insertBefore(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node replaceChild(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node removeChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node appendChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasChildNodes() {
            return this.getChildNodes().getLength() > 0;
        }

        @Override
        public Node cloneNode(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String s, String s2) {
            return false;
        }

        @Override
        public String getNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrefix(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public short compareDocumentPosition(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.myElement.getText();
        }

        @Override
        public void setTextContent(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSameNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lookupPrefix(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefaultNamespace(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lookupNamespaceURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEqualNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getFeature(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object setUserData(String s, Object o, UserDataHandler userDataHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getUserData(String s) {
            throw new UnsupportedOperationException();
        }

        public String getData() throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            throw new UnsupportedOperationException();
        }

        public String substringData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void appendData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void insertData(int i, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void deleteData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void replaceData(int i, int i2, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomNamedNodeMap
    implements NamedNodeMap {
        protected final Map<String, DomNode> myMap;
        protected final Map<String, Map<String, DomNode>> myNsMap;
        protected final List<DomNode> mItems;

        private DomNamedNodeMap(DomElement element, XmlAttribute[] attributes) {
            int count = attributes.length;
            int namespaceCount = 0;
            for (XmlAttribute attribute : attributes) {
                if (attribute.getNamespace().isEmpty()) continue;
                ++namespaceCount;
            }
            this.myMap = new HashMap(count - namespaceCount);
            this.myNsMap = new HashMap(namespaceCount);
            this.mItems = new ArrayList<DomNode>(count);
            assert (element.myOwner != null);
            for (XmlAttribute attribute : attributes) {
                DomAttr attr = new DomAttr(element.myOwner, element, attribute);
                this.mItems.add(attr);
                String namespace = attribute.getNamespace();
                if (!namespace.isEmpty()) {
                    HashMap map = this.myNsMap.get(namespace);
                    if (map == null) {
                        map = new HashMap();
                        this.myNsMap.put(namespace, (Map<String, DomNode>)map);
                    }
                    map.put(attribute.getLocalName(), attr);
                    continue;
                }
                this.myMap.put(attribute.getName(), attr);
            }
        }

        @Override
        public Node item(int i) {
            return this.mItems.get(i);
        }

        @Override
        public int getLength() {
            return this.mItems.size();
        }

        @Override
        public Node getNamedItem(String s) {
            return this.myMap.get(s);
        }

        @Override
        public Node getNamedItemNS(String namespace, String name) throws DOMException {
            Map<String, DomNode> map = this.myNsMap.get(namespace);
            if (map != null) {
                return map.get(name);
            }
            return null;
        }

        @Override
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node setNamedItemNS(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomNodeList
    implements NodeList {
        protected final List<DomNode> myChildren = new ArrayList<DomNode>();

        private DomNodeList() {
        }

        @Override
        public Node item(int i) {
            return this.myChildren.get(i);
        }

        @Override
        public int getLength() {
            return this.myChildren.size();
        }

        void add(DomNode node) {
            int size = this.myChildren.size();
            if (size > 0) {
                DomNode last;
                node.myPrevious = last = this.myChildren.get(size - 1);
                last.myNext = node;
            }
            this.myChildren.add(node);
        }
    }
}

