/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.google.common.base.Splitter;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.IntellijLintRequest;
import org.jetbrains.annotations.NonNls;

public class IntellijLintUtils {
    @NonNls
    public static final String SUPPRESS_LINT_FQCN = "android.annotation.SuppressLint";
    @NonNls
    public static final String SUPPRESS_WARNINGS_FQCN = "java.lang.SuppressWarnings";

    private IntellijLintUtils() {
    }

    public static Location getLocation(File file, PsiElement element) {
        PsiClass clz;
        PsiIdentifier nameIdentifier;
        assert (element.getContainingFile().getVirtualFile() == null || FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)element.getContainingFile().getVirtualFile()), (File)file));
        if (element instanceof PsiClass && (nameIdentifier = (clz = (PsiClass)element).getNameIdentifier()) != null) {
            element = nameIdentifier;
        }
        TextRange textRange = element.getTextRange();
        DefaultPosition start = new DefaultPosition(-1, -1, textRange.getStartOffset());
        DefaultPosition end = new DefaultPosition(-1, -1, textRange.getEndOffset());
        return Location.create((File)file, (Position)start, (Position)end);
    }

    public static PsiFile getPsiFile(Context context) {
        VirtualFile file = VfsUtil.findFileByIoFile((File)context.file, (boolean)false);
        if (file == null) {
            return null;
        }
        LintRequest request = context.getDriver().getRequest();
        Project project = ((IntellijLintRequest)request).getProject();
        if (project.isDisposed()) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(file);
    }

    public static boolean isSuppressed(PsiElement element, PsiFile file, Issue issue) {
        while (element != null && element != file) {
            PsiModifierListOwner owner;
            PsiModifierList modifierList;
            if (element instanceof PsiModifierListOwner && (modifierList = (owner = (PsiModifierListOwner)element).getModifierList()) != null) {
                for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                    String fqcn = annotation.getQualifiedName();
                    if (fqcn == null || !fqcn.equals(SUPPRESS_LINT_FQCN) && !fqcn.equals(SUPPRESS_WARNINGS_FQCN)) continue;
                    PsiAnnotationParameterList parameterList = annotation.getParameterList();
                    for (PsiNameValuePair pair : parameterList.getAttributes()) {
                        String text;
                        PsiAnnotationMemberValue v = pair.getValue();
                        if (v instanceof PsiLiteral) {
                            PsiLiteral literal = (PsiLiteral)v;
                            Object value = literal.getValue();
                            if (!(value instanceof String) || !IntellijLintUtils.isSuppressed(issue, (String)value)) continue;
                            return true;
                        }
                        if (v instanceof PsiArrayInitializerMemberValue) {
                            PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                            for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                                PsiLiteral literal;
                                Object value;
                                if (!(mmv instanceof PsiLiteral) || !((value = (literal = (PsiLiteral)mmv).getValue()) instanceof String) || !IntellijLintUtils.isSuppressed(issue, (String)value)) continue;
                                return true;
                            }
                            continue;
                        }
                        if (v == null || (text = v.getText().trim()).isEmpty() || !IntellijLintUtils.isSuppressed(issue, text)) continue;
                        return true;
                    }
                }
            }
            element = element.getParent();
        }
        return false;
    }

    private static boolean isSuppressed(Issue issue, String string) {
        for (String id : Splitter.on((char)',').trimResults().split((CharSequence)string)) {
            if (!id.equals(issue.getId()) && !id.equals("all")) continue;
            return true;
        }
        return false;
    }

    public static String getInternalMethodName(PsiMethod method) {
        if (method.isConstructor()) {
            return "<init>";
        }
        return method.getName();
    }

    public static PsiElement getCallName(PsiCallExpression expression) {
        PsiElement lastChild;
        PsiElement firstChild = expression.getFirstChild();
        if (firstChild != null && (lastChild = firstChild.getLastChild()) instanceof PsiIdentifier) {
            return lastChild;
        }
        return null;
    }

    public static String getInternalName(PsiClass psiClass) {
        PsiClass parent;
        if (psiClass instanceof PsiAnonymousClass && (parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class)) != null) {
            String internalName = IntellijLintUtils.getInternalName(parent);
            if (internalName == null) {
                return null;
            }
            return internalName + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
        }
        String sig = ClassUtil.getJVMClassName((PsiClass)psiClass);
        if (sig == null) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName != null) {
                return ClassContext.getInternalName((String)qualifiedName);
            }
            return null;
        }
        if (sig.indexOf(46) != -1) {
            sig = ClassContext.getInternalName((String)sig);
        }
        return sig;
    }

    public static String getInternalName(PsiClassType psiClassType) {
        PsiClass resolved = psiClassType.resolve();
        if (resolved != null) {
            return IntellijLintUtils.getInternalName(resolved);
        }
        String className = psiClassType.getClassName();
        if (className != null) {
            return ClassContext.getInternalName((String)className);
        }
        return null;
    }

    public static String getInternalDescription(PsiMethod method, boolean includeName, boolean includeReturn) {
        assert (!includeName);
        assert (!includeReturn);
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !IntellijLintUtils.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (IntellijLintUtils.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!IntellijLintUtils.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private static boolean appendJvmTypeName(StringBuilder signature, PsiClass outerClass) {
        String className = IntellijLintUtils.getInternalName(outerClass);
        if (className == null) {
            return false;
        }
        signature.append('L').append(className.replace('.', '/')).append(';');
        return true;
    }

    private static boolean appendJvmSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            IntellijLintUtils.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            if (resolved == null) {
                return false;
            }
            if (!IntellijLintUtils.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JVMNameUtil.getPrimitiveSignature((String)psiType.getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    public static List<File> getResourceDirectories(AndroidFacet facet) {
        AndroidModel androidModel;
        if (facet.requiresAndroidModel() && (androidModel = facet.getAndroidModel()) != null) {
            ArrayList<File> resDirectories = new ArrayList<File>();
            List<SourceProvider> sourceProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider provider : sourceProviders) {
                for (File file : provider.getResDirectories()) {
                    if (!file.isDirectory()) continue;
                    resDirectories.add(file);
                }
            }
            return resDirectories;
        }
        return new ArrayList<File>(facet.getMainSourceProvider().getResDirectories());
    }
}

