/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.DocumentUtil;
import icons.AndroidIcons;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.newProject.AndroidApplicationModifiedSettingsStep;
import org.jetbrains.android.newProject.AndroidLibraryModifiedSettingsStep;
import org.jetbrains.android.newProject.AndroidModuleWizardStep;
import org.jetbrains.android.newProject.AndroidProjectType;
import org.jetbrains.android.newProject.AndroidTestModifiedSettingsStep;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;
import org.jetbrains.android.run.testing.AndroidTestRunConfigurationType;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ExecutionStatus;
import org.jetbrains.android.util.StringBuildingOutputProcessor;
import org.jetbrains.android.util.WaitingStrategies;

public class AndroidModuleBuilder
extends JavaModuleBuilder {
    public static final ProjectType ANDROID_PROJECT_TYPE = new ProjectType("Android");
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.newProject.AndroidModuleBuilder");
    private final AndroidProjectType myProjectType;
    private String myPackageName;
    private String myApplicationName;
    private String myActivityName;
    private Module myTestedModule;
    private TargetSelectionMode myTargetSelectionMode;
    private String myPreferredAvd;

    public AndroidModuleBuilder() {
        this(AndroidProjectType.APPLICATION);
    }

    public AndroidModuleBuilder(AndroidProjectType type) {
        this.myProjectType = type;
    }

    private static String getAntProjectName(String moduleName) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < moduleName.length(); ++i) {
            int c = moduleName.charAt(i);
            if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || Character.isDigit((char)c))) {
                c = 95;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    private static Sdk getAndroidSdkForModule(Module module) {
        return ModuleRootManager.getInstance((Module)module).getSdk();
    }

    private static void copyGeneratedAndroidProject(File tempDir, VirtualFile contentRoot, VirtualFile sourceRoot) {
        File tempSourceRoot;
        File[] children = tempDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if ("src".equals(child.getName())) continue;
                File to = new File(contentRoot.getPath(), child.getName());
                try {
                    if (child.isDirectory()) {
                        FileUtil.copyDir((File)child, (File)to);
                        continue;
                    }
                    FileUtil.copy((File)child, (File)to);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if ((tempSourceRoot = new File(tempDir, "src")).exists()) {
            File to = new File(sourceRoot.getPath());
            try {
                FileUtil.copyDir((File)tempSourceRoot, (File)to);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void configureManifest(AndroidFacet facet, IAndroidTarget target) {
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return;
        }
        XmlTag manifestTag = manifest.getXmlTag();
        if (manifestTag == null) {
            return;
        }
        PsiFile manifestFile = manifestTag.getContainingFile();
        if (manifestFile == null) {
            return;
        }
        VirtualFile vManifestFile = manifestFile.getVirtualFile();
        if (vManifestFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)manifestFile.getProject(), (VirtualFile[])new VirtualFile[]{vManifestFile})) {
            return;
        }
        XmlTag usesSdkTag = manifestTag.createChildTag("uses-sdk", "", null, false);
        if (usesSdkTag != null) {
            usesSdkTag = manifestTag.addSubTag(usesSdkTag, true);
            usesSdkTag.setAttribute("minSdkVersion", "http://schemas.android.com/apk/res/android", target.getVersion().getApiString());
        }
        CodeStyleManager.getInstance((Project)manifestFile.getProject()).reformat((PsiElement)manifestFile);
    }

    private static void createManifestFileAndAntFiles(Project project, VirtualFile contentRoot, Module module) {
        VirtualFile existingManifestFile = contentRoot.findChild("AndroidManifest.xml");
        if (existingManifestFile != null) {
            return;
        }
        try {
            AndroidFileTemplateProvider.createFromTemplate(project, contentRoot, "AndroidManifest.xml", "AndroidManifest.xml");
            Sdk sdk = AndroidModuleBuilder.getAndroidSdkForModule(module);
            if (sdk == null) {
                return;
            }
            AndroidPlatform platform = AndroidPlatform.parse(sdk);
            if (platform == null) {
                Messages.showErrorDialog((Project)project, (String)"Cannot parse Android SDK: 'project.properties' won't be generated", (String)CommonBundle.getErrorTitle());
                return;
            }
            Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
            properties.setProperty("TARGET", platform.getTarget().hashString());
            AndroidFileTemplateProvider.createFromTemplate(project, contentRoot, "default.properties", "project.properties", properties);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static void addTestRunConfiguration(AndroidFacet facet, TargetSelectionMode mode, String preferredAvd) {
        Project project = facet.getModule().getProject();
        RunManager runManager = RunManager.getInstance((Project)project);
        Module module = facet.getModule();
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(module.getName(), AndroidTestRunConfigurationType.getInstance().getFactory());
        AndroidTestRunConfiguration configuration = (AndroidTestRunConfiguration)settings.getConfiguration();
        configuration.setModule(module);
        configuration.setTargetSelectionMode(mode);
        if (preferredAvd != null) {
            configuration.PREFERRED_AVD = preferredAvd;
        }
        runManager.addConfiguration(settings, false);
        runManager.setSelectedConfiguration(settings);
    }

    private static VirtualFile findSourceRoot(ModifiableRootModel model) {
        VirtualFile genSourceRoot = AndroidRootUtil.getStandardGenDir(model.getModule());
        for (VirtualFile root : model.getSourceRoots()) {
            if (Comparing.equal((Object)root, (Object)genSourceRoot)) continue;
            return root;
        }
        return null;
    }

    private static PsiDirectory createPackageIfPossible(final PsiDirectory sourceDir, String packageName) {
        if (sourceDir != null) {
            final String[] ids = packageName.split("\\.");
            return (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    PsiDirectory dir = sourceDir;
                    for (String id : ids) {
                        PsiDirectory child = dir.findSubdirectory(id);
                        dir = child == null ? dir.createSubdirectory(id) : child;
                    }
                    return dir;
                }
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFileFromResource(Project project, VirtualFile drawableDir, String name, String resourceFilePath) throws IOException {
        if (drawableDir.findChild(name) != null) {
            return;
        }
        VirtualFile resFile = drawableDir.createChildData((Object)project, name);
        InputStream stream = AndroidModuleBuilder.class.getResourceAsStream(resourceFilePath);
        try {
            byte[] bytes = FileUtil.adaptiveLoadBytes((InputStream)stream);
            resFile.setBinaryContent(bytes);
        }
        finally {
            stream.close();
        }
    }

    private static Pair<String, Boolean> runAndroidTool(GeneralCommandLine commandLine) {
        String result;
        StringBuildingOutputProcessor processor = new StringBuildingOutputProcessor();
        boolean success = false;
        try {
            success = AndroidUtils.executeCommand(commandLine, processor, WaitingStrategies.WaitForever.getInstance()) == ExecutionStatus.SUCCESS;
            result = processor.getMessage();
        }
        catch (ExecutionException e) {
            result = e.getMessage();
        }
        if (result != null) {
            LOG.debug(result);
        }
        return Pair.create((Object)result, (Object)success);
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        VirtualFile[] files;
        super.setupRootModel(rootModel);
        LanguageLevelModuleExtension moduleExt = (LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class);
        if (moduleExt != null) {
            LanguageLevelProjectExtension projectExt;
            LanguageLevel languageLevel = moduleExt.getLanguageLevel();
            if (languageLevel == null && (projectExt = LanguageLevelProjectExtension.getInstance((Project)rootModel.getProject())) != null) {
                languageLevel = projectExt.getLanguageLevel();
            }
            if (languageLevel == LanguageLevel.JDK_1_3) {
                moduleExt.setLanguageLevel(LanguageLevel.JDK_1_5);
            }
        }
        if ((files = rootModel.getContentRoots()).length > 0) {
            final VirtualFile contentRoot = files[0];
            final AndroidFacet facet = AndroidUtils.addAndroidFacet(rootModel.getModule(), contentRoot, this.myProjectType == AndroidProjectType.LIBRARY);
            if (this.myProjectType == null) {
                ImportDependenciesUtil.importDependencies(rootModel.getModule(), true);
                return;
            }
            Project project = rootModel.getProject();
            ProjectTypeService.setProjectType((Project)project, (ProjectType)new ProjectType("Android"));
            final VirtualFile sourceRoot = AndroidModuleBuilder.findSourceRoot(rootModel);
            if (this.myProjectType == AndroidProjectType.TEST) {
                assert (this.myTestedModule != null);
                facet.getProperties().PACK_TEST_CODE = true;
                ModuleOrderEntry entry = rootModel.addModuleOrderEntry(this.myTestedModule);
                entry.setScope(DependencyScope.PROVIDED);
            }
            facet.getProperties().UPDATE_PROPERTY_FILES = Boolean.TRUE.toString();
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                public void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AndroidModuleBuilder.this.createProject(contentRoot, sourceRoot, facet);
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    private void createProject(VirtualFile contentRoot, VirtualFile sourceRoot, AndroidFacet facet) {
        if (sourceRoot == null) {
            try {
                sourceRoot = contentRoot.createChildDirectory((Object)this, "src");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myProjectType == AndroidProjectType.APPLICATION) {
            this.createDirectoryStructure(contentRoot, sourceRoot, facet);
        } else {
            this.createProjectByAndroidTool(contentRoot, sourceRoot, facet);
        }
    }

    private void createDirectoryStructure(VirtualFile contentRoot, VirtualFile sourceRoot, AndroidFacet facet) {
        if (this.isHelloAndroid() && this.createProjectByAndroidTool(contentRoot, sourceRoot, facet)) {
            return;
        }
        Project project = facet.getModule().getProject();
        AndroidModuleBuilder.createManifestFileAndAntFiles(project, contentRoot, facet.getModule());
        this.createResourcesAndLibs(project, contentRoot);
        PsiDirectory sourceDir = sourceRoot != null ? PsiManager.getInstance((Project)project).findDirectory(sourceRoot) : null;
        this.createActivityAndSetupManifest(facet, sourceDir);
        if (this.myTargetSelectionMode != null) {
            this.addRunConfiguration(facet, this.myTargetSelectionMode, this.myPreferredAvd);
        }
    }

    private boolean createProjectByAndroidTool(final VirtualFile contentRoot, final VirtualFile sourceRoot, final AndroidFacet facet) {
        File tempContentRoot;
        final Module module = facet.getModule();
        Sdk sdk = AndroidModuleBuilder.getAndroidSdkForModule(module);
        if (sdk == null) {
            return true;
        }
        AndroidPlatform platform = AndroidPlatform.parse(sdk);
        if (platform == null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Messages.showErrorDialog((Project)module.getProject(), (String)"Cannot parse Android SDK", (String)CommonBundle.getErrorTitle());
            }
            return true;
        }
        final IAndroidTarget target = platform.getTarget();
        String androidToolPath = platform.getSdkData().getLocation() + File.separator + AndroidCommonUtils.toolPath((String)SdkConstants.androidCmdName());
        if (!new File(androidToolPath).exists()) {
            return false;
        }
        final GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(FileUtil.toSystemDependentName((String)androidToolPath));
        commandLine.addParameter("create");
        switch (this.myProjectType) {
            case APPLICATION: {
                commandLine.addParameter("project");
                break;
            }
            case LIBRARY: {
                commandLine.addParameter("lib-project");
                break;
            }
            case TEST: {
                commandLine.addParameter("test-project");
            }
        }
        commandLine.addParameters(new String[]{"--name"});
        commandLine.addParameter(AndroidModuleBuilder.getAntProjectName(module.getName()));
        commandLine.addParameters(new String[]{"--path"});
        try {
            tempContentRoot = FileUtil.createTempDirectory((String)"android_temp_content_root", (String)"tmp");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
        String targetDirectoryPath = tempContentRoot.getPath();
        commandLine.addParameter(FileUtil.toSystemDependentName((String)targetDirectoryPath));
        if (this.myProjectType == AndroidProjectType.APPLICATION || this.myProjectType == AndroidProjectType.LIBRARY) {
            String apiLevel = target.hashString();
            commandLine.addParameter("--target");
            commandLine.addParameter(apiLevel);
            commandLine.addParameter("--package");
            commandLine.addParameter(this.myPackageName);
        }
        if (this.myProjectType == AndroidProjectType.APPLICATION) {
            commandLine.addParameter("--activity");
            commandLine.addParameter(this.myActivityName);
        } else if (this.myProjectType == AndroidProjectType.TEST) {
            VirtualFile moduleDir;
            AndroidFacet testedFacet = AndroidFacet.getInstance(this.myTestedModule);
            VirtualFile virtualFile = moduleDir = testedFacet != null ? AndroidRootUtil.getMainContentRoot(testedFacet) : null;
            if (moduleDir == null) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    Messages.showErrorDialog((Project)module.getProject(), (String)AndroidBundle.message("android.wizard.cannot.find.main.content.root.error", module.getName()), (String)CommonBundle.getErrorTitle());
                }
                return true;
            }
            commandLine.addParameter("--main");
            commandLine.addParameter(FileUtil.toSystemDependentName((String)moduleDir.getPath()));
        }
        final File finalTempContentRoot = tempContentRoot;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean androidToolSuccess;
                String androidToolOutput;
                final Project project = module.getProject();
                try {
                    Pair pair = AndroidModuleBuilder.runAndroidTool(commandLine);
                    androidToolOutput = (String)pair.getFirst();
                    androidToolSuccess = (Boolean)pair.getSecond();
                    AndroidModuleBuilder.copyGeneratedAndroidProject(finalTempContentRoot, contentRoot, sourceRoot);
                }
                finally {
                    FileUtil.delete((File)finalTempContentRoot);
                }
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        FileDocumentManager.getInstance().saveAllDocuments();
                    }
                });
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{contentRoot});
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed() || module.isDisposed()) {
                            return;
                        }
                        final boolean manifestGenerated = contentRoot.findChild("AndroidManifest.xml") != null;
                        String projectNotGeneratedError = "The project wasn't generated by 'android' tool.";
                        if (!(androidToolOutput == null || androidToolOutput.length() <= 0 || manifestGenerated && androidToolSuccess && !androidToolOutput.trim().toLowerCase().startsWith("error:"))) {
                            final ConsoleViewContentType contentType = androidToolSuccess ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT;
                            AndroidUtils.activateConsoleToolWindow(project, new Runnable(){

                                @Override
                                public void run() {
                                    if (!manifestGenerated) {
                                        AndroidUtils.printMessageToConsole(project, "The project wasn't generated by 'android' tool.", ConsoleViewContentType.ERROR_OUTPUT);
                                    }
                                    AndroidUtils.printMessageToConsole(project, androidToolOutput, contentType);
                                }
                            });
                        } else if (!manifestGenerated) {
                            AndroidUtils.activateConsoleToolWindow(project, new Runnable(){

                                @Override
                                public void run() {
                                    AndroidUtils.printMessageToConsole(project, "The project wasn't generated by 'android' tool.", ConsoleViewContentType.ERROR_OUTPUT);
                                }
                            });
                        }
                        if (!manifestGenerated) {
                            return;
                        }
                        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                block6: {
                                    try {
                                        if (project.isDisposed()) {
                                            return;
                                        }
                                        if (AndroidModuleBuilder.this.myProjectType == AndroidProjectType.APPLICATION) {
                                            AndroidModuleBuilder.this.assignApplicationName(facet);
                                            AndroidModuleBuilder.configureManifest(facet, target);
                                            AndroidUtils.createChildDirectoryIfNotExist(project, contentRoot, "assets");
                                            AndroidUtils.createChildDirectoryIfNotExist(project, contentRoot, "libs");
                                            break block6;
                                        }
                                        if (AndroidModuleBuilder.this.myProjectType != AndroidProjectType.LIBRARY || AndroidModuleBuilder.this.myPackageName == null) break block6;
                                        String[] dirs = AndroidModuleBuilder.this.myPackageName.split("\\.");
                                        VirtualFile file = sourceRoot;
                                        for (String dir : dirs) {
                                            if (file != null && dir.length() != 0) {
                                                VirtualFile childDir = file.findChild(dir);
                                                file = childDir != null ? childDir : file.createChildDirectory((Object)project, dir);
                                                continue;
                                            }
                                            break;
                                        }
                                    }
                                    catch (IOException e) {
                                        LOG.error((Throwable)e);
                                    }
                                }
                            }
                        });
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (project.isDisposed() || facet.getModule().isDisposed()) {
                                    return;
                                }
                                if (AndroidModuleBuilder.this.myTargetSelectionMode != null) {
                                    if (AndroidModuleBuilder.this.myProjectType == AndroidProjectType.APPLICATION) {
                                        AndroidModuleBuilder.this.addRunConfiguration(facet, AndroidModuleBuilder.this.myTargetSelectionMode, AndroidModuleBuilder.this.myPreferredAvd);
                                    } else if (AndroidModuleBuilder.this.myProjectType == AndroidProjectType.TEST) {
                                        AndroidModuleBuilder.addTestRunConfiguration(facet, AndroidModuleBuilder.this.myTargetSelectionMode, AndroidModuleBuilder.this.myPreferredAvd);
                                    }
                                }
                            }
                        });
                        new ReformatCodeProcessor(project, module, false).run();
                    }
                });
            }
        });
        return true;
    }

    private void assignApplicationName(AndroidFacet facet) {
        if (this.myApplicationName == null || this.myApplicationName.length() == 0) {
            return;
        }
        LocalResourceManager manager = facet.getLocalResourceManager();
        ResourceElement appNameResElement = null;
        String appNameResource = "app_name";
        for (ResourceElement resElement : manager.getValueResources(ResourceType.STRING.getName())) {
            if (!"app_name".equals(resElement.getName().getValue())) continue;
            appNameResElement = resElement;
        }
        String appName = this.myApplicationName.replace("\\", "\\\\");
        if (appNameResElement == null) {
            String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
            assert (fileName != null);
            AndroidResourceUtil.createValueResource(facet.getModule(), "app_name", ResourceType.STRING, fileName, Collections.singletonList("values"), appName);
        } else {
            String normalizedAppName = AndroidResourceUtil.normalizeXmlResourceValue(appName);
            appNameResElement.setStringValue(normalizedAppName);
        }
        Manifest manifest = facet.getManifest();
        if (manifest != null) {
            manifest.getApplication().getLabel().setValue(ResourceValue.referenceTo('@', null, ResourceType.STRING.getName(), "app_name"));
        }
    }

    private void addRunConfiguration(AndroidFacet facet, TargetSelectionMode targetSelectionMode, String targetAvd) {
        String activityClass = this.isHelloAndroid() ? this.myPackageName + '.' + this.myActivityName : null;
        AndroidUtils.addRunConfiguration(facet, activityClass, false, targetSelectionMode, targetAvd);
    }

    private boolean isHelloAndroid() {
        return StringUtil.isNotEmpty((String)this.myActivityName);
    }

    private void createActivityAndSetupManifest(final AndroidFacet facet, final PsiDirectory sourceDir) {
        if (this.myPackageName != null) {
            CommandProcessor.getInstance().executeCommand(facet.getModule().getProject(), (Runnable)new ExternalChangeAction(){

                public void run() {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            PsiDirectory packageDir = AndroidModuleBuilder.createPackageIfPossible(sourceDir, AndroidModuleBuilder.this.myPackageName);
                            if (packageDir == null) {
                                return;
                            }
                            Manifest manifest = facet.getManifest();
                            if (manifest != null) {
                                AndroidPlatform platform;
                                manifest.getPackage().setValue((Object)AndroidModuleBuilder.this.myPackageName);
                                Module module = facet.getModule();
                                Project project = module.getProject();
                                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                                    @Override
                                    public void run() {
                                        FileDocumentManager.getInstance().saveAllDocuments();
                                    }
                                });
                                AndroidModuleBuilder.this.assignApplicationName(facet);
                                Sdk sdk = AndroidModuleBuilder.getAndroidSdkForModule(module);
                                if (sdk != null && (platform = AndroidPlatform.parse(sdk)) != null) {
                                    AndroidModuleBuilder.configureManifest(facet, platform.getTarget());
                                }
                            }
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(action);
                }
            }, AndroidBundle.message("build.android.module.process.title", new Object[0]), null);
        }
    }

    private void createResourcesAndLibs(Project project, VirtualFile rootDir) {
        try {
            AndroidUtils.createChildDirectoryIfNotExist(project, rootDir, "assets");
            AndroidUtils.createChildDirectoryIfNotExist(project, rootDir, "libs");
            VirtualFile resDir = AndroidUtils.createChildDirectoryIfNotExist(project, rootDir, "res");
            VirtualFile drawableDir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, "drawable");
            AndroidModuleBuilder.createFileFromResource(project, drawableDir, "icon.png", "/icons/androidLarge.png");
            if (this.isHelloAndroid()) {
                VirtualFile valuesDir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, "values");
                AndroidModuleBuilder.createFileFromResource(project, valuesDir, "strings.xml", "res/values/strings.xml");
                VirtualFile layoutDir = AndroidUtils.createChildDirectoryIfNotExist(project, resDir, "layout");
                AndroidModuleBuilder.createFileFromResource(project, layoutDir, "main.xml", "res/layout/main.xml");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void setActivityName(String activityName) {
        this.myActivityName = activityName;
    }

    public String getApplicationName() {
        return this.myApplicationName;
    }

    public void setApplicationName(String applicationName) {
        this.myApplicationName = applicationName;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = packageName;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    protected ProjectType getProjectType() {
        return ANDROID_PROJECT_TYPE;
    }

    public ModuleWizardStep modifySettingsStep(SettingsStep settingsStep) {
        if (this.myProjectType == null) {
            return super.modifyProjectTypeStep(settingsStep);
        }
        switch (this.myProjectType) {
            case APPLICATION: {
                return new AndroidApplicationModifiedSettingsStep(this, settingsStep);
            }
            case LIBRARY: {
                return new AndroidLibraryModifiedSettingsStep(this, settingsStep);
            }
            case TEST: {
                return new AndroidTestModifiedSettingsStep(this, settingsStep);
            }
        }
        LOG.error("Unknown project type " + (Object)((Object)this.myProjectType));
        return super.modifyProjectTypeStep(settingsStep);
    }

    public void setTestedModule(Module module) {
        this.myTestedModule = module;
    }

    public void setTargetSelectionMode(TargetSelectionMode targetSelectionMode) {
        this.myTargetSelectionMode = targetSelectionMode;
    }

    public void setPreferredAvd(String preferredAvd) {
        this.myPreferredAvd = preferredAvd;
    }

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
        return new ModuleWizardStep[]{new AndroidModuleWizardStep(this, modulesProvider, this.myProjectType)};
    }

    public Icon getBigIcon() {
        return AndroidIcons.Android24;
    }

    public Icon getNodeIcon() {
        return AndroidIcons.Android;
    }

    public String getDescription() {
        return AndroidBundle.message("android.module.type.description", new Object[0]);
    }

    public String getPresentableName() {
        return AndroidBundle.message("android.module.type.name", new Object[0]);
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        return AndroidSdkType.getInstance() == sdkType;
    }

    public static class Test
    extends AndroidModuleBuilder {
        public Test() {
            super(AndroidProjectType.TEST);
        }

        @Override
        public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
            return ModuleWizardStep.EMPTY_ARRAY;
        }

        @Override
        public String getBuilderId() {
            return "android.test";
        }
    }

    public static class Library
    extends AndroidModuleBuilder {
        public Library() {
            super(AndroidProjectType.LIBRARY);
        }

        @Override
        public String getBuilderId() {
            return "android.library";
        }

        @Override
        public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
            return ModuleWizardStep.EMPTY_ARRAY;
        }
    }
}

