/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.newProject.AndroidModifiedSettingsStep;
import org.jetbrains.android.newProject.AndroidModuleBuilder;
import org.jetbrains.android.newProject.AndroidModulesComboBox;
import org.jetbrains.android.run.AndroidRunConfiguration;
import org.jetbrains.android.run.AndroidRunConfigurationType;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.util.AndroidBundle;

class AndroidTestModifiedSettingsStep
extends AndroidModifiedSettingsStep {
    private final AndroidModulesComboBox myModulesCombo = new AndroidModulesComboBox();
    private final Project myProject;

    public AndroidTestModifiedSettingsStep(AndroidModuleBuilder builder, SettingsStep settingsStep) {
        super(builder, settingsStep);
        this.myProject = settingsStep.getContext().getProject();
        assert (this.myProject != null) : "test module can't be created as first module";
        this.myModulesCombo.init(this.myProject);
        settingsStep.addSettingsField("\u001bTested module: ", (JComponent)this.myModulesCombo);
    }

    @Override
    public void updateDataModel() {
        super.updateDataModel();
        Module testedModule = this.myModulesCombo.getModule();
        this.myBuilder.setTestedModule(testedModule);
        this.myBuilder.setTargetSelectionMode(this.chooseTargetSelectionMode(testedModule));
    }

    private TargetSelectionMode chooseTargetSelectionMode(Module testedModule) {
        List androidConfigurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList((ConfigurationType)AndroidRunConfigurationType.getInstance());
        for (RunConfiguration configuration : androidConfigurations) {
            AndroidRunConfiguration cfg = (AndroidRunConfiguration)configuration;
            Module module = ((JavaRunConfigurationModule)cfg.getConfigurationModule()).getModule();
            if (!testedModule.equals(module)) continue;
            return cfg.getTargetSelectionMode();
        }
        return TargetSelectionMode.EMULATOR;
    }

    public boolean validate() throws ConfigurationException {
        if (!super.validate()) {
            return false;
        }
        Module module = this.myModulesCombo.getModule();
        if (module == null) {
            throw new ConfigurationException(AndroidBundle.message("android.wizard.specify.tested.module.error", new Object[0]));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            throw new ConfigurationException(AndroidBundle.message("android.wizard.tested.module.without.facet.error", new Object[0]));
        }
        String moduleDirPath = AndroidRootUtil.getModuleDirPath(module);
        if (moduleDirPath == null) {
            throw new ConfigurationException(AndroidBundle.message("android.wizard.cannot.find.module.parent.dir.error", module.getName()));
        }
        VirtualFile mainContentRoot = AndroidRootUtil.getMainContentRoot(facet);
        if (mainContentRoot == null) {
            throw new ConfigurationException(AndroidBundle.message("android.wizard.cannot.find.main.content.root.error", module.getName()));
        }
        return true;
    }
}

