/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.resources.ResourceType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Map;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.refactoring.AndroidAttributeInfo;
import org.jetbrains.android.refactoring.StyleRefData;
import org.jetbrains.android.refactoring.StyleUsageData;

class ViewStyleUsageData
implements StyleUsageData {
    private final XmlTag myTag;
    private final GenericAttributeValue<ResourceValue> myStyleAttribute;
    private final AndroidResourceReferenceBase myReference;

    ViewStyleUsageData(XmlTag tag, GenericAttributeValue<ResourceValue> styleAttribute, AndroidResourceReferenceBase reference) {
        this.myTag = tag;
        this.myStyleAttribute = styleAttribute;
        this.myReference = reference;
    }

    @Override
    public PsiFile getFile() {
        return this.myTag.getContainingFile();
    }

    @Override
    public void inline(Map<AndroidAttributeInfo, String> attributeValues, StyleRefData parentStyleRef) {
        for (Map.Entry<AndroidAttributeInfo, String> entry : attributeValues.entrySet()) {
            String namespace;
            AndroidAttributeInfo info = entry.getKey();
            String localName = info.getName();
            if (this.myTag.getAttribute(localName, namespace = info.getNamespace()) != null) continue;
            this.myTag.setAttribute(localName, namespace, entry.getValue());
        }
        this.myStyleAttribute.setValue(parentStyleRef != null ? ResourceValue.referenceTo('@', parentStyleRef.getStylePackage(), ResourceType.STYLE.getName(), parentStyleRef.getStyleName()) : null);
    }

    @Override
    public AndroidResourceReferenceBase getReference() {
        return this.myReference;
    }
}

