/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;

public class LocalResourceManager
extends ResourceManager {
    private AttributeDefinitions myAttrDefs;
    protected final AndroidFacet myFacet;

    public LocalResourceManager(AndroidFacet facet) {
        super(facet.getModule().getProject());
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public VirtualFile[] getAllResourceDirs() {
        HashSet result = new HashSet();
        LocalResourceManager.collectResourceDirs(this.getFacet(), (Set<VirtualFile>)result, (Set<Module>)new HashSet());
        return VfsUtilCore.toVirtualFileArray((Collection)result);
    }

    @Override
    public boolean isResourceDir(VirtualFile dir) {
        for (VirtualFile resDir : this.getResourceDirs()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile dir1 : this.getResourceOverlayDirs()) {
            if (!dir.equals(dir1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<VirtualFile> getResourceDirs() {
        return this.myFacet.getAllResourceDirectories();
    }

    public List<Pair<Resources, VirtualFile>> getResourceElements() {
        return this.getResourceElements(null);
    }

    @Override
    public VirtualFile[] getResourceOverlayDirs() {
        return AndroidRootUtil.getResourceOverlayDirs(this.getFacet());
    }

    public List<ResourceElement> getValueResources(String resourceType) {
        return this.getValueResources(resourceType, null);
    }

    private static void collectResourceDirs(AndroidFacet facet, Set<VirtualFile> result, Set<Module> visited) {
        if (!visited.add(facet.getModule())) {
            return;
        }
        for (VirtualFile resDir : facet.getAllResourceDirectories()) {
            if (result.add(resDir)) continue;
            return;
        }
        java.util.HashSet dirs = Sets.newHashSet();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        if (!dirs.isEmpty()) {
            for (File dir : dirs) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(dir);
                if (virtualFile == null) continue;
                result.add(virtualFile);
            }
        }
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), false)) {
            LocalResourceManager.collectResourceDirs(depFacet, result, visited);
        }
    }

    public static LocalResourceManager getInstance(Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? facet.getLocalResourceManager() : null;
    }

    public static LocalResourceManager getInstance(PsiElement element) {
        AndroidFacet facet = AndroidFacet.getInstance(element);
        return facet != null ? facet.getLocalResourceManager() : null;
    }

    public Set<String> getValueResourceTypes() {
        HashMap file2Types = new HashMap();
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        for (ResourceType resourceType : AndroidResourceUtil.ALL_VALUE_RESOURCE_TYPES) {
            ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType.getName());
            index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<AndroidValueResourcesIndex.MyResourceInfo>>((Map)file2Types){
                final /* synthetic */ Map val$file2Types;
                {
                    this.val$file2Types = map;
                }

                public boolean process(VirtualFile file, Set<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                    for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                        Set resourcesInFile = (Set)this.val$file2Types.get(file);
                        if (resourcesInFile == null) {
                            resourcesInFile = new HashSet();
                            this.val$file2Types.put(file, resourcesInFile);
                        }
                        resourcesInFile.add(info.getResourceEntry().getType());
                    }
                    return true;
                }
            }, scope);
        }
        HashSet result = new HashSet();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set types = (Set)file2Types.get(file);
            if (types == null) continue;
            result.addAll(types);
        }
        return result;
    }

    @Override
    public AttributeDefinitions getAttributeDefinitions() {
        if (this.myAttrDefs == null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ArrayList<XmlFile> xmlResFiles = new ArrayList<XmlFile>();
                    for (PsiFile file : LocalResourceManager.this.findResourceFiles("values")) {
                        if (!(file instanceof XmlFile)) continue;
                        xmlResFiles.add((XmlFile)file);
                    }
                    LocalResourceManager.this.myAttrDefs = new AttributeDefinitionsImpl(xmlResFiles.toArray(new XmlFile[xmlResFiles.size()]));
                }
            });
        }
        return this.myAttrDefs;
    }

    public void invalidateAttributeDefinitions() {
        this.myAttrDefs = null;
    }

    public List<Attr> findAttrs(String name) {
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (Attr attr : res.getAttrs()) {
                if (!name.equals(attr.getName().getValue())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    if (!name.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    public List<DeclareStyleable> findStyleables(String name) {
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(String fieldName) {
        int prev;
        int index = fieldName.lastIndexOf(95);
        while (index != -1 && (prev = fieldName.lastIndexOf(95, index - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index = prev;
        }
        if (index == -1) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index);
        String attrName = fieldName.substring(index + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (Pair<Resources, VirtualFile> pair : this.getResourceElements()) {
            Resources res = (Resources)pair.getFirst();
            for (DeclareStyleable styleable : res.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    if (!attrName.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    public List<PsiElement> findResourcesByField(PsiField field) {
        String type = AndroidResourceUtil.getResourceClassName(field);
        if (type == null) {
            return Collections.emptyList();
        }
        String fieldName = field.getName();
        if (fieldName == null) {
            return Collections.emptyList();
        }
        return this.findResourcesByFieldName(type, fieldName);
    }

    public List<PsiElement> findResourcesByFieldName(String resClassName, String fieldName) {
        ArrayList<PsiElement> targets;
        block7: {
            block6: {
                targets = new ArrayList<PsiElement>();
                if (resClassName.equals(ResourceType.ID.getName())) {
                    targets.addAll(this.findIdDeclarations(fieldName));
                }
                for (PsiFile file : this.findResourceFiles(resClassName, fieldName, false, new String[0])) {
                    targets.add((PsiElement)file);
                }
                for (ResourceElement element : this.findValueResources(resClassName, fieldName, false)) {
                    targets.add((PsiElement)element.getName().getXmlAttributeValue());
                }
                if (!resClassName.equals(ResourceType.ATTR.getName())) break block6;
                for (Attr attr : this.findAttrs(fieldName)) {
                    targets.add((PsiElement)attr.getName().getXmlAttributeValue());
                }
                break block7;
            }
            if (!resClassName.equals(ResourceType.STYLEABLE.getName())) break block7;
            for (DeclareStyleable styleable : this.findStyleables(fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        return targets;
    }

    @Override
    public Collection<String> getResourceNames(String type) {
        return this.getResourceNames(type, true);
    }

    public Collection<String> getResourceNames(String type, boolean publicOnly) {
        HashSet result = new HashSet();
        ResourceType t = ResourceType.getEnum((String)type);
        if (publicOnly && t != null) {
            AppResourceRepository appResources = AppResourceRepository.getAppResources(this.myFacet, true);
            for (String name : this.getValueResourceNames(type)) {
                if (appResources.isPrivate(t, name)) continue;
                result.add(name);
            }
            for (String name : this.getFileResourcesNames(type)) {
                if (appResources.isPrivate(t, name)) continue;
                result.add(name);
            }
            if (t == ResourceType.ID) {
                for (String name : this.getIds(true)) {
                    if (appResources.isPrivate(t, name)) continue;
                    result.add(name);
                }
            }
        } else {
            super.getResourceNames(type);
        }
        return result;
    }
}

