/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidIdIndex;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.FileResourceProcessor;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(Project project) {
        this.myProject = project;
    }

    public abstract VirtualFile[] getAllResourceDirs();

    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(VirtualFile var1);

    public boolean processFileResources(String resourceType, FileResourceProcessor processor) {
        return this.processFileResources(resourceType, processor, true);
    }

    public boolean processFileResources(String resourceType, FileResourceProcessor processor, boolean withDependencies) {
        return this.processFileResources(resourceType, processor, withDependencies, true);
    }

    public boolean processFileResources(String resourceType, FileResourceProcessor processor, boolean withDependencies, boolean publicOnly) {
        VirtualFile[] resDirs;
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            List<VirtualFile> resourceDirs = this.getResourceDirs();
            resDirs = resourceDirs.toArray(new VirtualFile[resourceDirs.size()]);
        }
        for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(resourceType, resDirs)) {
            String resType = AndroidCommonUtils.getResourceTypeByDirName((String)resSubdir.getName());
            if (resType == null) continue;
            assert (resourceType == null || resourceType.equals(resType));
            for (VirtualFile resFile : resSubdir.getChildren()) {
                String resName = AndroidCommonUtils.getResourceName((String)resType, (String)resFile.getName());
                if (resFile.isDirectory() || publicOnly && !this.isResourcePublic(resType, resName) || processor.process(resFile, resName, resType)) continue;
                return false;
            }
        }
        return true;
    }

    public VirtualFile[] getResourceOverlayDirs() {
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isResourcePublic(String type, String name) {
        return true;
    }

    public List<VirtualFile> getResourceSubdirs(String resourceType) {
        return AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs());
    }

    public List<PsiFile> findResourceFiles(String resType, String resName, boolean distinguishDelimetersInName, String ... extensions) {
        return this.findResourceFiles(resType, resName, distinguishDelimetersInName, true, extensions);
    }

    public List<PsiFile> findResourceFiles(String resType1, String resName1, boolean distinguishDelimetersInName, boolean withDependencies, final String ... extensions) {
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        HashSet extensionSet = new HashSet();
        Collections.addAll(extensionSet, extensions);
        this.processFileResources(resType1, new FileResourceProcessor((Set)extensionSet, resName1, distinguishDelimetersInName, result){
            final /* synthetic */ Set val$extensionSet;
            final /* synthetic */ String val$resName1;
            final /* synthetic */ boolean val$distinguishDelimetersInName;
            final /* synthetic */ List val$result;
            {
                this.val$extensionSet = set;
                this.val$resName1 = string;
                this.val$distinguishDelimetersInName = bl;
                this.val$result = list;
            }

            @Override
            public boolean process(VirtualFile resFile, String resName, String resFolderType) {
                PsiFile file;
                String extension = resFile.getExtension();
                if ((extensions.length == 0 || this.val$extensionSet.contains(extension)) && (this.val$resName1 == null || AndroidUtils.equal(this.val$resName1, resName, this.val$distinguishDelimetersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(ResourceManager.this.myProject, resFile)) != null) {
                    this.val$result.add(file);
                }
                return true;
            }
        }, withDependencies);
        return result;
    }

    public List<PsiFile> findResourceFiles(String resType, String resName, String ... extensions) {
        return this.findResourceFiles(resType, resName, true, extensions);
    }

    public List<PsiFile> findResourceFiles(String resType) {
        return this.findResourceFiles(resType, null, true, new String[0]);
    }

    protected List<Pair<Resources, VirtualFile>> getResourceElements(Set<VirtualFile> files) {
        return this.getRootDomElements(Resources.class, files);
    }

    private <T extends DomElement> List<Pair<T, VirtualFile>> getRootDomElements(Class<T> elementType, Set<VirtualFile> files) {
        ArrayList<Pair<T, VirtualFile>> result = new ArrayList<Pair<T, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            T element;
            if (files != null && !files.contains(file) || !file.isValid() || (element = AndroidUtils.loadDomElement(this.myProject, file, elementType)) == null) continue;
            result.add(Pair.create(element, (Object)file));
        }
        return result;
    }

    protected Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs("values")) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files.add(valueResourceFile);
            }
        }
        return files;
    }

    protected List<ResourceElement> getValueResources(final String resourceType, Set<VirtualFile> files) {
        final ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        List<Pair<Resources, VirtualFile>> resourceFiles = this.getResourceElements(files);
        for (Pair<Resources, VirtualFile> pair : resourceFiles) {
            final Resources resources = (Resources)pair.getFirst();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (!resources.isValid() || ResourceManager.this.myProject.isDisposed()) {
                        return;
                    }
                    List<ResourceElement> valueResources = AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources);
                    for (ResourceElement valueResource : valueResources) {
                        String resName = (String)valueResource.getName().getValue();
                        if (resName == null || !ResourceManager.this.isResourcePublic(resourceType, resName)) continue;
                        result.add(valueResource);
                    }
                }
            });
        }
        return result;
    }

    public String getValueResourceType(XmlTag tag) {
        String fileResType = this.getFileResourceType(tag.getContainingFile());
        if ("values".equals(fileResType)) {
            return tag.getName();
        }
        return null;
    }

    public String getFileResourceType(final PsiFile file) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiDirectory dir = file.getContainingDirectory();
                if (dir == null) {
                    return null;
                }
                PsiDirectory possibleResDir = dir.getParentDirectory();
                if (possibleResDir == null || !ResourceManager.this.isResourceDir(possibleResDir.getVirtualFile())) {
                    return null;
                }
                String type = AndroidCommonUtils.getResourceTypeByDirName((String)dir.getName());
                if (type == null) {
                    return null;
                }
                return type;
            }
        });
    }

    public Set<String> getFileResourcesNames(String resourceType) {
        HashSet result = new HashSet();
        this.processFileResources(resourceType, new FileResourceProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public boolean process(VirtualFile resFile, String resName, String resFolderType) {
                this.val$result.add(resName);
                return true;
            }
        });
        return result;
    }

    public Collection<String> getValueResourceNames(String resourceType) {
        HashSet result = new HashSet();
        boolean attr = ResourceType.ATTR.getName().equals(resourceType);
        for (ResourceEntry entry : this.getValueResourceEntries(resourceType)) {
            String name = entry.getName();
            if (attr && name.startsWith("android:")) continue;
            result.add(name);
        }
        return result;
    }

    public Collection<ResourceEntry> getValueResourceEntries(String resourceType) {
        ResourceType type = ResourceType.getEnum((String)resourceType);
        if (type == null) {
            return Collections.emptyList();
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        HashMap file2resourceSet = new HashMap();
        index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<AndroidValueResourcesIndex.MyResourceInfo>>((Map)file2resourceSet){
            final /* synthetic */ Map val$file2resourceSet;
            {
                this.val$file2resourceSet = map;
            }

            public boolean process(VirtualFile file, Set<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    Set resourcesInFile = (Set)this.val$file2resourceSet.get(file);
                    if (resourcesInFile == null) {
                        resourcesInFile = new HashSet();
                        this.val$file2resourceSet.put(file, resourcesInFile);
                    }
                    resourcesInFile.add(info.getResourceEntry());
                }
                return true;
            }
        }, scope);
        ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set entries = (Set)file2resourceSet.get(file);
            if (entries == null) continue;
            for (ResourceEntry entry : entries) {
                if (!this.isResourcePublic(entry.getType(), entry.getName())) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public Collection<String> getResourceNames(String type) {
        HashSet result = new HashSet();
        result.addAll(this.getValueResourceNames(type));
        result.addAll(this.getFileResourcesNames(type));
        if (type.equals(ResourceType.ID.getName())) {
            result.addAll(this.getIds(true));
        }
        return result;
    }

    public abstract AttributeDefinitions getAttributeDefinitions();

    public List<XmlAttributeValue> findIdDeclarations(final String id) {
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            return Collections.emptyList();
        }
        final ArrayList<XmlAttributeValue> declarations = new ArrayList<XmlAttributeValue>();
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("+" + id), GlobalSearchScope.allScope((Project)this.myProject));
        HashSet fileSet = new HashSet(files);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile subdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile file : subdir.getChildren()) {
                PsiFile psiFile;
                if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                        String idInAttr;
                        if (AndroidResourceUtil.isIdDeclaration(attributeValue) && id.equals(idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue()))) {
                            declarations.add(attributeValue);
                        }
                    }
                });
            }
        }
        return declarations;
    }

    public Collection<String> getIds(boolean declarationsOnly) {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashMap file2idEntries = new HashMap();
        index.processValues(AndroidIdIndex.INDEX_ID, (Object)"$", null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<String>>((Map)file2idEntries){
            final /* synthetic */ Map val$file2idEntries;
            {
                this.val$file2idEntries = map;
            }

            public boolean process(VirtualFile file, Set<String> value) {
                this.val$file2idEntries.put(file, value);
                return true;
            }
        }, scope);
        HashSet result = new HashSet();
        for (VirtualFile resSubdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile resFile : resSubdir.getChildren()) {
                Set idEntries = (Set)file2idEntries.get(resFile);
                if (idEntries == null) continue;
                for (String idEntry : idEntries) {
                    if (idEntry.startsWith("+")) {
                        idEntry = idEntry.substring(1);
                    } else if (declarationsOnly) continue;
                    if (!this.isResourcePublic(ResourceType.ID.getName(), idEntry)) continue;
                    result.add(idEntry);
                }
            }
        }
        return result;
    }

    public List<VirtualFile> getResourceSubdirsToSearchIds() {
        ArrayList<VirtualFile> resSubdirs = new ArrayList<VirtualFile>();
        for (ResourceType type : AndroidCommonUtils.ID_PROVIDING_RESOURCE_TYPES) {
            resSubdirs.addAll(this.getResourceSubdirs(type.getName()));
        }
        return resSubdirs;
    }

    public List<ResourceElement> findValueResources(String resType, String resName) {
        return this.findValueResources(resType, resName, true);
    }

    public List<ResourceElement> findValueResources(String resourceType, String resourceName, boolean distinguishDelimitersInName) {
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result.add(domElement);
        }
        return result;
    }

    public void collectLazyResourceElements(String resType, String resName, boolean withAttrs, PsiElement context, Collection<PsiElement> elements) {
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(resType, resName, false, withAttrs);
        for (ValueResourceInfoImpl resource : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(resource, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(resName));
        }
        if (elements.size() == 0) {
            for (PsiFile file : this.findResourceFiles(resType, resName, false, new String[0])) {
                elements.add(new FileResourceElementWrapper(file));
            }
        }
    }

    public List<ValueResourceInfoImpl> findValueResourceInfos(String resourceType, final String resourceName, final boolean distinguishDelimetersInName, boolean searchAttrs) {
        ResourceType type;
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null || !AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(type) && (type != ResourceType.ATTR || !searchAttrs)) {
            return Collections.emptyList();
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        final ArrayList<ValueResourceInfoImpl> result = new ArrayList<ValueResourceInfoImpl>();
        final Set<VirtualFile> valueResourceFiles = this.getAllValueResourceFiles();
        FileBasedIndex.getInstance().processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)AndroidValueResourcesIndex.createTypeNameMarkerKey(resourceType, resourceName), null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Set<AndroidValueResourcesIndex.MyResourceInfo>>(){

            public boolean process(VirtualFile file, Set<AndroidValueResourcesIndex.MyResourceInfo> infos) {
                for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                    String name = info.getResourceEntry().getName();
                    if (!AndroidUtils.equal(resourceName, name, distinguishDelimetersInName) || !valueResourceFiles.contains(file)) continue;
                    result.add(new ValueResourceInfoImpl(info.getResourceEntry().getName(), type, file, ResourceManager.this.myProject, info.getOffset()));
                }
                return true;
            }
        }, scope);
        return result;
    }
}

