/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;

public class SystemResourceManager
extends ResourceManager {
    private final AndroidPlatform myPlatform;
    private final boolean myPublicOnly;

    public SystemResourceManager(Project project, AndroidPlatform androidPlatform, boolean publicOnly) {
        super(project);
        this.myPlatform = androidPlatform;
        this.myPublicOnly = publicOnly;
    }

    @Override
    protected boolean isResourcePublic(String type, String name) {
        return !this.myPublicOnly || this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).isResourcePublic(type, name);
    }

    @Override
    public VirtualFile[] getAllResourceDirs() {
        VirtualFile[] virtualFileArray;
        VirtualFile resDir = this.getResourceDir();
        if (resDir != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = resDir;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        return virtualFileArray;
    }

    private VirtualFile getResourceDir() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(VirtualFile dir) {
        return dir.equals(this.getResourceDir());
    }

    @Override
    public List<VirtualFile> getResourceDirs() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(resPath);
        return dir != null ? Collections.singletonList(dir) : Collections.emptyList();
    }

    public static SystemResourceManager getInstance(ConvertContext context) {
        AndroidFacet facet = AndroidFacet.getInstance(context);
        return facet != null ? facet.getSystemResourceManager() : null;
    }

    @Override
    public synchronized AttributeDefinitions getAttributeDefinitions() {
        return this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).getPublicAttrDefs(this.myProject);
    }
}

