/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;

abstract class ValueResourceInfoBase
implements ValueResourceInfo {
    protected final String myName;
    protected final ResourceType myType;
    protected final VirtualFile myFile;

    protected ValueResourceInfoBase(String name, ResourceType type, VirtualFile file) {
        this.myName = name;
        this.myType = type;
        this.myFile = file;
    }

    @Override
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public ResourceType getType() {
        return this.myType;
    }

    public String toString() {
        return "ANDROID_RESOURCE: " + this.myType + ", " + this.myName + ", " + this.myFile.getPath() + "]";
    }

    @Override
    public int compareTo(ValueResourceInfo other) {
        VirtualFile file1 = this.myFile;
        VirtualFile file2 = other.getContainingFile();
        int delta = AndroidResourceUtil.compareResourceFiles(file1, file2);
        if (delta != 0) {
            return delta;
        }
        return this.getSortingRank() - ((ValueResourceInfoBase)other).getSortingRank();
    }

    protected abstract int getSortingRank();
}

