/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.DomElement;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;

public class ActivityLocatorUtils {
    public static boolean shouldUseMergedManifest(AndroidFacet facet) {
        return facet.requiresAndroidModel() || facet.getProperties().ENABLE_MANIFEST_MERGING;
    }

    public static boolean containsLauncherIntent(List<IntentFilter> intentFilters) {
        for (IntentFilter filter : intentFilters) {
            if (!AndroidDomUtil.containsAction(filter, "android.intent.action.MAIN") || !AndroidDomUtil.containsCategory(filter, "android.intent.category.LAUNCHER") && !AndroidDomUtil.containsCategory(filter, "android.intent.category.LEANBACK_LAUNCHER")) continue;
            return true;
        }
        return false;
    }

    public static String getQualifiedName(ActivityAlias alias) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String name = alias.getName().getStringValue();
        if (name == null) {
            return null;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0) {
            return name;
        }
        String pkg = null;
        DomElement parent = alias.getParent();
        if (parent instanceof Application && (parent = parent.getParent()) instanceof Manifest) {
            Manifest manifest = (Manifest)parent;
            pkg = manifest.getPackage().getStringValue();
        }
        return pkg == null ? name : pkg + (dotIndex == -1 ? "." : "") + name;
    }

    public static String getQualifiedName(Activity activity) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiClass c = (PsiClass)activity.getActivityClass().getValue();
        return c == null ? null : c.getQualifiedName();
    }
}

