/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.ActivityLocator;
import org.jetbrains.android.run.AndroidApplicationLauncher;
import org.jetbrains.android.run.AndroidRunningState;

public class AndroidActivityLauncher
extends AndroidApplicationLauncher {
    private static final Logger LOG = Logger.getInstance(AndroidActivityLauncher.class);
    private final AndroidFacet myFacet;
    private final boolean myNeedsLaunch;
    private final ActivityLocator myActivityLocator;
    private final String myActivityExtraFlags;

    public AndroidActivityLauncher(AndroidFacet facet, boolean needsLaunch, ActivityLocator locator, String activityExtraFlags) {
        this.myFacet = facet;
        this.myNeedsLaunch = needsLaunch;
        this.myActivityLocator = locator;
        this.myActivityExtraFlags = activityExtraFlags;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        try {
            this.myActivityLocator.validate();
        }
        catch (ActivityLocator.ActivityLocatorException e) {
            throw new RuntimeConfigurationException(e.getMessage());
        }
    }

    @Override
    public boolean isReadyForDebugging(ClientData data, ProcessHandler processHandler) {
        ClientData.DebuggerStatus status = data.getDebuggerConnectionStatus();
        switch (status) {
            case ERROR: {
                if (processHandler != null) {
                    processHandler.notifyTextAvailable("Debug port is busy\n", ProcessOutputTypes.STDOUT);
                }
                LOG.info("Debug port is busy");
                return false;
            }
            case ATTACHED: {
                if (processHandler != null) {
                    processHandler.notifyTextAvailable("Debugger already attached\n", ProcessOutputTypes.STDOUT);
                }
                LOG.info("Debugger already attached");
                return false;
            }
            case WAITING: {
                return true;
            }
        }
        String msg = "Client not ready yet.";
        if (processHandler != null) {
            processHandler.notifyTextAvailable(msg + "\n", ProcessOutputTypes.STDOUT);
        }
        LOG.info(msg);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AndroidApplicationLauncher.LaunchResult launch(AndroidRunningState state, IDevice device) throws IOException, AdbCommandRejectedException, TimeoutException {
        boolean success;
        String activityName;
        if (!this.myNeedsLaunch) {
            return AndroidApplicationLauncher.LaunchResult.NOTHING_TO_DO;
        }
        ProcessHandler processHandler = state.getProcessHandler();
        try {
            activityName = this.myActivityLocator.getQualifiedActivityName(device);
        }
        catch (ActivityLocator.ActivityLocatorException e) {
            processHandler.notifyTextAvailable("Could not identify launch activity: " + e.getMessage(), ProcessOutputTypes.STDOUT);
            return AndroidApplicationLauncher.LaunchResult.NOTHING_TO_DO;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(state.getPackageName(), activityName);
        if (state.isStopped()) {
            return AndroidApplicationLauncher.LaunchResult.STOP;
        }
        processHandler.notifyTextAvailable("Launching application: " + activityPath + ".\n", ProcessOutputTypes.STDOUT);
        AndroidRunningState.MyReceiver receiver = new AndroidRunningState.MyReceiver(state);
        while (true) {
            if (state.isStopped()) {
                return AndroidApplicationLauncher.LaunchResult.STOP;
            }
            String command = AndroidActivityLauncher.getStartActivityCommand(activityPath, this.getDebugFlags(state), this.myActivityExtraFlags);
            boolean deviceNotResponding = false;
            try {
                state.executeDeviceCommandAndWriteToConsole(device, command, receiver);
            }
            catch (ShellCommandUnresponsiveException e) {
                LOG.info((Throwable)e);
                deviceNotResponding = true;
            }
            if (!deviceNotResponding && receiver.getErrorType() != 2) break;
            processHandler.notifyTextAvailable("Device is not ready. Waiting for 20 sec.\n", ProcessOutputTypes.STDOUT);
            Object object = state.getRunningLock();
            synchronized (object) {
                try {
                    state.getRunningLock().wait(20000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            receiver = new AndroidRunningState.MyReceiver(state);
        }
        boolean bl = success = receiver.getErrorType() == -2;
        if (success) {
            processHandler.notifyTextAvailable(receiver.getOutput().toString(), ProcessOutputTypes.STDOUT);
            return AndroidApplicationLauncher.LaunchResult.SUCCESS;
        }
        processHandler.notifyTextAvailable(receiver.getOutput().toString(), ProcessOutputTypes.STDERR);
        return AndroidApplicationLauncher.LaunchResult.STOP;
    }

    static String getStartActivityCommand(String activityPath, String debugFlags, String extraFlags) {
        return "am start " + debugFlags + " -n \"" + activityPath + "\" " + "-a android.intent.action.MAIN " + "-c android.intent.category.LAUNCHER" + (extraFlags.isEmpty() ? "" : " " + extraFlags);
    }

    static String getLauncherActivityPath(String packageName, String activityName) {
        return packageName + "/" + activityName.replace("$", "\\$");
    }

    protected String getDebugFlags(AndroidRunningState state) {
        return state.isDebugMode() ? "-D" : "";
    }
}

