/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import org.jetbrains.android.run.AndroidExecutionState;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunningState;

public class AndroidDebugState
implements RemoteState,
AndroidExecutionState {
    private final Project myProject;
    private final RemoteConnection myConnection;
    private final AndroidRunningState myState;
    private final IDevice myDevice;
    private volatile ConsoleView myConsoleView;

    public AndroidDebugState(Project project, RemoteConnection connection, AndroidRunningState state, IDevice device) {
        this.myProject = project;
        this.myConnection = connection;
        this.myState = state;
        this.myDevice = device;
    }

    public ExecutionResult execute(Executor executor, ProgramRunner runner) throws ExecutionException {
        RemoteDebugProcessHandler process = new RemoteDebugProcessHandler(this.myProject);
        this.myState.setProcessHandler((ProcessHandler)process);
        this.myConsoleView = this.myState.getConfiguration().attachConsole(this.myState, executor);
        return new DefaultExecutionResult((ExecutionConsole)this.myConsoleView, (ProcessHandler)process);
    }

    public RemoteConnection getRemoteConnection() {
        return this.myConnection;
    }

    @Override
    public IDevice[] getDevices() {
        return new IDevice[]{this.myDevice};
    }

    @Override
    public ConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    @Override
    public AndroidRunConfigurationBase getConfiguration() {
        return this.myState.getConfiguration();
    }
}

