/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.CommonBundle;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import org.jetbrains.android.run.AndroidClassBrowserBase;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidInheritingClassBrowser
extends AndroidClassBrowserBase {
    private final String myBaseClassName;

    public AndroidInheritingClassBrowser(Project project, ConfigurationModuleSelector moduleSelector, String baseClassName, String dialogTitle, boolean includeLibraryClasses) {
        super(project, moduleSelector, dialogTitle, includeLibraryClasses);
        this.myBaseClassName = baseClassName;
    }

    @Override
    protected TreeClassChooser createTreeClassChooser(Project project, GlobalSearchScope scope, PsiClass initialSelection, final ClassFilter classFilter) {
        final PsiClass baseClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myBaseClassName, ProjectScope.getAllScope((Project)project));
        if (baseClass == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.find.class.error", this.myBaseClassName), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser(this.myDialogTitle, scope, baseClass, initialSelection, new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                if (aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)baseClass)) {
                    return false;
                }
                return classFilter.isAccepted(aClass);
            }
        });
    }
}

