/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import org.jetbrains.android.run.AndroidClassVisibilityCheckerBase;

public class AndroidInheritingClassVisibilityChecker
extends AndroidClassVisibilityCheckerBase {
    private final Project myProject;
    private final String myBaseClassName;

    public AndroidInheritingClassVisibilityChecker(Project project, ConfigurationModuleSelector moduleSelector, String baseClassName) {
        super(moduleSelector);
        this.myProject = project;
        this.myBaseClassName = baseClassName;
    }

    @Override
    protected boolean isVisible(Module module, PsiClass aClass) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiClass baseClass = facade.findClass(this.myBaseClassName, module.getModuleWithDependenciesAndLibrariesScope(true));
        return baseClass != null && aClass.isInheritor(baseClass, true);
    }
}

