/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;

public class AndroidProcessText {
    private static final Key<AndroidProcessText> KEY = new Key("ANDROID_PROCESS_TEXT");
    private final List<MyFragment> myFragments = new ArrayList<MyFragment>();

    private AndroidProcessText(ProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                List list = AndroidProcessText.this.myFragments;
                synchronized (list) {
                    AndroidProcessText.this.myFragments.add(new MyFragment(event.getText(), outputType));
                }
            }
        });
        processHandler.putUserData(KEY, (Object)this);
    }

    public static void attach(ProcessHandler processHandler) {
        new AndroidProcessText(processHandler);
    }

    public static AndroidProcessText get(ProcessHandler processHandler) {
        return (AndroidProcessText)processHandler.getUserData(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTo(ProcessHandler processHandler) {
        List<MyFragment> list = this.myFragments;
        synchronized (list) {
            for (MyFragment fragment : this.myFragments) {
                processHandler.notifyTextAvailable(fragment.getText(), fragment.getOutputType());
            }
        }
    }

    private static class MyFragment {
        private final String myText;
        private final Key myOutputType;

        private MyFragment(String text, Key outputType) {
            this.myText = text;
            this.myOutputType = outputType;
        }

        public String getText() {
            return this.myText;
        }

        public Key getOutputType() {
            return this.myOutputType;
        }
    }
}

