/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.model.ManifestInfo;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.ActivityLocator;
import org.jetbrains.android.run.AndroidActivityLauncher;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.AndroidRunConfigurationEditor;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.ApkProvider;
import org.jetbrains.android.run.ApplicationRunParameters;
import org.jetbrains.android.run.DefaultActivityLocator;
import org.jetbrains.android.run.EmptyActivityLocator;
import org.jetbrains.android.run.GradleApkProvider;
import org.jetbrains.android.run.MavenDefaultActivityLocator;
import org.jetbrains.android.run.NonGradleApkProvider;
import org.jetbrains.android.run.SpecificActivityLocator;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;

public class AndroidRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    @NonNls
    public static final String LAUNCH_DEFAULT_ACTIVITY = "default_activity";
    @NonNls
    public static final String LAUNCH_SPECIFIC_ACTIVITY = "specific_activity";
    @NonNls
    public static final String DO_NOTHING = "do_nothing";
    public String ACTIVITY_CLASS = "";
    public String ACTIVITY_EXTRA_FLAGS = "";
    public String MODE = "default_activity";
    public boolean DEPLOY = true;
    public String ARTIFACT_NAME = "";

    public AndroidRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(AndroidFacet facet) {
        return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
    }

    @Override
    protected void checkConfiguration(AndroidFacet facet) throws RuntimeConfigurationException {
        if (this.getTargetSelectionMode() == TargetSelectionMode.CLOUD_DEVICE_LAUNCH && !this.IS_VALID_CLOUD_DEVICE_SELECTION) {
            throw new RuntimeConfigurationError(this.INVALID_CLOUD_DEVICE_SELECTION_ERROR);
        }
        this.getApplicationLauncher(facet).checkConfiguration();
    }

    @Override
    public AndroidRunningState getState(Executor executor, ExecutionEnvironment env) throws ExecutionException {
        AndroidRunningState state = super.getState(executor, env);
        if (state != null) {
            state.setDeploy(this.DEPLOY);
            state.setOpenLogcatAutomatically(this.SHOW_LOGCAT_AUTOMATICALLY);
        }
        return state;
    }

    @Override
    protected ApkProvider getApkProvider() {
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidGradleModel) {
            return new GradleApkProvider(facet, false);
        }
        return new NonGradleApkProvider(facet, this.ARTIFACT_NAME);
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor editor = new AndroidRunConfigurationEditor(project, (Predicate<AndroidFacet>)Predicates.alwaysFalse());
        editor.setConfigurationSpecificEditor(new ApplicationRunParameters(project, editor.getModuleSelector()));
        return editor;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                AndroidRunConfiguration.this.ACTIVITY_CLASS = qualifiedName;
            }

            public PsiClass getPsiElement() {
                return ((JavaRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).findClass(AndroidRunConfiguration.this.ACTIVITY_CLASS);
            }

            public void setPsiElement(PsiClass psiClass) {
                AndroidRunConfiguration.this.ACTIVITY_CLASS = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
            }
        });
    }

    @Override
    protected ConsoleView attachConsole(AndroidRunningState state, Executor executor) {
        Project project = ((JavaRunConfigurationModule)this.getConfigurationModule()).getProject();
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        ConsoleView console = builder.getConsole();
        console.attachToProcess(state.getProcessHandler());
        return console;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return true;
    }

    @Override
    protected AndroidActivityLauncher getApplicationLauncher(AndroidFacet facet) {
        return new AndroidActivityLauncher(facet, this.needsLaunch(), this.getActivityLocator(facet), this.ACTIVITY_EXTRA_FLAGS);
    }

    protected ActivityLocator getActivityLocator(AndroidFacet facet) {
        if (this.MODE.equals(LAUNCH_DEFAULT_ACTIVITY)) {
            if (facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST) {
                return new MavenDefaultActivityLocator(facet);
            }
            return new DefaultActivityLocator(facet);
        }
        if (this.MODE.equals(LAUNCH_SPECIFIC_ACTIVITY)) {
            return new SpecificActivityLocator(facet, this.ACTIVITY_CLASS);
        }
        return new EmptyActivityLocator();
    }

    protected boolean needsLaunch() {
        return LAUNCH_SPECIFIC_ACTIVITY.equals(this.MODE) || LAUNCH_DEFAULT_ACTIVITY.equals(this.MODE);
    }

    public static boolean isWatchFaceApp(AndroidFacet facet) {
        ManifestInfo info = ManifestInfo.get(facet.getModule(), true);
        if (!info.getActivities().isEmpty()) {
            return false;
        }
        final List<Service> services = info.getServices();
        if (services.size() != 1) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                List<IntentFilter> filters = ((Service)services.get(0)).getIntentFilters();
                return filters.size() == 1 && AndroidDomUtil.containsAction(filters.get(0), "android.service.wallpaper.WallpaperService") && AndroidDomUtil.containsCategory(filters.get(0), "com.google.android.wearable.watchface.category.WATCH_FACE");
            }
        });
    }
}

