/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.UsesFeature;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.DeviceChooserListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class DeviceChooser
implements Disposable {
    private static final String[] COLUMN_TITLES = new String[]{"Device", "State", "Compatible", "Serial Number"};
    private static final int DEVICE_NAME_COLUMN_INDEX = 0;
    private static final int DEVICE_STATE_COLUMN_INDEX = 1;
    private static final int COMPATIBILITY_COLUMN_INDEX = 2;
    private static final int SERIAL_COLUMN_INDEX = 3;
    private static final int REFRESH_INTERVAL_MS = 500;
    public static final IDevice[] EMPTY_DEVICE_ARRAY = new IDevice[0];
    private final List<DeviceChooserListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Alarm myRefreshingAlarm;
    private final AndroidDebugBridge myBridge;
    private volatile boolean myProcessSelectionFlag = true;
    private IDevice[] myDisplayedDevices = EMPTY_DEVICE_ARRAY;
    private AtomicReference<IDevice[]> myDetectedDevicesRef = new AtomicReference<IDevice[]>(EMPTY_DEVICE_ARRAY);
    private JComponent myPanel;
    private JBTable myDeviceTable;
    private final AndroidFacet myFacet;
    private final Predicate<IDevice> myFilter;
    private final AndroidVersion myMinSdkVersion;
    private final IAndroidTarget myProjectTarget;
    private final EnumSet<IDevice.HardwareFeature> myRequiredHardwareFeatures;
    private final CloudConfigurationProvider myCloudConfigurationProvider;
    private int[] mySelectedRows;
    private final Runnable myUpdateRequest = new Runnable(){

        @Override
        public void run() {
            DeviceChooser.this.updateTable();
            DeviceChooser.this.addUpdatingRequest();
        }
    };

    public DeviceChooser(boolean multipleSelection, final Action okAction, AndroidFacet facet, IAndroidTarget projectTarget, Predicate<IDevice> filter) {
        this.myCloudConfigurationProvider = CloudConfigurationProvider.getCloudConfigurationProvider();
        this.myFacet = facet;
        this.myFilter = filter;
        this.myMinSdkVersion = AndroidModuleInfo.get(facet).getRuntimeMinSdkVersion();
        this.myProjectTarget = projectTarget;
        this.myRequiredHardwareFeatures = DeviceChooser.getRequiredHardwareFeatures(ManifestInfo.get(facet.getModule(), true).getRequiredFeatures());
        this.myDeviceTable = new JBTable();
        this.myPanel = ScrollPaneFactory.createScrollPane((Component)this.myDeviceTable);
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)550, (int)220));
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(EMPTY_DEVICE_ARRAY));
        this.myDeviceTable.setSelectionMode(multipleSelection ? 2 : 0);
        this.myDeviceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DeviceChooser.this.myProcessSelectionFlag) {
                    DeviceChooser.this.fireSelectedDevicesChanged();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (DeviceChooser.this.myDeviceTable.isEnabled() && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myDeviceTable);
        this.myDeviceTable.setDefaultRenderer(LaunchCompatibility.class, (TableCellRenderer)((Object)new LaunchCompatibilityRenderer()));
        this.myDeviceTable.setDefaultRenderer(IDevice.class, (TableCellRenderer)((Object)new DeviceRenderer.DeviceNameRenderer(facet.getAvdManagerSilently())));
        this.myDeviceTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && okAction.isEnabled()) {
                    okAction.actionPerformed(null);
                }
            }
        });
        this.myDeviceTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int i = DeviceChooser.this.myDeviceTable.rowAtPoint(e.getPoint());
                    Object serial = DeviceChooser.this.myDeviceTable.getValueAt(i, 3);
                    final String serialString = serial.toString();
                    JBPopupMenu popupMenu = new JBPopupMenu();
                    AbstractAction action = new AbstractAction("Copy Serial Number"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(serialString));
                        }
                    };
                    popupMenu.add((Action)action);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
                super.mouseReleased(e);
            }
        });
        DeviceChooser.setColumnWidth(this.myDeviceTable, 0, "Samsung Galaxy Nexus Android 4.1 (API 17)");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 1, "offline");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 2, "Compatible");
        DeviceChooser.setColumnWidth(this.myDeviceTable, 3, "123456");
        this.myDeviceTable.setAutoCreateColumnsFromModel(false);
        this.myDeviceTable.setAutoCreateRowSorter(true);
        this.myRefreshingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myBridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
    }

    private static EnumSet<IDevice.HardwareFeature> getRequiredHardwareFeatures(List<UsesFeature> requiredFeatures) {
        for (UsesFeature feature : requiredFeatures) {
            AndroidAttributeValue<String> name = feature.getName();
            if (name == null || !"android.hardware.type.watch".equals(name.getStringValue())) continue;
            return EnumSet.of(IDevice.HardwareFeature.WATCH);
        }
        return EnumSet.noneOf(IDevice.HardwareFeature.class);
    }

    private static void setColumnWidth(JBTable deviceTable, int columnIndex, String sampleText) {
        int width = DeviceChooser.getWidth(deviceTable, sampleText);
        deviceTable.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    private static int getWidth(JBTable deviceTable, String sampleText) {
        FontMetrics metrics = deviceTable.getFontMetrics(deviceTable.getFont());
        return metrics.stringWidth(sampleText);
    }

    public void init(String[] selectedSerials) {
        this.updateTable();
        if (selectedSerials != null) {
            this.resetSelection(selectedSerials);
        }
        this.addUpdatingRequest();
    }

    private void addUpdatingRequest() {
        if (this.myRefreshingAlarm.isDisposed()) {
            return;
        }
        this.myRefreshingAlarm.cancelAllRequests();
        this.myRefreshingAlarm.addRequest(this.myUpdateRequest, 500);
    }

    private void resetSelection(String[] selectedSerials) {
        MyDeviceTableModel model = (MyDeviceTableModel)this.myDeviceTable.getModel();
        HashSet selectedSerialsSet = new HashSet();
        Collections.addAll(selectedSerialsSet, selectedSerials);
        IDevice[] myDevices = model.myDevices;
        ListSelectionModel selectionModel = this.myDeviceTable.getSelectionModel();
        boolean cleared = false;
        int n = myDevices.length;
        for (int i = 0; i < n; ++i) {
            String serialNumber = myDevices[i].getSerialNumber();
            if (!selectedSerialsSet.contains(serialNumber)) continue;
            if (!cleared) {
                selectionModel.clearSelection();
                cleared = true;
            }
            selectionModel.addSelectionInterval(i, i);
        }
    }

    void updateTable() {
        Object[] devices;
        Object[] objectArray = devices = this.myBridge != null ? this.getFilteredDevices(this.myBridge) : EMPTY_DEVICE_ARRAY;
        if (devices.length > 1) {
            Arrays.sort(devices, new Comparator<IDevice>(){

                @Override
                public int compare(IDevice device1, IDevice device2) {
                    int apiLevel1 = this.safeGetApiLevel(device1);
                    int apiLevel2 = this.safeGetApiLevel(device2);
                    return apiLevel2 - apiLevel1;
                }

                private int safeGetApiLevel(IDevice device) {
                    try {
                        String s = device.getProperty("ro.build.version.sdk");
                        return StringUtil.isNotEmpty((String)s) ? Integer.parseInt(s) : 0;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
            });
        }
        if (!Arrays.equals(this.myDisplayedDevices, devices)) {
            this.myDetectedDevicesRef.set((IDevice[])devices);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    DeviceChooser.this.refreshTable();
                }
            }, ModalityState.stateForComponent((Component)this.myDeviceTable));
        }
    }

    private void refreshTable() {
        IDevice[] devices = this.myDetectedDevicesRef.get();
        this.myDisplayedDevices = devices;
        Object[] selectedDevices = this.getSelectedDevices(false);
        TIntArrayList selectedRows = new TIntArrayList();
        for (int i = 0; i < devices.length; ++i) {
            if (ArrayUtil.indexOf((Object[])selectedDevices, (Object)devices[i]) < 0) continue;
            selectedRows.add(i);
        }
        this.myProcessSelectionFlag = false;
        this.myDeviceTable.setModel((TableModel)new MyDeviceTableModel(devices));
        if (selectedRows.size() == 0 && devices.length > 0) {
            this.myDeviceTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        for (int selectedRow : selectedRows.toNativeArray()) {
            if (selectedRow >= devices.length) continue;
            this.myDeviceTable.getSelectionModel().addSelectionInterval(selectedRow, selectedRow);
        }
        this.fireSelectedDevicesChanged();
        this.myProcessSelectionFlag = true;
    }

    public boolean hasDevices() {
        return this.myDetectedDevicesRef.get().length > 0;
    }

    public JComponent getPreferredFocusComponent() {
        return this.myDeviceTable;
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public ValidationInfo doValidate() {
        String message;
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        boolean hasIncompatible = false;
        boolean hasCompatible = false;
        for (int row : rows) {
            if (!this.isRowCompatible(row)) {
                hasIncompatible = true;
                continue;
            }
            hasCompatible = true;
        }
        if (!hasIncompatible) {
            return null;
        }
        if (hasCompatible) {
            message = "At least one of the selected devices is incompatible. Will only install on compatible devices.";
        } else {
            String devicesAre = rows.length > 1 ? "devices are" : "device is";
            message = "The selected " + devicesAre + " incompatible.";
        }
        return new ValidationInfo(message);
    }

    public IDevice[] getSelectedDevices() {
        return this.getSelectedDevices(true);
    }

    private IDevice[] getSelectedDevices(boolean onlyCompatible) {
        int[] rows = this.mySelectedRows != null ? this.mySelectedRows : this.myDeviceTable.getSelectedRows();
        ArrayList<IDevice> result = new ArrayList<IDevice>();
        block0: for (int row : rows) {
            IDevice[] devices;
            if (row < 0 || onlyCompatible && !this.isRowCompatible(row)) continue;
            Object serial = this.myDeviceTable.getValueAt(row, 3);
            AndroidDebugBridge bridge = AndroidSdkUtils.getDebugBridge(this.myFacet.getModule().getProject());
            if (bridge == null) {
                return EMPTY_DEVICE_ARRAY;
            }
            for (IDevice device : devices = this.getFilteredDevices(bridge)) {
                if (!device.getSerialNumber().equals(serial.toString())) continue;
                result.add(device);
                continue block0;
            }
        }
        return result.toArray(new IDevice[result.size()]);
    }

    private IDevice[] getFilteredDevices(AndroidDebugBridge bridge) {
        ArrayList<IDevice> filteredDevices = new ArrayList<IDevice>();
        for (IDevice device : bridge.getDevices()) {
            if (this.myFilter != null && !this.myFilter.apply((Object)device)) continue;
            filteredDevices.add(device);
        }
        if (this.myCloudConfigurationProvider != null) {
            filteredDevices.addAll(this.myCloudConfigurationProvider.getLaunchingCloudDevices());
        }
        return filteredDevices.toArray(new IDevice[filteredDevices.size()]);
    }

    private boolean isRowCompatible(int row) {
        Object compatibility = this.myDeviceTable.getValueAt(row, 2);
        return compatibility instanceof LaunchCompatibility && ((LaunchCompatibility)compatibility).isCompatible() != ThreeState.NO;
    }

    public void finish() {
        this.mySelectedRows = this.myDeviceTable.getSelectedRows();
    }

    public void dispose() {
    }

    public void setEnabled(boolean enabled) {
        this.myDeviceTable.setEnabled(enabled);
    }

    private static String getDeviceState(IDevice device) {
        IDevice.DeviceState state = device.getState();
        return state != null ? StringUtil.capitalize((String)state.name().toLowerCase()) : "";
    }

    public void fireSelectedDevicesChanged() {
        for (DeviceChooserListener listener : this.myListeners) {
            listener.selectedDevicesChanged();
        }
    }

    public void addListener(DeviceChooserListener listener) {
        this.myListeners.add(listener);
    }

    private static class LaunchCompatibilityRenderer
    extends ColoredTableCellRenderer {
        private LaunchCompatibilityRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value instanceof LaunchCompatibility)) {
                return;
            }
            LaunchCompatibility compatibility = (LaunchCompatibility)value;
            ThreeState compatible = compatibility.isCompatible();
            if (compatible == ThreeState.YES) {
                this.append("Yes");
            } else {
                if (compatible == ThreeState.NO) {
                    this.append("No", SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.append("Maybe");
                }
                String reason = compatibility.getReason();
                if (reason != null) {
                    this.append(", ");
                    this.append(reason);
                }
            }
        }
    }

    private class MyDeviceTableModel
    extends AbstractTableModel {
        private final IDevice[] myDevices;

        public MyDeviceTableModel(IDevice[] devices) {
            this.myDevices = devices;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_TITLES[column];
        }

        @Override
        public int getRowCount() {
            return this.myDevices.length;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLES.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= this.myDevices.length) {
                return null;
            }
            IDevice device = this.myDevices[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return device;
                }
                case 3: {
                    return device.getSerialNumber();
                }
                case 1: {
                    return DeviceChooser.getDeviceState(device);
                }
                case 2: {
                    return LaunchCompatibility.canRunOnDevice(DeviceChooser.this.myMinSdkVersion, DeviceChooser.this.myProjectTarget, DeviceChooser.this.myRequiredHardwareFeatures, device, null);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return LaunchCompatibility.class;
            }
            if (columnIndex == 0) {
                return IDevice.class;
            }
            return String.class;
        }
    }
}

