/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.google.common.base.Predicate;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import org.jetbrains.android.run.SimpleLogger;

final class DeviceReadyListener
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("ANDROID_DEVICE_STATE_UPDATE_QUEUE", 1000, true, null, (Disposable)this, null, false);
    private final SimpleLogger myLogger;
    private final Predicate<IDevice> myDeviceFilter;
    private final Callback myCallback;
    private final Object myFinishedLock = new Object();
    private boolean myFinished;

    public DeviceReadyListener(SimpleLogger logger, Predicate<IDevice> deviceFilter, Callback callback) {
        this.myLogger = logger;
        this.myDeviceFilter = deviceFilter;
        this.myCallback = callback;
    }

    public void deviceConnected(IDevice device) {
        if (device.getAvdName() == null || this.myDeviceFilter.apply((Object)device)) {
            this.myLogger.stdout("Device connected: " + device.getSerialNumber());
            this.myQueue.queue((Update)new MyDeviceStateUpdate(device));
        }
    }

    public void deviceDisconnected(IDevice device) {
        if (this.myDeviceFilter.apply((Object)device)) {
            this.myLogger.stdout("Device disconnected: " + device.getSerialNumber());
        }
    }

    public void deviceChanged(final IDevice device, int changeMask) {
        this.myQueue.queue(new Update(device.getSerialNumber()){

            public void run() {
                DeviceReadyListener.this.onDeviceChanged(device);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeviceChanged(IDevice device) {
        Object object = this.myFinishedLock;
        synchronized (object) {
            if (this.myFinished || !this.myDeviceFilter.apply((Object)device) || !device.isOnline()) {
                return;
            }
            if (device.getClients().length < 5 && device.getClient("android.process.acore") == null && device.getClient("com.google.android.wearable.app") == null) {
                this.myLogger.stdout(String.format("Device %1$s is online, waiting for processes to start up..", device.getName()));
                return;
            }
            this.myLogger.stdout("Device is ready: " + device.getName());
            this.myFinished = true;
        }
        Disposer.dispose((Disposable)this.myQueue);
        this.myCallback.onDeviceReady(device);
    }

    public void dispose() {
    }

    private class MyDeviceStateUpdate
    extends Update {
        private final IDevice myDevice;

        public MyDeviceStateUpdate(IDevice device) {
            super((Object)device.getSerialNumber());
            this.myDevice = device;
        }

        public void run() {
            DeviceReadyListener.this.onDeviceChanged(this.myDevice);
            DeviceReadyListener.this.myQueue.queue((Update)new MyDeviceStateUpdate(this.myDevice));
        }
    }

    static interface Callback {
        public void onDeviceReady(IDevice var1);
    }
}

