/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DeviceStateAtLaunch {
    private final Set<String> myDevicesUsedInLaunch;
    private final Set<String> myDevicesAvailableAtLaunch;

    public DeviceStateAtLaunch(Collection<IDevice> usedDevices, Collection<IDevice> allDevices) {
        this.myDevicesUsedInLaunch = DeviceStateAtLaunch.serialize(usedDevices);
        this.myDevicesAvailableAtLaunch = DeviceStateAtLaunch.serialize(allDevices);
    }

    public Collection<IDevice> filterByUsed(Collection<IDevice> devices) {
        HashSet used = Sets.newHashSetWithExpectedSize((int)this.myDevicesUsedInLaunch.size());
        for (IDevice d : devices) {
            if (!this.myDevicesUsedInLaunch.contains(d.getSerialNumber())) continue;
            used.add(d);
        }
        return used;
    }

    public boolean matchesCurrentAvailableDevices(Collection<IDevice> devices) {
        if (this.myDevicesAvailableAtLaunch.size() != devices.size()) {
            return false;
        }
        for (IDevice d : devices) {
            if (this.myDevicesAvailableAtLaunch.contains(d.getSerialNumber())) continue;
            return false;
        }
        return true;
    }

    public boolean usedDevice(IDevice device) {
        return this.myDevicesUsedInLaunch.contains(device.getSerialNumber());
    }

    private static Set<String> serialize(Collection<IDevice> usedDevices) {
        HashSet s = Sets.newHashSetWithExpectedSize((int)usedDevices.size());
        for (IDevice d : usedDevices) {
            s.add(d.getSerialNumber());
        }
        return s;
    }
}

