/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationComboBox;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.run.CloudProjectIdLabel;
import com.android.tools.idea.run.LaunchCloudDeviceDialog;
import com.android.tools.idea.run.LaunchEmulatorDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.AvdComboBox;
import org.jetbrains.android.run.DeviceChooser;
import org.jetbrains.android.run.DeviceChooserListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;

public class ExtendedDeviceChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private final DeviceChooser myDeviceChooser;
    private JPanel myPanel;
    private JRadioButton myChooserRunningDeviceRadioButton;
    private JPanel myDeviceChooserWrapper;
    private JCheckBox myReuseSelectionCheckbox;
    private JRadioButton myRunTestsInGoogleCloudRadioButton;
    private JLabel myCloudConfigurationLabel;
    private JLabel myCloudProjectLabel;
    private CloudConfigurationComboBox myCloudConfigurationCombo;
    private CloudProjectIdLabel myCloudProjectIdLabel;
    private ActionButton myCloudProjectIdUpdateButton;
    private JButton myLaunchEmulatorButton;
    private JRadioButton myLaunchEmulatorRadioButton;
    private final AvdComboBox myAvdCombo;
    private JLabel myAvdLabel;
    private JPanel myComboBoxWrapper;
    private final CloudConfigurationProvider myCloudConfigurationProvider;
    @NonNls
    private static final String SELECTED_AVD_PROPERTY = "ANDROID_EXTENDED_DEVICE_CHOOSER_AVD";
    @NonNls
    private static final String SELECTED_SERIALS_PROPERTY = "ANDROID_EXTENDED_DEVICE_CHOOSER_SERIALS";

    public ExtendedDeviceChooserDialog(final AndroidFacet facet, IAndroidTarget projectTarget, boolean multipleSelection, boolean showReuseDevicesCheckbox, boolean selectReuseDevicesCheckbox, boolean showCloudTarget, String emulatorOptions) {
        super(facet.getModule().getProject(), true, DialogWrapper.IdeModalityType.PROJECT);
        String serialsStr;
        boolean isGoogleCloudRadioButtonShown;
        this.$$$setupUI$$$();
        this.myCloudConfigurationProvider = CloudConfigurationProvider.getCloudConfigurationProvider();
        this.setTitle(AndroidBundle.message("choose.device.dialog.title", new Object[0]));
        this.myProject = facet.getModule().getProject();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        boolean bl = isGoogleCloudRadioButtonShown = CloudConfigurationProvider.isEnabled() && showCloudTarget;
        if (isGoogleCloudRadioButtonShown) {
            this.myCloudConfigurationCombo.getComboBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtendedDeviceChooserDialog.this.updateOkButton();
                }
            });
            this.myCloudConfigurationLabel.setLabelFor((Component)((Object)this.myCloudConfigurationCombo));
        }
        String[] selectedSerials = (serialsStr = properties.getValue(SELECTED_SERIALS_PROPERTY)) != null ? serialsStr.split(" ") : null;
        this.getOKAction().setEnabled(false);
        this.myDeviceChooser = new DeviceChooser(multipleSelection, this.getOKAction(), facet, projectTarget, null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myDeviceChooser);
        this.myDeviceChooser.addListener(new DeviceChooserListener(){

            @Override
            public void selectedDevicesChanged() {
                if (CloudConfigurationProvider.isEnabled()) {
                    ExtendedDeviceChooserDialog.this.myRunTestsInGoogleCloudRadioButton.setSelected(!ExtendedDeviceChooserDialog.this.myDeviceChooser.hasDevices());
                } else {
                    ExtendedDeviceChooserDialog.this.myLaunchEmulatorRadioButton.setSelected(!ExtendedDeviceChooserDialog.this.myDeviceChooser.hasDevices());
                }
                ExtendedDeviceChooserDialog.this.myChooserRunningDeviceRadioButton.setSelected(ExtendedDeviceChooserDialog.this.myDeviceChooser.hasDevices());
                ExtendedDeviceChooserDialog.this.updateEnabled();
            }
        });
        this.myAvdCombo = new AvdComboBox(this.myProject, false, true){

            @Override
            public Module getModule() {
                return facet.getModule();
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myAvdCombo);
        this.myAvdCombo.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.append(AndroidBundle.message("android.ddms.nodevices", new Object[0]), ExtendedDeviceChooserDialog.this.myAvdCombo.getComboBox().isEnabled() ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(((IdDisplay)value).getDisplay());
                }
            }
        });
        this.myComboBoxWrapper.add((Component)((Object)this.myAvdCombo));
        this.myAvdLabel.setLabelFor((Component)((Object)this.myAvdCombo));
        this.myDeviceChooserWrapper.add(this.myDeviceChooser.getPanel());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedDeviceChooserDialog.this.updateEnabled();
            }
        };
        this.myLaunchEmulatorRadioButton.addActionListener(listener);
        this.myChooserRunningDeviceRadioButton.addActionListener(listener);
        this.myRunTestsInGoogleCloudRadioButton.addActionListener(listener);
        this.myAvdCombo.getComboBox().addActionListener(listener);
        this.init();
        this.myDeviceChooser.init(selectedSerials);
        if (CloudConfigurationProvider.isEnabled()) {
            this.myChooserRunningDeviceRadioButton.setSelected(true);
        } else {
            this.myLaunchEmulatorRadioButton.setSelected(!this.myDeviceChooser.hasDevices());
            this.myChooserRunningDeviceRadioButton.setSelected(this.myDeviceChooser.hasDevices());
        }
        this.myAvdCombo.startUpdatingAvds(ModalityState.stateForComponent((Component)this.myPanel));
        String savedAvd = PropertiesComponent.getInstance((Project)this.myProject).getValue(SELECTED_AVD_PROPERTY);
        String avdToSelect = null;
        if (savedAvd != null) {
            ComboBoxModel model = this.myAvdCombo.getComboBox().getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                String id;
                IdDisplay item = (IdDisplay)model.getElementAt(i);
                String string = id = item == null ? null : item.getId();
                if (!savedAvd.equals(id)) continue;
                avdToSelect = id;
                break;
            }
        }
        if (avdToSelect != null) {
            this.myAvdCombo.getComboBox().setSelectedItem(new IdDisplay(avdToSelect, ""));
        } else if (this.myAvdCombo.getComboBox().getModel().getSize() > 0) {
            this.myAvdCombo.getComboBox().setSelectedIndex(0);
        }
        this.myLaunchEmulatorButton.setIcon(AllIcons.General.Add);
        this.myLaunchEmulatorButton.addActionListener(new LaunchDeviceActionListener(facet, emulatorOptions));
        this.myReuseSelectionCheckbox.setVisible(showReuseDevicesCheckbox);
        this.myReuseSelectionCheckbox.setSelected(selectReuseDevicesCheckbox);
        if (isGoogleCloudRadioButtonShown) {
            this.myCloudProjectIdLabel.restoreChosenProjectId();
            this.myCloudConfigurationCombo.setFacet(facet);
        }
        this.updateDialogComponentsVisibility(isGoogleCloudRadioButtonShown);
        this.updateEnabled();
        this.initValidation();
    }

    private void updateDialogComponentsVisibility(boolean isGoogleCloudRadioButtonShown) {
        if (CloudConfigurationProvider.isEnabled()) {
            this.myLaunchEmulatorRadioButton.setVisible(false);
            this.myAvdLabel.setVisible(false);
            this.myComboBoxWrapper.setVisible(false);
            this.myChooserRunningDeviceRadioButton.setVisible(isGoogleCloudRadioButtonShown);
        } else {
            this.myLaunchEmulatorButton.setVisible(false);
        }
        this.myRunTestsInGoogleCloudRadioButton.setVisible(isGoogleCloudRadioButtonShown);
        this.myCloudConfigurationCombo.setVisible(isGoogleCloudRadioButtonShown);
        this.myCloudConfigurationLabel.setVisible(isGoogleCloudRadioButtonShown);
        this.myCloudProjectLabel.setVisible(isGoogleCloudRadioButtonShown);
        this.myCloudProjectIdLabel.setVisible(isGoogleCloudRadioButtonShown);
        this.myCloudProjectIdUpdateButton.setVisible(isGoogleCloudRadioButtonShown);
    }

    private void updateOkButton() {
        if (this.myLaunchEmulatorRadioButton.isSelected()) {
            this.getOKAction().setEnabled(this.getSelectedAvd() != null);
        } else if (this.myRunTestsInGoogleCloudRadioButton.isSelected()) {
            this.getOKAction().setEnabled(this.isValidGoogleCloudSelection());
        } else {
            boolean isActionableSelection = false;
            for (IDevice selectedDevice : this.getSelectedDevices()) {
                if (this.myCloudConfigurationProvider != null && this.myCloudConfigurationProvider.getCloudDeviceConfiguration(selectedDevice) != null && selectedDevice.isOffline()) continue;
                isActionableSelection = true;
                break;
            }
            this.getOKAction().setEnabled(isActionableSelection);
        }
    }

    private boolean isValidGoogleCloudSelection() {
        CloudConfiguration selection = (CloudConfiguration)this.myCloudConfigurationCombo.getComboBox().getSelectedItem();
        return selection != null && selection.getDeviceConfigurationCount() > 0 && this.myCloudProjectIdLabel.isProjectSpecified();
    }

    private void updateEnabled() {
        this.myCloudConfigurationCombo.setEnabled(this.myRunTestsInGoogleCloudRadioButton.isSelected());
        this.myCloudConfigurationLabel.setEnabled(this.myRunTestsInGoogleCloudRadioButton.isSelected());
        this.myCloudProjectLabel.setEnabled(this.myRunTestsInGoogleCloudRadioButton.isSelected());
        this.myCloudProjectIdLabel.setEnabled(this.myRunTestsInGoogleCloudRadioButton.isSelected());
        this.myCloudProjectIdUpdateButton.setEnabled(this.myRunTestsInGoogleCloudRadioButton.isSelected());
        this.myAvdCombo.setEnabled(this.myLaunchEmulatorRadioButton.isSelected());
        this.myAvdLabel.setEnabled(this.myLaunchEmulatorRadioButton.isSelected());
        this.myDeviceChooser.setEnabled(this.myChooserRunningDeviceRadioButton.isSelected());
        this.myLaunchEmulatorButton.setEnabled(this.myChooserRunningDeviceRadioButton.isSelected() || !this.myChooserRunningDeviceRadioButton.isVisible());
        this.updateOkButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeviceChooser.getPreferredFocusComponent();
    }

    protected String getHelpId() {
        return "reference.android.chooseDevice";
    }

    protected void doOKAction() {
        this.myDeviceChooser.finish();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        properties.setValue(SELECTED_SERIALS_PROPERTY, AndroidRunningState.toString(this.getSelectedDevices()));
        IdDisplay selectedAvd = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedAvd != null) {
            properties.setValue(SELECTED_AVD_PROPERTY, selectedAvd.getId());
        } else {
            properties.unsetValue(SELECTED_AVD_PROPERTY);
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidExtendedDeviceChooserDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected ValidationInfo doValidate() {
        return this.myDeviceChooser.doValidate();
    }

    protected Alarm.ThreadToUse getValidationThreadToUse() {
        return Alarm.ThreadToUse.POOLED_THREAD;
    }

    public IDevice[] getSelectedDevices() {
        return this.myDeviceChooser.getSelectedDevices();
    }

    public String getSelectedAvd() {
        IdDisplay value = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        return value == null ? null : value.getId();
    }

    public boolean isToLaunchEmulator() {
        return this.myLaunchEmulatorRadioButton.isSelected();
    }

    public boolean isCloudTestOptionSelected() {
        return this.myRunTestsInGoogleCloudRadioButton.isSelected();
    }

    public int getSelectedMatrixConfigurationId() {
        CloudConfiguration selection = (CloudConfiguration)this.myCloudConfigurationCombo.getComboBox().getSelectedItem();
        if (selection == null) {
            return -1;
        }
        return selection.getId();
    }

    public String getChosenCloudProjectId() {
        return this.myCloudProjectIdLabel.getText();
    }

    public boolean useSameDevicesAgain() {
        return this.myReuseSelectionCheckbox.isSelected();
    }

    private void createUIComponents() {
        this.myCloudProjectIdLabel = new CloudProjectIdLabel(CloudConfiguration.Kind.MATRIX);
        AnAction action = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (ExtendedDeviceChooserDialog.this.myCloudConfigurationProvider == null) {
                    return;
                }
                String selectedProjectId = ExtendedDeviceChooserDialog.this.myCloudConfigurationProvider.openCloudProjectConfigurationDialog(ExtendedDeviceChooserDialog.this.myProject, ExtendedDeviceChooserDialog.this.myCloudProjectIdLabel.getText());
                if (selectedProjectId != null) {
                    ExtendedDeviceChooserDialog.this.myCloudProjectIdLabel.updateCloudProjectId(selectedProjectId);
                    ExtendedDeviceChooserDialog.this.updateOkButton();
                }
            }

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                presentation.setIcon(AllIcons.General.Settings);
            }
        };
        this.myCloudProjectIdUpdateButton = new ActionButton(action, new PresentationFactory().getPresentation(action), "MyPlace", (Dimension)JBUI.size((int)25, (int)25));
        this.myCloudConfigurationCombo = new CloudConfigurationComboBox(CloudConfiguration.Kind.MATRIX);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myCloudConfigurationCombo);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JButton jButton;
        JLabel jLabel2;
        JLabel jLabel3;
        JRadioButton jRadioButton3;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeviceChooserWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myReuseSelectionCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use same device for future launches");
        jPanel3.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRunTestsInGoogleCloudRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setLabel("Choose a cloud device matrix");
        jRadioButton3.setText("Choose a cloud device matrix");
        jRadioButton3.setMnemonic('M');
        jRadioButton3.setDisplayedMnemonicIndex(22);
        jPanel3.add((Component)jRadioButton3, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCloudConfigurationLabel = jLabel3 = new JLabel();
        jLabel3.setText("Matrix configuration:");
        jLabel3.setDisplayedMnemonic('M');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        CloudConfigurationComboBox cloudConfigurationComboBox = this.myCloudConfigurationCombo;
        jPanel3.add((Component)((Object)cloudConfigurationComboBox), new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCloudProjectLabel = jLabel2 = new JLabel();
        jLabel2.setText("Cloud project:");
        jPanel3.add((Component)jLabel2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(6, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 5, 5));
        jPanel4.add((Component)jPanel5, "West");
        CloudProjectIdLabel cloudProjectIdLabel = this.myCloudProjectIdLabel;
        Component component = jPanel5.add((Component)((Object)cloudProjectIdLabel));
        ActionButton actionButton = this.myCloudProjectIdUpdateButton;
        Component component2 = jPanel5.add((Component)actionButton);
        this.myLaunchEmulatorButton = jButton = new JButton();
        jButton.setToolTipText("Launch a Device");
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myChooserRunningDeviceRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.running.device.radio"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLaunchEmulatorRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.launch.emulator.radio"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAvdLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.avd.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myComboBoxWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class LaunchDeviceActionListener
    implements ActionListener {
        private static final String EMULATOR = "Local Emulator";
        private static final String CLOUD_DEVICE = "Cloud Device";
        private final AndroidFacet myFacet;
        private final String myEmulatorOptions;

        public LaunchDeviceActionListener(AndroidFacet facet, String emulatorOptions) {
            this.myFacet = facet;
            this.myEmulatorOptions = emulatorOptions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!CloudConfigurationProvider.isEnabled()) {
                this.promptToLaunchEmulator();
                return;
            }
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Launch a Device", new String[]{EMULATOR, CLOUD_DEVICE}){

                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    if (selectedValue.equals(LaunchDeviceActionListener.EMULATOR)) {
                        this.doFinalStep(new Runnable(){

                            @Override
                            public void run() {
                                LaunchDeviceActionListener.this.promptToLaunchEmulator();
                            }
                        });
                    } else if (selectedValue.equals(LaunchDeviceActionListener.CLOUD_DEVICE)) {
                        this.doFinalStep(new Runnable(){

                            @Override
                            public void run() {
                                LaunchDeviceActionListener.this.promptToLaunchCloudDevice();
                            }
                        });
                    }
                    return FINAL_CHOICE;
                }
            });
            popup.showUnderneathOf((Component)ExtendedDeviceChooserDialog.this.myLaunchEmulatorButton);
        }

        private void promptToLaunchEmulator() {
            String avdName;
            LaunchEmulatorDialog dialog = new LaunchEmulatorDialog(this.myFacet);
            dialog.show();
            if (dialog.isOK() && (avdName = dialog.getSelectedAvd()) != null) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        LaunchDeviceActionListener.this.myFacet.launchEmulator(avdName, LaunchDeviceActionListener.this.myEmulatorOptions);
                    }
                });
            }
        }

        private void promptToLaunchCloudDevice() {
            final LaunchCloudDeviceDialog dialog = new LaunchCloudDeviceDialog(this.myFacet);
            dialog.show();
            if (dialog.isOK()) {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedDeviceChooserDialog.this.myCloudConfigurationProvider.launchCloudDevice(dialog.getSelectedMatrixConfigurationId(), dialog.getChosenCloudProjectId(), LaunchDeviceActionListener.this.myFacet);
                    }
                });
            }
        }
    }
}

