/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.ddmlib.IDevice;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.ActivityLocator;
import org.jetbrains.android.run.AndroidRunConfigurationBase;
import org.jetbrains.android.run.DefaultActivityLocator;
import org.jetbrains.android.util.AndroidUtils;

public class MavenDefaultActivityLocator
extends ActivityLocator {
    private final AndroidFacet myFacet;

    public MavenDefaultActivityLocator(AndroidFacet facet) {
        this.myFacet = facet;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getQualifiedActivityName(IDevice device) throws ActivityLocator.ActivityLocatorException {
        File manifestCopy = null;
        try {
            Manifest manifest;
            Pair<File, String> pair;
            try {
                pair = AndroidRunConfigurationBase.getCopyOfCompilerManifestFile(this.myFacet);
            }
            catch (IOException e) {
                throw new ActivityLocator.ActivityLocatorException("Error while obtaining compiler manifest file", e);
            }
            manifestCopy = pair != null ? (File)pair.getFirst() : null;
            VirtualFile manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().findFileByIoFile(manifestCopy) : null;
            Manifest manifest2 = manifest = manifestVFile == null ? null : AndroidUtils.loadDomElement(this.myFacet.getModule(), manifestVFile, Manifest.class);
            if (manifest == null) {
                throw new ActivityLocator.ActivityLocatorException("Cannot find AndroidManifest.xml file");
            }
            String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return DefaultActivityLocator.getDefaultLauncherActivityName(manifest);
                }
            });
            return string;
        }
        finally {
            if (manifestCopy != null) {
                FileUtil.delete((File)manifestCopy.getParentFile());
            }
        }
    }
}

