/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;

class AndroidSdkConfigurableForm {
    private JComboBox myInternalJdkComboBox;
    private JPanel myContentPanel;
    private JComboBox myBuildTargetComboBox;
    private final DefaultComboBoxModel myJdksModel;
    private final SdkModel mySdkModel;
    private final DefaultComboBoxModel myBuildTargetsModel;
    private String mySdkLocation;
    private boolean myFreeze;

    public AndroidSdkConfigurableForm(SdkModel sdkModel, final SdkModificator sdkModificator) {
        this.$$$setupUI$$$();
        this.myJdksModel = new DefaultComboBoxModel();
        this.myBuildTargetsModel = new DefaultComboBoxModel();
        this.myFreeze = false;
        this.mySdkModel = sdkModel;
        this.myInternalJdkComboBox.setModel(this.myJdksModel);
        this.myInternalJdkComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof Sdk) {
                    this.setText(((Sdk)value).getName());
                }
            }
        });
        this.myBuildTargetComboBox.setModel(this.myBuildTargetsModel);
        this.myBuildTargetComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof IAndroidTarget) {
                    this.setText(AndroidSdkUtils.getTargetPresentableName((IAndroidTarget)value));
                } else if (value == null) {
                    this.setText("<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>[none]</font></html>");
                }
            }
        });
        this.myBuildTargetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AndroidSdkConfigurableForm.this.myFreeze) {
                    return;
                }
                IAndroidTarget target = (IAndroidTarget)e.getItem();
                List<OrderRoot> roots = AndroidSdkUtils.getLibraryRootsForTarget(target, AndroidSdkConfigurableForm.this.mySdkLocation, true);
                HashMap configuredRoots = new HashMap();
                for (OrderRootType type : OrderRootType.getAllTypes()) {
                    if (!AndroidSdkType.getInstance().isRootTypeApplicable(type)) continue;
                    VirtualFile[] oldRoots = sdkModificator.getRoots(type);
                    String[] oldRootPaths = new String[oldRoots.length];
                    for (int i = 0; i < oldRootPaths.length; ++i) {
                        oldRootPaths[i] = oldRoots[i].getPath();
                    }
                    configuredRoots.put(type, oldRootPaths);
                }
                for (OrderRoot root : roots) {
                    if (e.getStateChange() == 2) {
                        sdkModificator.removeRoot(root.getFile(), root.getType());
                        continue;
                    }
                    Object[] configuredRootsForType = (String[])configuredRoots.get(root.getType());
                    if (ArrayUtil.find((Object[])configuredRootsForType, (Object)root.getFile().getPath()) != -1) continue;
                    sdkModificator.addRoot(root.getFile(), root.getType());
                }
            }
        });
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public Sdk getSelectedSdk() {
        return (Sdk)this.myInternalJdkComboBox.getSelectedItem();
    }

    public IAndroidTarget getSelectedBuildTarget() {
        return (IAndroidTarget)this.myBuildTargetComboBox.getSelectedItem();
    }

    public void init(Sdk jdk, Sdk androidSdk, IAndroidTarget buildTarget) {
        String jdkName;
        this.updateJdks();
        String string = jdkName = jdk != null ? jdk.getName() : null;
        if (androidSdk != null) {
            for (int i = 0; i < this.myJdksModel.getSize(); ++i) {
                if (!Comparing.strEqual((String)((Sdk)this.myJdksModel.getElementAt(i)).getName(), (String)jdkName)) continue;
                this.myInternalJdkComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.mySdkLocation = androidSdk != null ? androidSdk.getHomePath() : null;
        AndroidSdkData androidSdkData = this.mySdkLocation != null ? AndroidSdkData.getSdkData(this.mySdkLocation) : null;
        this.myFreeze = true;
        this.updateBuildTargets(androidSdkData, buildTarget);
        this.myFreeze = false;
    }

    private void updateJdks() {
        this.myJdksModel.removeAllElements();
        for (Sdk sdk : this.mySdkModel.getSdks()) {
            if (!Jdks.isApplicableJdk(sdk)) continue;
            this.myJdksModel.addElement(sdk);
        }
    }

    private void updateBuildTargets(AndroidSdkData androidSdkData, IAndroidTarget buildTarget) {
        this.myBuildTargetsModel.removeAllElements();
        if (androidSdkData != null) {
            for (IAndroidTarget target : androidSdkData.getTargets()) {
                this.myBuildTargetsModel.addElement(target);
            }
        }
        if (buildTarget != null) {
            for (int i = 0; i < this.myBuildTargetsModel.getSize(); ++i) {
                IAndroidTarget target = (IAndroidTarget)this.myBuildTargetsModel.getElementAt(i);
                if (!buildTarget.hashString().equals(target.hashString())) continue;
                this.myBuildTargetComboBox.setSelectedIndex(i);
                return;
            }
        }
        this.myBuildTargetComboBox.setSelectedItem(null);
    }

    public void addJavaSdk(Sdk sdk) {
        this.myJdksModel.addElement(sdk);
    }

    public void removeJavaSdk(Sdk sdk) {
        this.myJdksModel.removeElement(sdk);
    }

    public void updateJdks(Sdk sdk, String previousName) {
        Sdk[] sdks;
        for (Sdk currentSdk : sdks = this.mySdkModel.getSdks()) {
            Sdk internalJava;
            if (currentSdk == null || !AndroidSdkUtils.isAndroidSdk(currentSdk)) continue;
            AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(currentSdk);
            Sdk sdk2 = internalJava = data != null ? data.getJavaSdk() : null;
            if (internalJava == null || !Comparing.equal((String)internalJava.getName(), (String)previousName)) continue;
            data.setJavaSdk(sdk);
        }
        this.updateJdks();
    }

    public void internalJdkUpdate(Sdk sdk) {
        AndroidSdkAdditionalData data = AndroidSdkUtils.getAndroidSdkAdditionalData(sdk);
        if (data == null) {
            return;
        }
        Sdk javaSdk = data.getJavaSdk();
        if (this.myJdksModel.getIndexOf(javaSdk) == -1) {
            this.myJdksModel.addElement(javaSdk);
        } else {
            this.myJdksModel.setSelectedItem(javaSdk);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Java SDK:");
        jLabel.setDisplayedMnemonic('J');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInternalJdkComboBox = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Build target:");
        jLabel2.setDisplayedMnemonic('B');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBuildTargetComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

