/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidCommonUtils;

public class AndroidSdkData {
    private final Map<IAndroidTarget, SoftReference<AndroidTargetData>> myTargetDataByTarget = Maps.newHashMap();
    private final LocalSdk myLocalSdk;
    private final DeviceManager myDeviceManager;
    private final int myPlatformToolsRevision;
    private final int mySdkToolsRevision;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();

    public static AndroidSdkData getSdkData(File sdkLocation) {
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    public static AndroidSdkData getSdkData(File sdkLocation, boolean forceReparse) {
        File canonicalLocation;
        SoftReference cachedRef;
        String canonicalPath = FileUtil.toCanonicalPath((String)sdkLocation.getPath());
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        if (!IdeSdks.isValidAndroidSdkPath(canonicalLocation = new File(canonicalPath))) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(new LocalSdk(canonicalLocation));
        ourCache.put(canonicalPath, (SoftReference<AndroidSdkData>)new SoftReference((Object)sdkData));
        return sdkData;
    }

    public static AndroidSdkData getSdkData(String sdkPath) {
        File file = new File(FileUtil.toSystemDependentName((String)sdkPath));
        return AndroidSdkData.getSdkData(file);
    }

    public static AndroidSdkData getSdkData(Sdk sdk) {
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath != null) {
            return AndroidSdkData.getSdkData(sdk.getHomePath());
        }
        return null;
    }

    public static AndroidSdkData getSdkData(Project project) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk != null) {
            return AndroidSdkData.getSdkData(sdk);
        }
        return null;
    }

    public static AndroidSdkData getSdkData(Module module) {
        return AndroidSdkData.getSdkData(module.getProject());
    }

    private AndroidSdkData(LocalSdk localSdk) {
        this.myLocalSdk = localSdk;
        File location = this.getLocation();
        String locationPath = location.getPath();
        this.myPlatformToolsRevision = AndroidCommonUtils.parsePackageRevision((String)locationPath, (String)"platform-tools");
        this.mySdkToolsRevision = AndroidCommonUtils.parsePackageRevision((String)locationPath, (String)"tools");
        this.myDeviceManager = DeviceManager.createInstance((File)location, (ILogger)new MessageBuildingSdkLog());
    }

    public File getLocation() {
        File location = this.myLocalSdk.getLocation();
        assert (location != null);
        return location;
    }

    @Deprecated
    public String getPath() {
        return this.getLocation().getPath();
    }

    public BuildToolInfo getLatestBuildTool() {
        return this.myLocalSdk.getLatestBuildTool();
    }

    public IAndroidTarget[] getTargets() {
        return this.myLocalSdk.getTargets();
    }

    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        LocalPkgInfo[] pkgsInfos;
        if (includeAddOns) {
            return this.myLocalSdk.getTargets();
        }
        ArrayList result = Lists.newArrayList();
        for (LocalPkgInfo info : pkgsInfos = this.myLocalSdk.getPkgsInfos(EnumSet.of(PkgType.PKG_PLATFORM))) {
            IAndroidTarget target;
            if (!(info instanceof LocalPlatformPkgInfo) || (target = ((LocalPlatformPkgInfo)info).getAndroidTarget()) == null) continue;
            result.add(target);
        }
        return result.toArray(new IAndroidTarget[result.size()]);
    }

    public IAndroidTarget findTargetByName(String name) {
        for (IAndroidTarget target : this.getTargets()) {
            if (!target.getName().equals(name)) continue;
            return target;
        }
        return null;
    }

    public IAndroidTarget findTargetByApiLevel(String apiLevel) {
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkUtils.targetHasId(target, apiLevel)) continue;
            return target;
        }
        return null;
    }

    public IAndroidTarget findTargetByHashString(String hashString) {
        return this.myLocalSdk.getTargetFromHashString(hashString);
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public int getSdkToolsRevision() {
        return this.mySdkToolsRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return FileUtil.filesEqual((File)this.getLocation(), (File)sdkData.getLocation());
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.getLocation());
    }

    public LocalSdk getLocalSdk() {
        return this.myLocalSdk;
    }

    public DeviceManager getDeviceManager() {
        return this.myDeviceManager;
    }

    public AndroidTargetData getTargetData(IAndroidTarget target) {
        AndroidTargetData targetData;
        SoftReference<AndroidTargetData> targetDataRef = this.myTargetDataByTarget.get(target);
        AndroidTargetData androidTargetData = targetData = targetDataRef != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(this, target);
            this.myTargetDataByTarget.put(target, (SoftReference<AndroidTargetData>)new SoftReference((Object)targetData));
        }
        return targetData;
    }
}

