/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationToolBar;
import com.android.tools.idea.configurations.OverlayContainer;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.configurations.RenderOptionsMenuBuilder;
import com.android.tools.idea.rendering.HoverOverlay;
import com.android.tools.idea.rendering.IncludeOverlay;
import com.android.tools.idea.rendering.Overlay;
import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderedImage;
import com.android.tools.idea.rendering.RenderedViewHierarchy;
import com.android.tools.idea.rendering.SaveScreenshotAction;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewPanel;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowManager;
import org.jetbrains.android.util.AndroidBundle;

public class AndroidLayoutPreviewToolWindowForm
implements Disposable,
ConfigurationListener,
RenderContext,
OverlayContainer,
ResourceFolderManager.ResourceFolderListener {
    private JPanel myContentPanel;
    private AndroidLayoutPreviewPanel myPreviewPanel;
    private JBScrollPane myScrollPane;
    private JPanel mySecondToolBarPanel;
    private JPanel myFirstToolbarPanel;
    private PsiFile myFile;
    private Configuration myConfiguration;
    private AndroidFacet myFacet;
    private final AndroidLayoutPreviewToolWindowManager myToolWindowManager;
    private final ActionToolbar myActionToolBar;
    private final HoverOverlay myHover;
    private final List<Overlay> myOverlays;

    public AndroidLayoutPreviewToolWindowForm(AndroidLayoutPreviewToolWindowManager toolWindowManager) {
        this(toolWindowManager, null);
    }

    public AndroidLayoutPreviewToolWindowForm(AndroidLayoutPreviewToolWindowManager toolWindowManager, AnAction refreshRenderAction) {
        this.$$$setupUI$$$();
        this.myHover = new HoverOverlay(this);
        this.myOverlays = Arrays.asList(this.myHover, new IncludeOverlay(this));
        Disposer.register((Disposable)this, (Disposable)this.myPreviewPanel);
        this.myToolWindowManager = toolWindowManager;
        if (refreshRenderAction == null) {
            refreshRenderAction = new RefreshRenderAction(this);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new ZoomToFitAction());
        actionGroup.add((AnAction)new ZoomActualAction());
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ZoomInAction());
        actionGroup.add((AnAction)new ZoomOutAction());
        actionGroup.addSeparator();
        actionGroup.add(refreshRenderAction);
        actionGroup.add((AnAction)new SaveScreenshotAction(this));
        this.myActionToolBar = ActionManager.getInstance().createActionToolbar("LayoutPreview", (ActionGroup)actionGroup, true);
        this.myActionToolBar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar optionsToolBar = RenderOptionsMenuBuilder.create(this).addPreferXmlOption().addHideOption().addDeviceFrameOption().addRetinaOption().build();
        JComponent toolbar = this.myActionToolBar.getComponent();
        ConfigurationToolBar configToolBar = new ConfigurationToolBar(this);
        this.myFirstToolbarPanel.add((Component)configToolBar, "Center");
        this.mySecondToolBarPanel.add((Component)optionsToolBar.getComponent(), "East");
        this.mySecondToolBarPanel.add((Component)toolbar, "Center");
        this.myContentPanel.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                AndroidLayoutPreviewToolWindowForm.this.myPreviewPanel.updateImageSize();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.myScrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.myPreviewPanel.setOverlayContainer(this);
        this.myPreviewPanel.installHover(this.myHover);
        this.myPreviewPanel.setRenderContext(this);
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public boolean setFile(PsiFile file) {
        boolean fileChanged = !Comparing.equal((Object)this.myFile, (Object)file);
        this.myFile = file;
        if (fileChanged) {
            VirtualFile virtualFile;
            if (this.myConfiguration != null) {
                this.myConfiguration.removeListener(this);
                this.myConfiguration = null;
            }
            if (this.myFacet != null) {
                this.myFacet.getResourceFolderManager().removeListener(this);
            }
            if (file != null && (virtualFile = file.getVirtualFile()) != null) {
                this.myFacet = AndroidFacet.getInstance((PsiElement)file);
                if (this.myFacet != null) {
                    this.myFacet.getResourceFolderManager().removeListener(this);
                    this.myFacet.getResourceFolderManager().addListener(this);
                    ConfigurationManager manager = this.myFacet.getConfigurationManager();
                    this.myConfiguration = manager.getConfiguration(virtualFile);
                    this.myConfiguration.removeListener(this);
                    this.myConfiguration.addListener(this);
                }
            }
        }
        return true;
    }

    private void saveState() {
        if (this.myConfiguration != null) {
            this.myConfiguration.save();
        }
    }

    public void dispose() {
    }

    public RenderResult getRenderResult() {
        return this.myPreviewPanel.getRenderResult();
    }

    public void setRenderResult(RenderResult renderResult, TextEditor editor) {
        this.myPreviewPanel.setRenderResult(renderResult, editor);
    }

    public AndroidLayoutPreviewPanel getPreviewPanel() {
        return this.myPreviewPanel;
    }

    public void updatePreviewPanel() {
        this.myPreviewPanel.update();
    }

    @Override
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        if (configuration != this.myConfiguration) {
            if (this.myConfiguration != null) {
                this.myConfiguration.removeListener(this);
            }
            this.myConfiguration = configuration;
            this.myConfiguration.addListener(this);
            this.changed(65535);
        }
    }

    @Override
    public void requestRender() {
        if (this.myFile != null) {
            this.myToolWindowManager.render();
            this.myToolWindowManager.flush();
            this.myPreviewPanel.update();
        }
    }

    @Override
    public RenderContext.UsageType getType() {
        return RenderContext.UsageType.XML_PREVIEW;
    }

    @Override
    public XmlFile getXmlFile() {
        if (this.myFile instanceof XmlFile) {
            return (XmlFile)this.myFile;
        }
        return null;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myFile != null ? this.myFile.getVirtualFile() : null;
    }

    @Override
    public Module getModule() {
        AndroidFacet facet;
        if (this.myFile != null && (facet = AndroidFacet.getInstance((PsiElement)this.myFile)) != null) {
            return facet.getModule();
        }
        return null;
    }

    @Override
    public boolean hasAlphaChannel() {
        return this.myPreviewPanel.hasAlphaChannel();
    }

    @Override
    public Component getComponent() {
        return this.myPreviewPanel.getRenderComponent();
    }

    @Override
    public void updateLayout() {
        this.myPreviewPanel.update();
        this.myPreviewPanel.getRenderComponent().repaint();
    }

    @Override
    public void setDeviceFramesEnabled(boolean on) {
        this.myPreviewPanel.setDeviceFramesEnabled(on);
    }

    @Override
    public BufferedImage getRenderedImage() {
        RenderedImage renderedImage;
        RenderResult result = this.myPreviewPanel.getRenderResult();
        if (result != null && (renderedImage = result.getImage()) != null) {
            return renderedImage.getOriginalImage();
        }
        return null;
    }

    @Override
    public RenderResult getLastResult() {
        return this.myPreviewPanel.getRenderResult();
    }

    @Override
    public RenderedViewHierarchy getViewHierarchy() {
        RenderResult result = this.myPreviewPanel.getRenderResult();
        if (result != null) {
            return result.getHierarchy();
        }
        return null;
    }

    @Override
    public Dimension getFullImageSize() {
        return this.myPreviewPanel.getFullImageSize();
    }

    @Override
    public Dimension getScaledImageSize() {
        return this.myPreviewPanel.getScaledImageSize();
    }

    @Override
    public Rectangle getClientArea() {
        return this.myScrollPane.getViewport().getViewRect();
    }

    @Override
    public boolean supportsPreviews() {
        return true;
    }

    @Override
    public RenderPreviewManager getPreviewManager(boolean createIfNecessary) {
        return this.myPreviewPanel.getPreviewManager(this, createIfNecessary);
    }

    @Override
    public void setMaxSize(int width, int height) {
        this.myPreviewPanel.setMaxSize(width, height);
    }

    @Override
    public void zoomFit(boolean onlyZoomOut, boolean allowZoomIn) {
        this.myPreviewPanel.setZoomToFit(true);
    }

    @Override
    public Rectangle fromModel(Component target, Rectangle rectangle) {
        assert (this.myPreviewPanel != null);
        assert (target == this.myPreviewPanel.getPaintComponent().getParent());
        Rectangle converted = this.myPreviewPanel.fromModelToScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return converted != null ? converted : rectangle;
    }

    @Override
    public Rectangle toModel(Component source, Rectangle rectangle) {
        assert (this.myPreviewPanel != null);
        assert (source == this.myPreviewPanel.getPaintComponent().getParent());
        Rectangle converted = this.myPreviewPanel.fromScreenToModel(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return converted != null ? converted : rectangle;
    }

    @Override
    public List<Overlay> getOverlays() {
        return this.myOverlays;
    }

    @Override
    public boolean isSelected(XmlTag tag) {
        return this.myPreviewPanel.isSelected(tag);
    }

    public JPanel getSecondToolBarPanel() {
        return this.mySecondToolBarPanel;
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myPreviewPanel.setUseInteractiveSelector(useInteractiveSelector);
    }

    @Override
    public boolean changed(int flags) {
        this.saveState();
        this.myToolWindowManager.render();
        RenderPreviewManager previewManager = this.myPreviewPanel.getPreviewManager(this, false);
        if (previewManager != null) {
            previewManager.configurationChanged(flags);
        }
        return true;
    }

    @Override
    public void resourceFoldersChanged(final AndroidFacet facet, final List<VirtualFile> folders, final Collection<VirtualFile> added, final Collection<VirtualFile> removed) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidLayoutPreviewToolWindowForm.this.resourceFoldersChanged(facet, folders, added, removed);
                }
            });
            return;
        }
        this.myToolWindowManager.render();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        AndroidLayoutPreviewPanel androidLayoutPreviewPanel;
        JBScrollPane jBScrollPane;
        JPanel jPanel3;
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(20);
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel3.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myPreviewPanel = androidLayoutPreviewPanel = new AndroidLayoutPreviewPanel();
        jBScrollPane.setViewportView(androidLayoutPreviewPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 3, null, null, null));
        this.myFirstToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setOpaque(false);
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.mySecondToolBarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setOpaque(false);
        jPanel4.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 4, 2, 7, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private class ZoomToFitAction
    extends ToggleAction {
        ZoomToFitAction() {
            super(AndroidBundle.message("android.layout.preview.zoom.to.fit.action.text", new Object[0]), null, AndroidIcons.ZoomFit);
        }

        public boolean isSelected(AnActionEvent e) {
            return AndroidLayoutPreviewToolWindowForm.this.myPreviewPanel.isZoomToFit();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            AndroidLayoutPreviewToolWindowForm.this.myPreviewPanel.setZoomToFit(state);
            AndroidLayoutPreviewToolWindowForm.this.myActionToolBar.updateActionsImmediately();
        }
    }

    private class ZoomActualAction
    extends AnAction {
        ZoomActualAction() {
            super(AndroidBundle.message("android.layout.preview.zoom.actual.action.text", new Object[0]), null, AndroidIcons.ZoomActual);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLayoutPreviewToolWindowForm.this.myPreviewPanel.zoomActual();
            AndroidLayoutPreviewToolWindowForm.this.myActionToolBar.updateActionsImmediately();
        }
    }

    private class ZoomOutAction
    extends AnAction {
        ZoomOutAction() {
            super(AndroidBundle.message("android.layout.preview.zoom.out.action.text", new Object[0]), null, AndroidIcons.ZoomOut);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLayoutPreviewToolWindowForm.this.myPreviewPanel.zoomOut();
            AndroidLayoutPreviewToolWindowForm.this.myActionToolBar.updateActionsImmediately();
        }
    }

    private class ZoomInAction
    extends AnAction {
        ZoomInAction() {
            super(AndroidBundle.message("android.layout.preview.zoom.in.action.text", new Object[0]), null, AndroidIcons.ZoomIn);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLayoutPreviewToolWindowForm.this.myPreviewPanel.zoomIn();
            AndroidLayoutPreviewToolWindowForm.this.myActionToolBar.updateActionsImmediately();
        }
    }
}

