/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowForm;

class AndroidPreviewProgressIndicator
extends ProgressIndicatorBase {
    private final Object myLock = new Object();
    private final int myDelay;
    private final AndroidLayoutPreviewToolWindowForm myForm;

    AndroidPreviewProgressIndicator(AndroidLayoutPreviewToolWindowForm form, int delay) {
        this.myDelay = delay;
        this.myForm = form;
    }

    public void start() {
        super.start();
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                Timer timer = UIUtil.createNamedTimer((String)"Android rendering progress timer", (int)AndroidPreviewProgressIndicator.this.myDelay, (ActionListener)new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object object = AndroidPreviewProgressIndicator.this.myLock;
                        synchronized (object) {
                            if (AndroidPreviewProgressIndicator.this.isRunning()) {
                                AndroidPreviewProgressIndicator.this.myForm.getPreviewPanel().registerIndicator((ProgressIndicator)AndroidPreviewProgressIndicator.this);
                            }
                        }
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.myLock;
        synchronized (object) {
            super.stop();
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AndroidPreviewProgressIndicator.this.myForm.getPreviewPanel().unregisterIndicator((ProgressIndicator)AndroidPreviewProgressIndicator.this);
                }
            });
        }
    }
}

