/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.rendering.AarResourceClassRegistry;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.RenderClassLoader;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.WeakHashMap;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.RecyclerViewHelper;

public final class ModuleClassLoader
extends RenderClassLoader {
    private static final Logger LOG = Logger.getInstance(ModuleClassLoader.class);
    public static final boolean DEBUG_CLASS_LOADING = false;
    private final Module myModule;
    private final LayoutLibrary myLibrary;
    private Map<String, File> myClassFiles;
    private Map<String, Long> myLoadedTimestamp;
    private static WeakHashMap<Module, ModuleClassLoader> ourCache = new WeakHashMap();

    private ModuleClassLoader(LayoutLibrary library, Module module) {
        super(library.getClassLoader());
        this.myLibrary = library;
        this.myModule = module;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            int index;
            if (!(this.myInsideJarClassLoader || (index = name.lastIndexOf(46)) == -1 || name.charAt(index + 1) != 'R' || index != name.length() - 2 && name.charAt(index + 2) != '$' || index <= 1)) {
                byte[] data;
                AppResourceRepository appResources = AppResourceRepository.getAppResources(this.myModule, false);
                if (appResources != null && (data = AarResourceClassRegistry.get(this.myModule.getProject()).findClassDefinition(name, appResources)) != null) {
                    data = this.convertClass(data);
                    return this.defineClassAndPackage(name, data, 0, data.length);
                }
                throw e;
            }
            byte[] clazz = null;
            if ("com.android.layoutlib.bridge.android.support.Adapter".equals(name)) {
                clazz = RecyclerViewHelper.getAdapterClass();
            }
            if ("com.android.layoutlib.bridge.android.support.Adapter$ViewHolder".equals(name)) {
                clazz = RecyclerViewHelper.getViewHolder();
            }
            if (clazz != null) {
                return this.defineClassAndPackage(name, clazz, 0, clazz.length);
            }
            throw e;
        }
    }

    public static ClassLoader create(IAndroidTarget target, Module module) throws Exception {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(module);
        if (androidPlatform == null) {
            return null;
        }
        AndroidTargetData targetData = androidPlatform.getSdkData().getTargetData(target);
        LayoutLibrary library = targetData.getLayoutLibrary(module.getProject());
        if (library == null) {
            return null;
        }
        return ModuleClassLoader.get(library, module);
    }

    @Override
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> aClass = this.loadClassFromModuleOrDependency(this.myModule, name, (Set<Module>)new HashSet());
        if (aClass == null) {
            aClass = this.loadClassFromJar(name);
        }
        if (aClass != null) {
            return aClass;
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadClassFromModuleOrDependency(Module module, String name, Set<Module> visited) {
        if (!visited.add(module)) {
            return null;
        }
        Class<?> aClass = this.loadClassFromModule(module, name);
        if (aClass != null) {
            return aClass;
        }
        for (Module depModule : ModuleRootManager.getInstance((Module)module).getDependencies(false)) {
            aClass = this.loadClassFromModuleOrDependency(depModule, name, visited);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    private Class<?> loadClassFromModule(Module module, String name) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        VirtualFile vOutFolder = extension.getCompilerOutputPath();
        if (vOutFolder == null) {
            AndroidGradleModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && facet.requiresAndroidModel() && (androidModel = AndroidGradleModel.get(facet)) != null) {
                Class<?> localClass;
                File outFolder;
                Variant variant = androidModel.getSelectedVariant();
                String variantName = variant.getName();
                AndroidArtifact mainArtifactInfo = androidModel.getMainArtifact();
                File classesFolder = mainArtifactInfo.getClassesFolder();
                if (classesFolder == null) {
                    AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifactInfo);
                    File file = output.getMainOutputFile().getOutputFile();
                    File buildFolder = file.getParentFile().getParentFile();
                    classesFolder = new File(buildFolder, "classes");
                }
                if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (vOutFolder = LocalFileSystem.getInstance().findFileByIoFile(outFolder)) != null && (localClass = this.loadClassFromClassPath(name, VfsUtilCore.virtualToIoFile((VirtualFile)vOutFolder))) != null) {
                    return localClass;
                }
            }
            return null;
        }
        return this.loadClassFromClassPath(name, VfsUtilCore.virtualToIoFile((VirtualFile)vOutFolder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSourceModified(final String fqcn, Object myCredential) {
        File classFile = this.getClassFile(fqcn);
        if (classFile != null) {
            boolean token = RenderSecurityManager.enterSafeRegion((Object)myCredential);
            try {
                VirtualFile virtualFile;
                long classFileModified = classFile.lastModified();
                if (classFileModified > 0L && (virtualFile = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                    public VirtualFile compute() {
                        PsiFile containingFile;
                        Project project = ModuleClassLoader.this.myModule.getProject();
                        GlobalSearchScope scope = ModuleClassLoader.this.myModule.getModuleWithDependenciesScope();
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
                        PsiClass source = psiFacade.findClass(fqcn, scope);
                        if (source != null && (containingFile = source.getContainingFile()) != null) {
                            return containingFile.getVirtualFile();
                        }
                        return null;
                    }
                })) != null && !"R.java".equals(virtualFile.getName())) {
                    boolean modified = FileDocumentManager.getInstance().isFileModified(virtualFile);
                    if (!modified) {
                        long lastBuildTimestamp;
                        File sourceFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                        long sourceFileModified = sourceFile.lastModified();
                        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
                        long l = lastBuildTimestamp = facet != null && facet.requiresAndroidModel() ? PostProjectBuildTasksExecutor.getInstance(this.myModule.getProject()).getLastBuildTimestamp() : classFileModified;
                        if (sourceFileModified > lastBuildTimestamp && lastBuildTimestamp != -1L) {
                            modified = true;
                        }
                    }
                    boolean bl = modified;
                    return bl;
                }
            }
            finally {
                RenderSecurityManager.exitSafeRegion((boolean)token);
            }
        }
        return false;
    }

    @Override
    protected Class<?> loadClassFile(String fqcn, File classFile) {
        if (this.myClassFiles == null) {
            this.myClassFiles = Maps.newHashMap();
            this.myLoadedTimestamp = Maps.newHashMap();
        }
        this.myClassFiles.put(fqcn, classFile);
        this.myLoadedTimestamp.put(fqcn, classFile.lastModified());
        return super.loadClassFile(fqcn, classFile);
    }

    @Override
    protected List<URL> getExternalJars() {
        ArrayList<URL> result = new ArrayList<URL>();
        URL customWidgetsUrl = ThemeEditorUtils.getCustomWidgetsJarUrl();
        if (customWidgetsUrl != null) {
            result.add(customWidgetsUrl);
        }
        for (VirtualFile libFile : AndroidRootUtil.getExternalLibraries(this.myModule)) {
            File file;
            if (!"jar".equals(libFile.getExtension()) || !(file = new File(libFile.getPath())).exists()) continue;
            try {
                AppResourceRepository appResources;
                result.add(SdkUtils.fileToUrl((File)file));
                File aarDir = file.getParentFile();
                if (aarDir == null || !aarDir.getPath().endsWith(".aar") && !aarDir.getPath().contains("exploded-aar")) continue;
                if (aarDir.getPath().contains("exploded-aar") && "jars".equals(aarDir.getName())) {
                    aarDir = aarDir.getParentFile();
                }
                if ((appResources = AppResourceRepository.getAppResources(this.myModule, true)) == null) continue;
                AarResourceClassRegistry.get(this.myModule.getProject()).addLibrary(appResources, aarDir);
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result;
    }

    public File getClassFile(String className) {
        return this.myClassFiles != null ? this.myClassFiles.get(className) : null;
    }

    private boolean isUpToDate() {
        if (this.myClassFiles != null) {
            for (Map.Entry<String, File> entry : this.myClassFiles.entrySet()) {
                String className = entry.getKey();
                File classFile = entry.getValue();
                Long timestamp = this.myLoadedTimestamp.get(className);
                if (timestamp == null) continue;
                long loadedModifiedTime = timestamp;
                long classFileModified = classFile.lastModified();
                if (classFileModified <= 0L || loadedModifiedTime <= 0L || loadedModifiedTime >= classFileModified) continue;
                return false;
            }
        }
        return true;
    }

    public static ModuleClassLoader get(LayoutLibrary library, Module module) {
        ModuleClassLoader loader = (ModuleClassLoader)ourCache.get((Object)module);
        if (loader != null) {
            if (library != loader.myLibrary) {
                loader = null;
            } else if (!loader.isUpToDate()) {
                loader = null;
            } else {
                List<URL> updatedJarDependencies = loader.getExternalJars();
                if (loader.myJarClassLoader != null && !((Object)updatedJarDependencies).equals(loader.myJarClassLoader.getUrls())) {
                    loader.myJarClassLoader = loader.createClassLoader(updatedJarDependencies);
                }
            }
        }
        if (loader == null) {
            loader = new ModuleClassLoader(library, module);
            ourCache.put((Object)module, (Object)loader);
        }
        return loader;
    }

    public static void clearCache() {
        ourCache.clear();
    }

    public static void clearCache(Module module) {
        if (ourCache.containsKey((Object)module)) {
            ourCache.remove((Object)module);
        }
    }
}

